//
// ========================================================================
// Copyright (c) 1995 Mort Bay Consulting Pty Ltd and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// https://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
// which is available at https://www.apache.org/licenses/LICENSE-2.0.
//
// SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
// ========================================================================
//

package org.eclipse.jetty.http.spi;

public final class LoggingUtil
{
    /**
     * It's easier to setup logging in code for this test project,
     * then it is to setup the various system properties and files for every test
     * execution (maven, CI, and IDE).
     */
    public static void init()
    {
        // Wire up java.util.logging (used by javax.xml.soap others) to slf4j.
        org.slf4j.bridge.SLF4JBridgeHandler.removeHandlersForRootLogger();
        org.slf4j.bridge.SLF4JBridgeHandler.install();
    }

    public static void end()
    {
        org.slf4j.bridge.SLF4JBridgeHandler.uninstall();
    }
}
