# 2022-05-17 Triage Log

It was a somewhat quiet week with real-world benchmarks showing a slight improvement on average and only one real-world crate, `bitmaps`, experiencing regressions. Unfortunately, the cause of the regressions don't look straightforward though. The biggest performance win came from a change to not encode attributes in metadata that are only used within the local crate. This improved doc builds of 16 of the 18 real world crates we run in our performance suite!

Triage done by **@rylev**.
Revision range: [c51871..7355d](https://perf.rust-lang.org/?start=c51871c469f7ed3b35ae25d7e6e77bc73fbdd0e3&end=7355d971a954ed63293e4191f6677f60c1bc07d9&absolute=false&stat=instructions%3Au)

**Summary**:

|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 7                              | 9                                | 40                              | 43                                | 47                       |
| mean       | 1.6%                           | 2.6%                             | -0.6%                           | -1.3%                             | -0.3%                    |
| max        | 1.9%                           | 3.5%                             | -2.6%                           | -2.6%                             | -2.6%                    |


2 Regressions, 4 Improvements, 0 Mixed; 0 of them in rollups
51 artifact comparisons made in total

#### Regressions

Add EarlyBinder [#96883](https://github.com/rust-lang/rust/pull/96883) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=70b3681bf621bc0de91ffab711b2350068b4c466&end=2a8a0fc4237da544aca0d6631ee467891caad9ad&stat=instructions:u)

|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 7                              | 0                                | 0                               | 0                                 | 7                        |
| mean       | 1.7%                           | N/A                              | N/A                             | N/A                               | 1.7%                     |
| max        | 2.0%                           | N/A                              | N/A                             | N/A                               | 2.0%                     |
- Regressions are exclusively in bitmaps-3.1.0 in both full and incr-full scenarios. This benchmark stresses trait related code in the compiler.
- Looks like `specialization_graph_of` is taking more time which is trait related so it makes sense.
- Left a [comment](https://github.com/rust-lang/rust/pull/96883#issuecomment-1128895889) asking if anyone has any more clues.


 Retire `ItemLikeVisitor` trait [#96825](https://github.com/rust-lang/rust/pull/96825) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1e8cd63d60d55361ae0a62ce87280171d40b6d32&end=7355d971a954ed63293e4191f6677f60c1bc07d9&stat=instructions:u)

|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 0                              | 6                                | 0                               | 5                                 | 0                        |
| mean       | N/A                            | 4.2%                             | N/A                             | -0.3%                             | N/A                      |
| max        | N/A                            | 4.8%                             | N/A                             | -0.4%                             | N/A                      |
- This regression seems to be taking place exclusively in the `externs` stress test. 
- The `native_library_kind` query is being hit more often. Since that query is going to be used a lot in the `externs` crate, it makes sense it would be the one to show regressions. 
- The cachegrind diff for `externs debug full` shows a big regression in calls to `rustc_metadata::rmeta::decoder::cstore_impl::provide` which calls into [`native_library_kind`](https://github.com/rust-lang/rust/blob/735efc0c703812343a5e5d19b600dac73b8a89f0/compiler/rustc_metadata/src/rmeta/decoder/cstore_impl.rs#L261). 
- [Left a comment](https://github.com/rust-lang/rust/pull/96825#issuecomment-1128886179) asking why that might be the case.



#### Improvements

don't encode only locally used attrs [#95562](https://github.com/rust-lang/rust/pull/95562) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=18bd2dd5cda08b09ace6e37c1a0312e9b2bb4beb&end=481db40311cdd241ae4d33f34f2f75732e44d8e8&stat=instructions:u)

|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 0                              | 0                                | 22                              | 23                                | 22                       |
| mean       | N/A                            | N/A                              | -0.8%                           | -1.8%                             | -0.8%                    |
| max        | N/A                            | N/A                              | -2.7%                           | -2.8%                             | -2.7%                    |


rustc: Stricter checking for #[link] attributes [#96885](https://github.com/rust-lang/rust/pull/96885) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e1ec3260d79497080ca86540562d410ba67d2a95&end=10b3a0d209746e70fdc72f65e4649d492f6ed5a2&stat=instructions:u)

|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 0                              | 0                                | 0                               | 9                                 | 0                        |
| mean       | N/A                            | N/A                              | N/A                             | -0.8%                             | N/A                      |
| max        | N/A                            | N/A                              | N/A                             | -1.2%                             | N/A                      |


optimize `insert_range` method of `IntervalSet` [#96895](https://github.com/rust-lang/rust/pull/96895) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a170f2b3d2aa95e51040163e801123b17d38c24f&end=0f202d22c5e759062de276cbf0c27ed69794cb65&stat=instructions:u)

|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 0                              | 0                                | 0                               | 6                                 | 0                        |
| mean       | N/A                            | N/A                              | N/A                             | -1.3%                             | N/A                      |
| max        | N/A                            | N/A                              | N/A                             | -2.4%                             | N/A                      |


Clean up derived obligation creation [#96892](https://github.com/rust-lang/rust/pull/96892) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c1cfdd1fb225d64e78b8d8cbab83564ac2dd5ec2&end=c1d65eaa456d3986e38868e68e6ce25d802f06b4&stat=instructions:u)

|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 0                              | 0                                | 3                               | 1                                 | 3                        |
| mean       | N/A                            | N/A                              | -0.4%                           | -0.4%                             | -0.4%                    |
| max        | N/A                            | N/A                              | -0.6%                           | -0.4%                             | -0.6%                    |

