#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Bit.Trip Beat
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250702.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='bit-trip-beat'
GAME_NAME='BIT.TRIP BEAT'

ARCHIVE_BASE_0_NAME='gog_bit_trip_beat_2.0.0.1.sh'
ARCHIVE_BASE_0_MD5='32b6fd23c32553aa7c50eaf4247ba664'
ARCHIVE_BASE_0_SIZE='120000'
ARCHIVE_BASE_0_VERSION='1.0.5-gog2.0.0.1'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/bittrip_beat'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN_FILES='
bit.trip.beat'
CONTENT_GAME_BIN64_RELATIVE_PATH='bit.trip.beat-1.0-64/bit.trip.beat'
CONTENT_GAME_BIN64_FILES="$CONTENT_GAME_BIN_FILES"
CONTENT_GAME_BIN32_RELATIVE_PATH='bit.trip.beat-1.0-32/bit.trip.beat'
CONTENT_GAME_BIN32_FILES="$CONTENT_GAME_BIN_FILES"
CONTENT_GAME_DATA_RELATIVE_PATH='bit.trip.beat-1.0-64/bit.trip.beat'
CONTENT_GAME_DATA_FILES='
Effects
Fonts
Sounds
Models
Shaders
Textures
BEAT.png'
CONTENT_DOC_DATA_RELATIVE_PATH='bit.trip.beat-1.0-64'
CONTENT_DOC_DATA_FILES='
README*
*.txt'

APP_MAIN_EXE='bit.trip.beat'
APP_MAIN_ICON='bit.trip.beat-1.0-64/bit.trip.beat/BEAT.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libgcc_s.so.1
libGL.so.1
libm.so.6
libogg.so.0
libopenal.so.1
libpthread.so.0
librt.so.1
libSDL-1.2.so.0
libstdc++.so.6
libvorbisfile.so.3
libvorbis.so.0
libz.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
