# Generated by Django 2.2 on 2019-05-27 15:40

import core.models
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import tastypie.utils.timezone
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AutoNowNote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('slug', models.SlugField(unique=True)),
                ('content', models.TextField(blank=True)),
                ('is_active', models.BooleanField(blank=True, default=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Counter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('slug', models.SlugField(unique=True)),
                ('count', models.PositiveIntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='DateRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField()),
                ('username', models.CharField(max_length=20)),
                ('message', models.CharField(max_length=20)),
            ],
        ),
        migrations.CreateModel(
            name='MyDefaultPKModel',
            fields=[
                ('id', models.IntegerField(default=core.models.get_next, editable=False, primary_key=True, serialize=False)),
                ('content', models.TextField(blank=True, default='')),
            ],
        ),
        migrations.CreateModel(
            name='MyUUIDModel',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('anotheruuid', models.UUIDField(default=uuid.uuid4)),
                ('content', models.TextField(blank=True, default='')),
                ('order', models.IntegerField(blank=True, default=0)),
            ],
            options={
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='Note',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100, verbose_name='The Title')),
                ('slug', models.SlugField()),
                ('content', models.TextField(blank=True)),
                ('is_active', models.BooleanField(blank=True, default=True)),
                ('created', models.DateTimeField(default=tastypie.utils.timezone.now)),
                ('updated', models.DateTimeField(default=tastypie.utils.timezone.now)),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='notes', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Subject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('url', models.URLField()),
                ('created', models.DateTimeField(default=tastypie.utils.timezone.now)),
                ('notes', models.ManyToManyField(related_name='subjects', to='core.Note')),
            ],
        ),
        migrations.CreateModel(
            name='MyRelatedUUIDModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content', models.TextField(blank=True, default='')),
                ('myuuidmodels', models.ManyToManyField(to='core.MyUUIDModel')),
            ],
        ),
        migrations.CreateModel(
            name='MediaBit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=32)),
                ('image', models.FileField(blank=True, null=True, upload_to='bits/')),
                ('note', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='media_bits', to='core.Note')),
            ],
        ),
        migrations.CreateModel(
            name='NoteWithEditor',
            fields=[
                ('note_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.Note')),
                ('editor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notes_edited', to=settings.AUTH_USER_MODEL)),
            ],
            bases=('core.note',),
        ),
        migrations.CreateModel(
            name='BigAutoNowModel',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='MyContainerModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=128, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='MyContainerItemModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=128, null=True)),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='item_set',
                                             to='core.mycontainermodel')),
            ],
        ),
        migrations.CreateModel(
            name='MyContainerItemGroupingModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('grouping_item',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.mycontaineritemmodel')),
                ('parent',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='item_grouping_set',
                                   to='core.mycontainermodel')),
            ],
        ),
    ]
