//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ListSqlPoolVulnerabilityAssessments.json
func ExampleSQLPoolVulnerabilityAssessmentsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSQLPoolVulnerabilityAssessmentsClient().NewListPager("vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SQLPoolVulnerabilityAssessmentListResult = armsynapse.SQLPoolVulnerabilityAssessmentListResult{
		// 	Value: []*armsynapse.SQLPoolVulnerabilityAssessment{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Synapse/workspaces/vulnerabilityaseessmenttest-6440/sqlPools/testdb/vulnerabilityAssessments/default"),
		// 			Properties: &armsynapse.SQLPoolVulnerabilityAssessmentProperties{
		// 				RecurringScans: &armsynapse.VulnerabilityAssessmentRecurringScansProperties{
		// 					EmailSubscriptionAdmins: to.Ptr(true),
		// 					Emails: []*string{
		// 						to.Ptr("email1@mail.com"),
		// 						to.Ptr("email2@mail.com")},
		// 						IsEnabled: to.Ptr(true),
		// 					},
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetSqlPoolVulnerabilityAssessment.json
func ExampleSQLPoolVulnerabilityAssessmentsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLPoolVulnerabilityAssessmentsClient().Get(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsynapse.VulnerabilityAssessmentNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SQLPoolVulnerabilityAssessment = armsynapse.SQLPoolVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Synapse/workspaces/vulnerabilityaseessmenttest-6440/sqlPools/testdb/vulnerabilityAssessments/default"),
	// 	Properties: &armsynapse.SQLPoolVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsynapse.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(true),
	// 			Emails: []*string{
	// 				to.Ptr("email1@mail.com"),
	// 				to.Ptr("email2@mail.com")},
	// 				IsEnabled: to.Ptr(true),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateSqlPoolVulnerabilityAssessmentWithAllParameters.json
func ExampleSQLPoolVulnerabilityAssessmentsClient_CreateOrUpdate_createADatabasesVulnerabilityAssessmentWithAllParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLPoolVulnerabilityAssessmentsClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsynapse.VulnerabilityAssessmentNameDefault, armsynapse.SQLPoolVulnerabilityAssessment{
		Properties: &armsynapse.SQLPoolVulnerabilityAssessmentProperties{
			RecurringScans: &armsynapse.VulnerabilityAssessmentRecurringScansProperties{
				EmailSubscriptionAdmins: to.Ptr(true),
				Emails: []*string{
					to.Ptr("email1@mail.com"),
					to.Ptr("email2@mail.com")},
				IsEnabled: to.Ptr(true),
			},
			StorageAccountAccessKey: to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
			StorageContainerPath:    to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
			StorageContainerSasKey:  to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SQLPoolVulnerabilityAssessment = armsynapse.SQLPoolVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Synapse/workspaces/vulnerabilityaseessmenttest-6440/sqlPools/testdb/vulnerabilityAssessments/default"),
	// 	Properties: &armsynapse.SQLPoolVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsynapse.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(true),
	// 			Emails: []*string{
	// 				to.Ptr("email1@mail.com"),
	// 				to.Ptr("email2@mail.com")},
	// 				IsEnabled: to.Ptr(true),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateVulnerabilityAssessmentWithStorageAccessKeyAndMinParameters.json
func ExampleSQLPoolVulnerabilityAssessmentsClient_CreateOrUpdate_createADatabasesVulnerabilityAssessmentWithMinimalParametersWhenStorageAccountAccessKeyIsSpecified() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLPoolVulnerabilityAssessmentsClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsynapse.VulnerabilityAssessmentNameDefault, armsynapse.SQLPoolVulnerabilityAssessment{
		Properties: &armsynapse.SQLPoolVulnerabilityAssessmentProperties{
			StorageAccountAccessKey: to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
			StorageContainerPath:    to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SQLPoolVulnerabilityAssessment = armsynapse.SQLPoolVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/Microsoft.Synapse/workspaces/vulnerabilityaseessmenttest-6440/sqlPools/testdb/vulnerabilityAssessments/default"),
	// 	Properties: &armsynapse.SQLPoolVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsynapse.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(false),
	// 			Emails: []*string{
	// 			},
	// 			IsEnabled: to.Ptr(true),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateSqlPoolVulnerabilityAssessmentWithContainerSasKeyAndMinParameters.json
func ExampleSQLPoolVulnerabilityAssessmentsClient_CreateOrUpdate_createADatabasesVulnerabilityAssessmentWithMinimalParametersWhenStorageContainerSasKeyIsSpecified() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLPoolVulnerabilityAssessmentsClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsynapse.VulnerabilityAssessmentNameDefault, armsynapse.SQLPoolVulnerabilityAssessment{
		Properties: &armsynapse.SQLPoolVulnerabilityAssessmentProperties{
			StorageContainerPath:   to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
			StorageContainerSasKey: to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SQLPoolVulnerabilityAssessment = armsynapse.SQLPoolVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Synapse/workspaces/vulnerabilityaseessmenttest-6440/sqlPools/testdb/vulnerabilityAssessments/default"),
	// 	Properties: &armsynapse.SQLPoolVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsynapse.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(false),
	// 			Emails: []*string{
	// 			},
	// 			IsEnabled: to.Ptr(true),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DeleteSqlPoolVulnerabilityAssessment.json
func ExampleSQLPoolVulnerabilityAssessmentsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewSQLPoolVulnerabilityAssessmentsClient().Delete(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsynapse.VulnerabilityAssessmentNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
