/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.lucene.search.similarities;

import java.util.Random;
import org.apache.lucene.tests.search.similarities.BaseSimilarityTestCase;

public class TestLMJelinekMercerSimilarity extends BaseSimilarityTestCase {

  @Override
  protected final Similarity getSimilarity(Random random) {
    // smoothing parameter lambda: (0..1]
    final float lambda;
    switch (random.nextInt(3)) {
      case 0:
        // tiny value
        lambda = Float.MIN_VALUE;
        break;
      case 1:
        // maximum value
        lambda = 1;
        break;
      default:
        // random value
        lambda = random.nextFloat();
        break;
    }
    return new LMJelinekMercerSimilarity(lambda);
  }
}
