/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.services.db.TurbineDB;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.IdGenerator;
import org.apache.turbine.util.db.map.DatabaseMap;
import org.apache.turbine.util.db.map.TableMap;
import org.apache.turbine.util.db.pool.DBConnection;

public class IDBroker
implements Runnable,
IdGenerator {
    public static final String TABLE_NAME = "ID_TABLE.TABLE_NAME";
    public static final String NEXT_ID = "ID_TABLE.NEXT_ID";
    public static final String QUANTITY = "ID_TABLE.QUANTITY";
    private static final int DEFAULT_SIZE = 40;
    private static final int sleepPeriod = 60000;
    private static final float safetyMargin = 1.2f;
    private static final BigDecimal ONE = new BigDecimal("1");
    private TableMap tableMap;
    private Hashtable ids;
    private Hashtable quantityStore;
    private Hashtable lastQueryTime;
    private Thread houseKeeperThread;
    private boolean transactionsSupported;

    public int getIdAsInt(Connection connection, Object tableName) throws Exception {
        return this.getIdAsBigDecimal(null, tableName).intValue();
    }

    public long getIdAsLong(Connection connection, Object tableName) throws Exception {
        return this.getIdAsBigDecimal(null, tableName).longValue();
    }

    public BigDecimal getIdAsBigDecimal(Connection connection, Object tableName) throws Exception {
        BigDecimal[] id = this.getNextIds((String)tableName, 1);
        return id[0];
    }

    public String getIdAsString(Connection connection, Object tableName) throws Exception {
        return this.getIdAsBigDecimal(null, tableName).toString();
    }

    public boolean isPriorToInsert() {
        return true;
    }

    public boolean isPostInsert() {
        return false;
    }

    public boolean isConnectionRequired() {
        return false;
    }

    public synchronized BigDecimal[] getNextIds(String tableName, int numOfIdsToReturn) throws Exception {
        List availableIds = (List)this.ids.get(tableName);
        if (availableIds == null || availableIds.size() < numOfIdsToReturn) {
            if (availableIds == null) {
                Log.info("Forced id retrieval - no available vector");
            } else {
                Log.info("Forced id retrieval - " + availableIds.size());
            }
            this.storeIDs(tableName, true);
            availableIds = (List)this.ids.get(tableName);
        }
        int size = availableIds.size() < numOfIdsToReturn ? availableIds.size() : numOfIdsToReturn;
        BigDecimal[] results = new BigDecimal[size];
        int i = size - 1;
        while (i >= 0) {
            results[i] = (BigDecimal)availableIds.get(i);
            availableIds.remove(i);
            --i;
        }
        return results;
    }

    public void run() {
        Log.info("IDBroker thread was started.");
        Thread thisThread = Thread.currentThread();
        while (this.houseKeeperThread == thisThread) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException exc) {
                // empty catch block
            }
            Enumeration e = this.ids.keys();
            while (e.hasMoreElements()) {
                String tableName = (String)e.nextElement();
                Log.info("IDBroker thread checking for more keys on table: " + tableName);
                List availableIds = (List)this.ids.get(tableName);
                int quantity = this.getQuantity(tableName).intValue();
                if (quantity <= availableIds.size()) continue;
                try {
                    this.storeIDs(tableName, false);
                    Log.info("Retrieved more ids for table: " + tableName);
                }
                catch (Exception exc) {
                    Log.error("There was a problem getting new IDs for table: " + tableName, exc);
                }
            }
        }
        Log.info("IDBroker thread finished.");
    }

    public void stop() {
        this.houseKeeperThread = null;
    }

    private void checkTiming(String tableName) {
        if (!TurbineResources.getBoolean("database.idbroker.cleverquantity", true)) {
            return;
        }
        Date lastTime = (Date)this.lastQueryTime.get(tableName);
        Date now = new Date();
        if (lastTime != null) {
            long thenLong = lastTime.getTime();
            long nowLong = now.getTime();
            int timeLapse = (int)(nowLong - thenLong);
            if (timeLapse < 60000) {
                Log.info("Unscheduled retrieval of more ids for table: " + tableName);
                float rate = this.getQuantity(tableName).floatValue() / (float)timeLapse;
                this.quantityStore.put(tableName, new BigDecimal(Math.ceil(60000.0f * rate * 1.2f)));
            }
        }
        this.lastQueryTime.put(tableName, now);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeIDs(String tableName, boolean adjustQuantity) throws Exception {
        ArrayList<BigDecimal> availableIds;
        BigDecimal quantity;
        BigDecimal nextId;
        block11: {
            nextId = null;
            quantity = null;
            DatabaseMap dbMap = this.tableMap.getDatabaseMap();
            TableMap tMap = dbMap.getTable(tableName);
            if (adjustQuantity) {
                this.checkTiming(tableName);
            }
            DBConnection dbCon = null;
            try {
                try {
                    String databaseName = dbMap.getName();
                    dbCon = this.transactionsSupported ? BasePeer.beginTransaction(databaseName) : TurbineDB.getConnection(databaseName);
                    Connection connection = dbCon.getConnection();
                    quantity = this.getQuantity(tableName);
                    Criteria criteria = new Criteria(2).add(QUANTITY, quantity);
                    Criteria selectCriteria = new Criteria(2).add(TABLE_NAME, tableName);
                    criteria.setDbName(dbMap.getName());
                    selectCriteria.setDbName(dbMap.getName());
                    BasePeer.doUpdate(selectCriteria, criteria, dbCon);
                    BigDecimal[] results = this.selectRow(connection, tableName);
                    nextId = results[0];
                    BigDecimal newNextId = nextId.add(quantity);
                    this.updateRow(connection, tableName, newNextId.toString());
                    if (this.transactionsSupported) {
                        BasePeer.commitTransaction(dbCon);
                    }
                }
                catch (Exception e) {
                    if (this.transactionsSupported) {
                        BasePeer.rollBackTransaction(dbCon);
                    }
                    throw e;
                }
                Object var9_17 = null;
                if (this.transactionsSupported) break block11;
            }
            catch (Throwable throwable) {
                Object var9_18 = null;
                if (!this.transactionsSupported) {
                    TurbineDB.releaseConnection(dbCon);
                }
                throw throwable;
            }
            TurbineDB.releaseConnection(dbCon);
        }
        if ((availableIds = (ArrayList<BigDecimal>)this.ids.get(tableName)) == null) {
            availableIds = new ArrayList<BigDecimal>();
            this.ids.put(tableName, availableIds);
        }
        int numId = quantity.intValue();
        int i = 0;
        while (i < numId) {
            availableIds.add(nextId);
            nextId = nextId.add(ONE);
            ++i;
        }
        return;
    }

    /*
     * Loose catch block
     */
    private BigDecimal getQuantity(String tableName) {
        BigDecimal quantity;
        block10: {
            DBConnection dbCon;
            quantity = null;
            if (this.quantityStore.containsKey(tableName)) {
                quantity = (BigDecimal)this.quantityStore.get(tableName);
            } else {
                dbCon = null;
                String databaseName = this.tableMap.getDatabaseMap().getName();
                dbCon = TurbineDB.getConnection(databaseName);
                Connection connection = dbCon.getConnection();
                BigDecimal[] results = this.selectRow(connection, tableName);
                quantity = results[1];
                this.quantityStore.put(tableName, quantity);
                Object var5_10 = null;
                try {
                    TurbineDB.releaseConnection(dbCon);
                }
                catch (Exception e2) {
                    Log.error("Release of connection failed.", e2);
                }
            }
            break block10;
            {
                catch (Exception e) {
                    quantity = new BigDecimal(10.0);
                    Object var5_11 = null;
                    try {
                        TurbineDB.releaseConnection(dbCon);
                    }
                    catch (Exception e2) {
                        Log.error("Release of connection failed.", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_12 = null;
                try {
                    TurbineDB.releaseConnection(dbCon);
                }
                catch (Exception e2) {
                    Log.error("Release of connection failed.", e2);
                }
                throw throwable;
            }
        }
        return quantity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BigDecimal[] selectRow(Connection con, String tableName) throws Exception {
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT NEXT_ID, QUANTITY").append(" FROM ID_TABLE").append(" WHERE TABLE_NAME = '").append(tableName).append('\'');
        Statement statement = null;
        BigDecimal[] results = new BigDecimal[2];
        try {
            statement = con.createStatement();
            ResultSet rs = statement.executeQuery(stmt.toString());
            if (!rs.next()) {
                throw new TurbineException("The table " + tableName + " does not have a proper entry in the ID_TABLE");
            }
            results[0] = new BigDecimal(rs.getString(1));
            results[1] = new BigDecimal(rs.getString(2));
            Object var7_7 = null;
            if (statement == null) return results;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
        return results;
    }

    private void updateRow(Connection con, String tableName, String id) throws Exception {
        StringBuffer stmt = new StringBuffer(id.length() + tableName.length() + 50);
        stmt.append("UPDATE ID_TABLE").append(" SET next_id = ").append(id).append(" WHERE TABLE_NAME = '").append(tableName).append('\'');
        Statement statement = null;
        try {
            statement = con.createStatement();
            statement.executeUpdate(stmt.toString());
        }
        finally {
            Object var7_6 = null;
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * Loose catch block
     */
    public IDBroker(TableMap tMap) {
        String dbName;
        block9: {
            this.ids = new Hashtable(40);
            this.quantityStore = new Hashtable(40);
            this.lastQueryTime = new Hashtable(40);
            this.houseKeeperThread = null;
            this.transactionsSupported = false;
            this.tableMap = tMap;
            this.houseKeeperThread = new Thread(this);
            this.houseKeeperThread.setDaemon(true);
            this.houseKeeperThread.start();
            dbName = tMap.getDatabaseMap().getName();
            DBConnection dbCon = null;
            dbCon = TurbineDB.getConnection(dbName);
            this.transactionsSupported = dbCon.getConnection().getMetaData().supportsTransactions();
            Object var5_4 = null;
            try {
                TurbineDB.releaseConnection(dbCon);
            }
            catch (Exception e2) {}
            break block9;
            {
                catch (Exception e) {
                    this.transactionsSupported = false;
                    Object var5_5 = null;
                    try {
                        TurbineDB.releaseConnection(dbCon);
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    TurbineDB.releaseConnection(dbCon);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (!this.transactionsSupported) {
            Log.warn("IDBroker is being used with db: " + dbName + "\n which does not support transactions.  It is possible to " + "\n generate duplicate keys, if multiple JVM's are used or other " + "\n means are used to write to the database.");
        }
    }
}

