# 2025-09-23 Triage Log

Moving command-line argument quoting from C++ to Rust ([#146700](https://github.com/rust-lang/rust/pull/146700)) resulted in a nice performance
win when dealing with many dependencies and large workspaces. A somewhat costly destination propagation
compiler pass was enabled by default ([#142915](https://github.com/rust-lang/rust/pull/142915)), which resulted in some build time regressions,
but should result in improved runtime performance. The rest of changes were small.

Triage done by **@kobzol**.
Revision range: [52618eb3..ce4beebe](https://perf.rust-lang.org/?start=52618eb338609df44978b0ca4451ab7941fd1c7a&end=ce4beebecb77821734079cff47d8af08f9f27f11&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 1.9%]    | 61    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.1%, 3.4%]    | 90    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.9%, -0.2%]  | 29    |
| Improvements ✅ <br /> (secondary) | -1.3% | [-22.8%, -0.1%] | 71    |
| All ❌✅ (primary)                 | 0.0%  | [-1.9%, 1.9%]   | 90    |


1 Regression, 4 Improvements, 4 Mixed; 4 of them in rollups
37 artifact comparisons made in total

#### Regressions

Rollup of 5 pull requests [#146698](https://github.com/rust-lang/rust/pull/146698) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=93117677d857bb7c3f12c9dc500d77839f8fb13d&end=4793ef5cf527339f072c39d129477ad5bb678f9e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.2%] | 2     |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.1%, 0.2%] | 16    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.2%] | 2     |

- From the perf. runs it looks like the tiny regressions are distributed amongst multiple PRs. Given that most of them are in secondary benchmarks, and those benchmarks were going a bit up and down recently, I don't think it's worth to dig deeper here.
- Marked as triaged. 

#### Improvements

Prevent ABI changes affect EnzymeAD [#142544](https://github.com/rust-lang/rust/pull/142544) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4793ef5cf527339f072c39d129477ad5bb678f9e&end=97a987f14c5bd948f7ee8dba75999f104a6f03a7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.0%, 0.3%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.1%] | 18    |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 1     |


Clippy subtree update [#146728](https://github.com/rust-lang/rust/pull/146728) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0c0c58b8e453f552ebd7f3a1545acdd109de028c&end=7c275d09ea6b953d2cca169667184a7214bd14c7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.9% | [-2.9%, -2.9%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -2.9% | [-2.9%, -2.9%] | 1     |


GVN: stop hashing opaque values [#145737](https://github.com/rust-lang/rust/pull/145737) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2f4dfc753fd86c672aa4145940db075a8a149f17&end=e10aa8891182378de002bd71bf4d04181fb8231d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.7% | [-1.9%, -1.5%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.4%, -1.4%] | 1     |
| All ❌✅ (primary)                 | -1.7% | [-1.9%, -1.5%] | 2     |


cg_llvm: Move target machine command-line quoting from C++ to Rust [#146700](https://github.com/rust-lang/rust/pull/146700) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=59043567a5cf12800e1457c36ad6a6b0fa02c6b6&end=0be8e16088894483a7012c5026c3247c14a0c3c2&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.2%]  | 4     |
| Improvements ✅ <br /> (secondary) | -3.0% | [-23.4%, -0.2%] | 16    |
| All ❌✅ (primary)                 | -0.4% | [-0.6%, -0.2%]  | 4     |


#### Mixed

Rollup of 9 pull requests [#146614](https://github.com/rust-lang/rust/pull/146614) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9d82de19dfae60e55c291f5f28e28cfc2c1b9630&end=8a1b39995e5b630c5872f5de5079f1f569bd5ac2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 3.7%  | [3.0%, 4.2%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.0%] | 6     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 2     |

- The regression in compile-time function evaluation was caused by [#146402](https://github.com/rust-lang/rust/pull/146402), which is a fix.
- Marked as triaged.

Enable DestinationPropagation by default [#142915](https://github.com/rust-lang/rust/pull/142915) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2ebb1263e3506412889410b567fa813ca3cb5c63&end=ce6daf3d5a5bffb2a00264197f92dc31608df0da&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 1.1%]   | 62    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 1.6%]   | 98    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.7%, -0.1%] | 31    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-2.5%, -0.1%] | 60    |
| All ❌✅ (primary)                 | 0.0%  | [-1.7%, 1.1%]  | 93    |

- The compile-time effects seem to be a wash, while this nicely reduced the binary size of the compiler itself, and is expected to improve runtime performance.
- Marked as triaged.

Rollup of 8 pull requests [#146830](https://github.com/rust-lang/rust/pull/146830) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=dd7fda570040e8a736f7d8bc28ddd1b444aabc82&end=dfa22235d858086511bedc4acde9db1c045ffbac&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.2%]   | 4     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.1%] | 2     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 1     |

- There's one tiny regression on a primary check benchmark, it doesn't seem worth it to investigate further.
- Marked as triaged.

Rollup of 9 pull requests [#146879](https://github.com/rust-lang/rust/pull/146879) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9f32ccf35fb877270bc44a86a126440f04d676d0&end=29005cb128e6d447e6bd9c110c9a684665f95985&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.1%, 0.5%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 7     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 1     |

- Seems like noise returning back, similar results to other rollups, just in the other direction.
- Marked as triaged.
