<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\Serializer\Tests\CacheWarmer;

use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\IgnoreDeprecations;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerInterface;
use Symfony\Component\Serializer\CacheWarmer\CompiledClassMetadataCacheWarmer;
use Symfony\Component\Serializer\Mapping\Factory\ClassMetadataFactory;
use Symfony\Component\Serializer\Mapping\Factory\ClassMetadataFactoryCompiler;
use Symfony\Component\Serializer\Mapping\Loader\AttributeLoader;

#[IgnoreDeprecations]
#[Group('legacy')]
final class CompiledClassMetadataCacheWarmerTest extends TestCase
{
    public function testItImplementsCacheWarmerInterface()
    {
        $compiledClassMetadataCacheWarmer = new CompiledClassMetadataCacheWarmer([], new ClassMetadataFactory(new AttributeLoader()), new ClassMetadataFactoryCompiler(), new Filesystem());

        $this->assertInstanceOf(CacheWarmerInterface::class, $compiledClassMetadataCacheWarmer);
    }

    public function testItIsAnOptionalCacheWarmer()
    {
        $compiledClassMetadataCacheWarmer = new CompiledClassMetadataCacheWarmer([], new ClassMetadataFactory(new AttributeLoader()), new ClassMetadataFactoryCompiler(), new Filesystem());

        $this->assertTrue($compiledClassMetadataCacheWarmer->isOptional());
    }

    public function testItDumpCompiledClassMetadatas()
    {
        $code = <<<EOF
            <?php

            // This file has been auto-generated by the Symfony Serializer Component.

            return [
            ];
            EOF;

        $filesystem = $this->createMock(Filesystem::class);
        $filesystem
            ->expects($this->once())
            ->method('dumpFile')
            ->with('/var/cache/prod/serializer.class.metadata.php', $code)
        ;

        $compiledClassMetadataCacheWarmer = new CompiledClassMetadataCacheWarmer([], new ClassMetadataFactory(new AttributeLoader()), new ClassMetadataFactoryCompiler(), $filesystem);

        $compiledClassMetadataCacheWarmer->warmUp('/var/cache/prod');
    }
}
