
## Version 1.5.3 [ETL] [core] [studio]

- [`78e866c`](https://github.com/synfig/synfig/commit/78e866cde56d844b1d2b66d83b5de7249788d0ab) chore: Fix [#3398](https://github.com/synfig/synfig/issues/3398) - Missing install-sh script on MacOS ([#3408](https://github.com/synfig/synfig/issues/3408)) [core] [studio]
- [`efeeda8`](https://github.com/synfig/synfig/commit/efeeda8c0925ef8e075a454264ae177cb2539bb7) refactor: clean up Bevel layer ([#3394](https://github.com/synfig/synfig/issues/3394)) [core]
- [`6cdaa8c`](https://github.com/synfig/synfig/commit/6cdaa8c2529fba5f66e0733d7d8ba68f4823b38f) chore: Make sure to update vcpkg.json on every release ([#3406](https://github.com/synfig/synfig/issues/3406))
- [`4422c5c`](https://github.com/synfig/synfig/commit/4422c5c95b4302afbe59dd2ef7ad6bb679487bde) Bump version to 1.5.3 ([#3402](https://github.com/synfig/synfig/issues/3402)) [ETL] [core] [studio]
- [`7f543c0`](https://github.com/synfig/synfig/commit/7f543c083000e1840e310391431adfc65e26877f) build(Github Actions): fix macOS build ([#3404](https://github.com/synfig/synfig/issues/3404))
- [`8d1d1f1`](https://github.com/synfig/synfig/commit/8d1d1f1ec298793a29c40028ed1bcb6d6c8f2b67) ci: Build source tarballs on self-hosted CI runner ([#3395](https://github.com/synfig/synfig/issues/3395))
- [`d6866a2`](https://github.com/synfig/synfig/commit/d6866a29c2a1c1f528ea8c8e0f9da014f318d9fd) chore: typo transfRomation -> transfoRmation ([#3397](https://github.com/synfig/synfig/issues/3397)) [core]
- [`11d95ff`](https://github.com/synfig/synfig/commit/11d95ffa7fa313063b9eff1b3678281418674235) chore: Fix generation of source packages using Autotools (again) ([#3400](https://github.com/synfig/synfig/issues/3400)) [core]
- [`f54fada`](https://github.com/synfig/synfig/commit/f54fadad55f2553d46d379ea08cff305cf99ad57) chore: Fix generation of source packages using Autotools ([#3399](https://github.com/synfig/synfig/issues/3399)) [ETL]
- [`ec3030f`](https://github.com/synfig/synfig/commit/ec3030ffd81937f016ffabe1f381086eea6626a2) build: fix macos build ([#3396](https://github.com/synfig/synfig/issues/3396))
- [`5714a7c`](https://github.com/synfig/synfig/commit/5714a7c421e7c21478d205f9b78e859428411fd7) chore: update Change Log for 1.4.5 ([#3359](https://github.com/synfig/synfig/issues/3359))
- [`bbdcfc1`](https://github.com/synfig/synfig/commit/bbdcfc1fc2bc84bafa5f80ea79605cb9b053e38f) perf: minor optimization of Bevel layer ([#3384](https://github.com/synfig/synfig/issues/3384)) [core]
- [`d281673`](https://github.com/synfig/synfig/commit/d2816730fd6e0a58785fd39571ec3f728e99c616) style: use of eof() and override for filesystem ([#3381](https://github.com/synfig/synfig/issues/3381)) [core]
- [`3f07959`](https://github.com/synfig/synfig/commit/3f0795986a0e0612f86695dade1ebd4f658d3c39) build: unify cmake build shell scripts ([#3370](https://github.com/synfig/synfig/issues/3370))
- [`04ba862`](https://github.com/synfig/synfig/commit/04ba862ed6bef63c1a83cd129a1ad6f3fe109a49) refactor: make surface[_etl]::blit_to() const ([#3369](https://github.com/synfig/synfig/issues/3369)) [core]
- [`ac93cec`](https://github.com/synfig/synfig/commit/ac93cec8fae45c123b5ac2164c077671c6d8564e) ci: Add CI action for OSX packaging script ([#3368](https://github.com/synfig/synfig/issues/3368))
- [`237d503`](https://github.com/synfig/synfig/commit/237d5032db163f1360647b9ff4ff45246b8155b8) build: update script for building with cmake ([#3355](https://github.com/synfig/synfig/issues/3355))
- [`9a589c5`](https://github.com/synfig/synfig/commit/9a589c5379d2a9ea0615342a84249e683812383f) refactor: remove broken (and unused) symlink ([#3365](https://github.com/synfig/synfig/issues/3365))
- [`ad15a64`](https://github.com/synfig/synfig/commit/ad15a64580f3d4516419033903aa65a47280cd4f) chore: avoid installation of unused sdl2_mixer ([#3367](https://github.com/synfig/synfig/issues/3367))
- [`e832255`](https://github.com/synfig/synfig/commit/e8322554c42075b5b4be647b19f6fd9aca367c10) perf(GUI): don't render frame thumbnails if disabled ([#3356](https://github.com/synfig/synfig/issues/3356)) [studio]
- [`3c3b5b4`](https://github.com/synfig/synfig/commit/3c3b5b4b8c4fcfe1854533082faafbe61d2fb3c9) chore: update ChangeLog for version 1.4.5 ([#3348](https://github.com/synfig/synfig/issues/3348))
- [`f0e7df3`](https://github.com/synfig/synfig/commit/f0e7df389abc6600714bb119d5a551bb1e1fb708) chore: removed zh-Hant locale as it has zero translations ([#3354](https://github.com/synfig/synfig/issues/3354)) [core] [studio]
- [`f6dc2ac`](https://github.com/synfig/synfig/commit/f6dc2aca804f124c897c6f013523502f889755b2) chore: Update Transifex config to APIv3 ([#3349](https://github.com/synfig/synfig/issues/3349))
- [`d51d65b`](https://github.com/synfig/synfig/commit/d51d65b81133e24329399f0185ba5fc79c035a4c) fix: build on OSX 10.9 ([#3353](https://github.com/synfig/synfig/issues/3353)) [core]
- [`2d542c9`](https://github.com/synfig/synfig/commit/2d542c98f4d498f5d616b4f7330622be7da42c70) refactor: port CurveWarp to Cobra renderer engine ([#3329](https://github.com/synfig/synfig/issues/3329)) [core]
- [`58f522e`](https://github.com/synfig/synfig/commit/58f522ec25d845ee7734dab0ca385a8ff5ccfd3c) fix(MotionBlur): undefined behavior when subsample range is 0 ([#3347](https://github.com/synfig/synfig/issues/3347)) [core]
- [`c8ea2c2`](https://github.com/synfig/synfig/commit/c8ea2c2ecbd5fd9e3ad9c6937b56a203aaa1d1ea) feat: added ability to set colors for a dark theme for curves ([#3346](https://github.com/synfig/synfig/issues/3346)) [studio]
- [`3c70fec`](https://github.com/synfig/synfig/commit/3c70fec324e36be898da18cee54d512535c6ecac) build: Add cmake to linux install script ([#3338](https://github.com/synfig/synfig/issues/3338))
- [`02781d6`](https://github.com/synfig/synfig/commit/02781d6fd42a43f88332bc08a748d6e8d6b35cab) chore: Add CONTRIBUTING.md and CODE_OF_CONDUCT.md ([#3335](https://github.com/synfig/synfig/issues/3335))
- [`5fd6653`](https://github.com/synfig/synfig/commit/5fd6653d90e59be0439fb5f6ed4a48d007db6d3f) build: fix typos on magickpp module ([#3333](https://github.com/synfig/synfig/issues/3333)) [core]
- [`1788462`](https://github.com/synfig/synfig/commit/17884628603c13c19ba11cbd5eafeb10955870db) fix: importing via magick++ for version >= 7.0.1 ([#3332](https://github.com/synfig/synfig/issues/3332)) [core]
- [`4348d65`](https://github.com/synfig/synfig/commit/4348d65b6adcee7bfad545e919145eec5b6cc4b4) fix: undo didn't work properly after deleting last guide line ([#3304](https://github.com/synfig/synfig/issues/3304)) [studio]
- [`e1f9a18`](https://github.com/synfig/synfig/commit/e1f9a1842e7f52e7b1e8ef75875ed20e4ad4bed7) refactor: remove unused variable ([#3322](https://github.com/synfig/synfig/issues/3322)) [core]
- [`655bdaa`](https://github.com/synfig/synfig/commit/655bdaab12b8a50fd63e0b834901777f6fd9d155) feat: add WebM video format to ffmpeg codecs list ([#3330](https://github.com/synfig/synfig/issues/3330)) [core] [studio]
- [`7f39534`](https://github.com/synfig/synfig/commit/7f39534c86faf005dae4ded1ac313d97e353c624) fix: adjust minimum panel size ([#3296](https://github.com/synfig/synfig/issues/3296)) [studio]
- [`5359626`](https://github.com/synfig/synfig/commit/53596268520617f74d142adf67abd4dad1353539) feat: add Magick++ as possible importer too ([#3323](https://github.com/synfig/synfig/issues/3323)) [core]
- [`b7e2cc5`](https://github.com/synfig/synfig/commit/b7e2cc528970242c02403ce8e490e855d2aff9a3) refactor: reduce scope of two variables ([#3321](https://github.com/synfig/synfig/issues/3321)) [core]
- [`6ed3374`](https://github.com/synfig/synfig/commit/6ed3374ecdeb926e6c3c2b217d1e6a6593971ac1) ci: caching logic changed ([#3319](https://github.com/synfig/synfig/issues/3319))
- [`a80fae9`](https://github.com/synfig/synfig/commit/a80fae97475b53b9384f0237dc64907543e61cae) ci: bump github actions version ([#3318](https://github.com/synfig/synfig/issues/3318))
- [`bc5d01b`](https://github.com/synfig/synfig/commit/bc5d01be26b0ebf3a4fe4625aa2f6f4a58352e5d) build: CMake sets wrong Synfig Studio/ETL versions ([#3315](https://github.com/synfig/synfig/issues/3315))
- [`2e06938`](https://github.com/synfig/synfig/commit/2e06938a43ebc5777f4dc9fb8f4e42a5c2a7095a) ci(commitlint): disabled rules for `subject-case` ([#3317](https://github.com/synfig/synfig/issues/3317))
- [`818b0a4`](https://github.com/synfig/synfig/commit/818b0a46ae377756bb2e3f672aab6c2abef480ea) fix: add fill-color instead of outline-color to palette ([#3314](https://github.com/synfig/synfig/issues/3314)) [studio]
- [`f0185bf`](https://github.com/synfig/synfig/commit/f0185bf29df8f05529a19610021a4672c2b57cab) chore: script version-bump.sh must update CMake files ([#3316](https://github.com/synfig/synfig/issues/3316))
- [`798e84e`](https://github.com/synfig/synfig/commit/798e84eb9a3822e01713cce193587348ee4ab2f4) fix: guide lines ignored on loading from old files ([#3303](https://github.com/synfig/synfig/issues/3303)) [core]
- [`0fa608d`](https://github.com/synfig/synfig/commit/0fa608d45b5efa95aa5d1a4c32e746f50cf68242) refactor: port layer to Cobra renderer: Metaballs ([#3305](https://github.com/synfig/synfig/issues/3305)) [core]
- [`ecc4068`](https://github.com/synfig/synfig/commit/ecc4068c32580f23c62391d892c2ae73628f7222) feat: add missing scroll bar to Paste Layer dialog ([#3310](https://github.com/synfig/synfig/issues/3310)) [studio]
- [`bbaf283`](https://github.com/synfig/synfig/commit/bbaf28350c3c4b5fb14249fcc23d9d43fd0c7978) fix: synfig::OS::RunPipeWin32::is_open() return on fail ([#3298](https://github.com/synfig/synfig/issues/3298)) [core]
- [`cdbb598`](https://github.com/synfig/synfig/commit/cdbb5983057a34d2f549a3ab47bff7dc81bc548b) feat: allow to change resource filepath in Canvas Dependencies dialog ([#3105](https://github.com/synfig/synfig/issues/3105)) [studio]
- [`09a8045`](https://github.com/synfig/synfig/commit/09a8045048ba766ae4ccf30cb33833eb89eac224) fix: no need to show "Icon" header text to Layers Panel ([#3244](https://github.com/synfig/synfig/issues/3244)) [studio]
- [`034ec88`](https://github.com/synfig/synfig/commit/034ec88a8d56d34ea8e0818a6ba9fb84bc418de2) fix: mingw cross-build ([#3291](https://github.com/synfig/synfig/issues/3291)) [core]
- [`9f6cea0`](https://github.com/synfig/synfig/commit/9f6cea0776c04212d837f4ee6b511d571b5ac35a) chore(build): add support for installing build dependencies in Red OS ([#3289](https://github.com/synfig/synfig/issues/3289))
- [`cb11697`](https://github.com/synfig/synfig/commit/cb11697a2f74b8b6fb44c8faf297b0d8965b8c0e) refactor: drop SIF file in Toolbox now uses filesystem::Path ([#3284](https://github.com/synfig/synfig/issues/3284)) [studio]
- [`9f525f1`](https://github.com/synfig/synfig/commit/9f525f1221d359a2ee2650cbacae218a84ce4671) feat: layers and parameters trees can now be styled with even/odd rows ([#3242](https://github.com/synfig/synfig/issues/3242)) [studio]
- [`b2e04c1`](https://github.com/synfig/synfig/commit/b2e04c1e6f7533f9e34115b3c1a3ae29e2d78fad) fix: use u8_str() instead of c_str() for filesystem::Path ([#3287](https://github.com/synfig/synfig/issues/3287)) [core]
- [`c1f4e6e`](https://github.com/synfig/synfig/commit/c1f4e6e8a60653ed585a055186769dba50488b43) fix: mouse clicks while dragging ducks prevent DRAG from resetting ([#3268](https://github.com/synfig/synfig/issues/3268)) [studio]
- [`280024c`](https://github.com/synfig/synfig/commit/280024c5149d2e4e1e7ab58a697265e86b812d0f) refactor: remove unused #include ([#3285](https://github.com/synfig/synfig/issues/3285)) [core]
- [`5c3e9bb`](https://github.com/synfig/synfig/commit/5c3e9bb422846ecaa3723770b0b0d681d28775ed) refactor: remove unused #include segment.h ([#3281](https://github.com/synfig/synfig/issues/3281)) [core]
- [`0489837`](https://github.com/synfig/synfig/commit/048983714026696a91bbf6938be0833b430fd6d8) fix: dropped image file doesn't load (broken conversion URI to file path on Win32) ([#3280](https://github.com/synfig/synfig/issues/3280)) [core] [studio]
- [`5e40169`](https://github.com/synfig/synfig/commit/5e40169c9ed34ddbf667a5ea0907e429b6b71c59) fix: memory leak when the load default palette button is repeatedly pressed ([#2633](https://github.com/synfig/synfig/issues/2633)) [studio]
- [`1cef34f`](https://github.com/synfig/synfig/commit/1cef34f350ea0d9a8f5c3675a47e7f88336d64d5) fix: store a more precise distance value on settings file ([#3278](https://github.com/synfig/synfig/issues/3278)) [studio]
- [`f58f015`](https://github.com/synfig/synfig/commit/f58f015cb0e15807290d93bf01e2794eeba81eaa) fix: prevent accessing invalid index while parsing Distance string ([#3277](https://github.com/synfig/synfig/issues/3277)) [core]
- [`2610452`](https://github.com/synfig/synfig/commit/26104523f1f0b936cf4e98c80873df8e05cc73f7) fix: units in Tool Options panel didn't follow app settings (regression) ([#3276](https://github.com/synfig/synfig/issues/3276)) [core] [studio]
- [`fae301f`](https://github.com/synfig/synfig/commit/fae301f558f6437317a7288fdd5af927e89842cc) fix: ListImporter was not able to fetch the right files on synfig CLI ([#3275](https://github.com/synfig/synfig/issues/3275)) [core]
- [`ceeaa53`](https://github.com/synfig/synfig/commit/ceeaa53b7d06a51c0d4ae15801d8057dfb14da24) refactor: prefer synfig::filesystem::Path rather than synfig::String or std::string ([#3273](https://github.com/synfig/synfig/issues/3273)) [core] [studio]
- [`69f4ea7`](https://github.com/synfig/synfig/commit/69f4ea71908f666a2e2c8907f77c1c284f1aa870) fix: memory leak on Layer_Freetype ([#3269](https://github.com/synfig/synfig/issues/3269)) [core]
- [`e299657`](https://github.com/synfig/synfig/commit/e299657c0393d0890a0996fea638fa781f82e0ef) fix: missing OS namespace for MSVC compiler code ([#3253](https://github.com/synfig/synfig/issues/3253)) [core]
- [`05da4e9`](https://github.com/synfig/synfig/commit/05da4e95023c3015096729d1444f9266a0175fb5) fix: build on Debian 9 ([#3169](https://github.com/synfig/synfig/issues/3169)) [core] [studio]
- [`62db8df`](https://github.com/synfig/synfig/commit/62db8df659722b3eefd037dc4e7dc843169b1991) chore:  PVS-Studio has been added to the list of organizations ([#3267](https://github.com/synfig/synfig/issues/3267))
- [`1113a4c`](https://github.com/synfig/synfig/commit/1113a4cec09ab4ad976d62ee7d9a65192348b74d) feat: added presets to canvas resize window  ([#3213](https://github.com/synfig/synfig/issues/3213)) [studio]
- [`d3e1c8a`](https://github.com/synfig/synfig/commit/d3e1c8a93f9373409fd0c36acd7d9e0b853fe9ec) refactor: cleanup an old debug line ([#3266](https://github.com/synfig/synfig/issues/3266)) [core]
- [`6f04539`](https://github.com/synfig/synfig/commit/6f045399e671d5badd92b6ee99dd8148cc91ebc0) fix: unable to open file paths longer than 23 characters on Windows ([#3265](https://github.com/synfig/synfig/issues/3265)) [studio]
- [`cb161a0`](https://github.com/synfig/synfig/commit/cb161a0e4dad0837b8d8abef1a634725469ba2bd) refactor: icon controller now uses synfig::filesystem::Path ([#3254](https://github.com/synfig/synfig/issues/3254)) [studio]
- [`c646494`](https://github.com/synfig/synfig/commit/c646494ed332aaefb3841f778afc5c069d7f2733) refactor: create load_interface() on ResourceHelper ([#3258](https://github.com/synfig/synfig/issues/3258)) [studio]
- [`07656d7`](https://github.com/synfig/synfig/commit/07656d75eecb9a90b26b0c3e67c8395dee38376a) refactor: App::brushes_path now uses synfig::filesystem::Path ([#3250](https://github.com/synfig/synfig/issues/3250)) [studio]
- [`ff07e2f`](https://github.com/synfig/synfig/commit/ff07e2f85d7437d95fca3ebd16170aff92f5a38e) refactor: remove unneeded macro stratof ([#3257](https://github.com/synfig/synfig/issues/3257)) [studio]
- [`1e12862`](https://github.com/synfig/synfig/commit/1e12862be1346244c08cb56f4078df1abf8d8bd8) refactor: replace unsafe sprintf() with snprintf() ([#3263](https://github.com/synfig/synfig/issues/3263)) [core]
- [`1f56478`](https://github.com/synfig/synfig/commit/1f564788d41b94d732e837539960e871ed09c22e) fix: recent file list is reversing every time Synfig Studio launches ([#3256](https://github.com/synfig/synfig/issues/3256)) [studio]
- [`0e4826d`](https://github.com/synfig/synfig/commit/0e4826d42cdb4c423ea8e5f0fface61ab3d18e13) fix: restore the tools hotkeys ([#3262](https://github.com/synfig/synfig/issues/3262)) [studio]
- [`15979d4`](https://github.com/synfig/synfig/commit/15979d48bb79386d575ce58aaa040553c2cecfcf) fix: update Solid Color layer name in Lottie exporter ([#3252](https://github.com/synfig/synfig/issues/3252)) [studio]
- [`64e8817`](https://github.com/synfig/synfig/commit/64e88170340c21736e2f9652de6d2ce2088c0e43) ci(Github Actions): bump macOS version ([#3259](https://github.com/synfig/synfig/issues/3259))
- [`0e11669`](https://github.com/synfig/synfig/commit/0e116697e531af2eb14a7749e552908464526387) refactor: OS::launch_file_async() now uses synfig::filesystem::Path ([#3249](https://github.com/synfig/synfig/issues/3249)) [core] [studio]
- [`d716b93`](https://github.com/synfig/synfig/commit/d716b93c831fcd1e4c61756a427cf204bd4674fe) fix: restore icons for Tools menu ([#3248](https://github.com/synfig/synfig/issues/3248)) [studio]
- [`0761723`](https://github.com/synfig/synfig/commit/0761723cca097a035e1f3c358f565cf1a3cdf2e0) feat: add Layers, Parameters and Timetrack treeviews styles for even/odd rows ([#3245](https://github.com/synfig/synfig/issues/3245)) [studio]
- [`5907a10`](https://github.com/synfig/synfig/commit/5907a10a27e7c5e2242bf13c0add85a17648e725) refactor: dialogs for document opening now use filesystem::Path ([#3246](https://github.com/synfig/synfig/issues/3246)) [studio]
- [`efb719b`](https://github.com/synfig/synfig/commit/efb719b447ad8e507af8ded2a964320fd0fbe724) feat: add "invert" parameter to ChromaKey layer ([#3240](https://github.com/synfig/synfig/issues/3240)) [core]
- [`0882a4e`](https://github.com/synfig/synfig/commit/0882a4e6b5d0a0734f3c46e4eeb06b3f58c73e9e) refactor: dialogs for saving and exporting now uses filesystem::Path ([#3234](https://github.com/synfig/synfig/issues/3234)) [core] [studio]
- [`2ee9378`](https://github.com/synfig/synfig/commit/2ee937878b1fee19b63e40840c8388f5c418cb9f) fix: column 'name' of Layers panel should be the largest one ([#3243](https://github.com/synfig/synfig/issues/3243)) [studio]
- [`ba424ef`](https://github.com/synfig/synfig/commit/ba424ef2ab860e67180e4c2303e60c15e46a4855) ci: added backtrace output in case of build crash ([#3241](https://github.com/synfig/synfig/issues/3241))
- [`e872c19`](https://github.com/synfig/synfig/commit/e872c19142967eadf825cdd7c517b23569006f62) refactor: synfig::OS::get_binary_path() doesn't require a fallback anymore ([#3236](https://github.com/synfig/synfig/issues/3236)) [core] [studio]
- [`4e71685`](https://github.com/synfig/synfig/commit/4e716859457551ae5418bcf771cbf98091ddfca4) refactor: avoid compiler warning: missing parentheses around assignment ([#3238](https://github.com/synfig/synfig/issues/3238)) [studio]
- [`21a1092`](https://github.com/synfig/synfig/commit/21a1092476dd4f6656a97bb2a11f803b7384f929) fix: file ETL/clock was moved to synfig-core ([#3228](https://github.com/synfig/synfig/issues/3228)) [core]
- [`219c214`](https://github.com/synfig/synfig/commit/219c21498e6062813c5bc956cc3e18d9552b39c2) feat: workaround to allow to alternate even/odd row colors for Timetrack ([#3231](https://github.com/synfig/synfig/issues/3231)) [studio]
- [`babf9e6`](https://github.com/synfig/synfig/commit/babf9e6188dccdc75a6d46ef995113e581f0840a) refactor: remove unused #include (somehow missed in [#3141](https://github.com/synfig/synfig/issues/3141)) ([#3235](https://github.com/synfig/synfig/issues/3235)) [core]
- [`8b4bf25`](https://github.com/synfig/synfig/commit/8b4bf2520c737641d2bd94aef5c8d374cc7dd067) refactor: remove compiler warning about missing `override` keyword ([#3237](https://github.com/synfig/synfig/issues/3237)) [studio]
- [`6969840`](https://github.com/synfig/synfig/commit/69698402e7a88895b102bf4b35caf597259b9dba) refactor: clean etl::handle and alike ([#3233](https://github.com/synfig/synfig/issues/3233)) [ETL] [core] [studio]
- [`ea2b81e`](https://github.com/synfig/synfig/commit/ea2b81ee6094fb0dcea666396b4ffd668ff6fe86) feat: widget Timetrack now can have its own color for selected row ([#3232](https://github.com/synfig/synfig/issues/3232)) [studio]
- [`91c09dd`](https://github.com/synfig/synfig/commit/91c09dddee2aa605ed657cb9b2c71b722043da74) feat: add CSS classes and id to widgets/panels to allow visual customization ([#3230](https://github.com/synfig/synfig/issues/3230)) [studio]
- [`fd63235`](https://github.com/synfig/synfig/commit/fd63235eae3eb95ca4f199fe262bfb3322583848) refactor: prefer synfig::filesystem::Path rather std::string ([#3229](https://github.com/synfig/synfig/issues/3229)) [core] [studio]
- [`7681883`](https://github.com/synfig/synfig/commit/768188305412e231309cddf467c58bcc304863d9) refactor: use synfig:filesystem::Path for sketch, palette & others ([#3219](https://github.com/synfig/synfig/issues/3219)) [core] [studio]
- [`2cf7e0e`](https://github.com/synfig/synfig/commit/2cf7e0eefae64dedc92103265d3c45bf14d58b0d) fix: issues when importing with absolute paths from different root path ([#3214](https://github.com/synfig/synfig/issues/3214)) [core] [studio]
- [`3f490e5`](https://github.com/synfig/synfig/commit/3f490e5c18db9d4921621b43723c01ffb659a572) refactor: prefer range-based for loop and avoid direct etl::handle ([#3227](https://github.com/synfig/synfig/issues/3227)) [studio]
- [`9d76e50`](https://github.com/synfig/synfig/commit/9d76e502d4396f298db710b4ff926ee6cf36a31f) fix(Windows): plugins fail to execute for files with non-latin characters ([#3220](https://github.com/synfig/synfig/issues/3220)) [core] [studio]
- [`57a063a`](https://github.com/synfig/synfig/commit/57a063ac650eb47590d909f602b070ed45dcaeab) refactor: avoid direct use of etl::handle ([#3226](https://github.com/synfig/synfig/issues/3226)) [core] [studio]
- [`19218cf`](https://github.com/synfig/synfig/commit/19218cfe8c86fc0aedf047986a36df3c4b271660) refactor: remove not-needed 'using namespace etl' ([#3221](https://github.com/synfig/synfig/issues/3221)) [core] [studio]
- [`ee98a9f`](https://github.com/synfig/synfig/commit/ee98a9ffb620e657fc825d6da2f131316f4372e5) fix: fixed macOS Info.plist file ([#3223](https://github.com/synfig/synfig/issues/3223))
- [`7040b7f`](https://github.com/synfig/synfig/commit/7040b7f4452afebe131a4425bafb5171f7f6112f) refactor: make Filesystem::filename a filesystem::Path object ([#3209](https://github.com/synfig/synfig/issues/3209)) [core] [studio]
- [`fb11ad2`](https://github.com/synfig/synfig/commit/fb11ad27d80903cf5eaba4698298801512e928b6) fix: scale value of transformation on Parameters Panel is dimensionless ([#3208](https://github.com/synfig/synfig/issues/3208)) [studio]
- [`47b0888`](https://github.com/synfig/synfig/commit/47b088875c781ab4b5c41a7a50f5d4450806078a) fix: preview window not showing when there is a Layer_Sound ([#3211](https://github.com/synfig/synfig/issues/3211)) [core]
- [`bb7180e`](https://github.com/synfig/synfig/commit/bb7180ec1925ba45b3dc3928983190ca3df817d4) fix: revert Custom Workspaces Editor button labels to GTK ones ([#3175](https://github.com/synfig/synfig/issues/3175)) [studio]
- [`1596272`](https://github.com/synfig/synfig/commit/15962724f781570f4a6a943803d3b06b0301c1c6) refactor: increase the pixels per frame without render split in Target_Scanline ([#3205](https://github.com/synfig/synfig/issues/3205)) [core]
- [`4d4726a`](https://github.com/synfig/synfig/commit/4d4726aafda7bbd05df7233daac31b13985f11e0) fix: avoid parser error of focus point on loading malformed synfig file ([#3206](https://github.com/synfig/synfig/issues/3206)) [core]
- [`9bd669d`](https://github.com/synfig/synfig/commit/9bd669d14d0f4d187a3adba271f4a206feaec194) perf: optimized Action_System so that the canvas only renders once during an action ([#3200](https://github.com/synfig/synfig/issues/3200)) [studio]
- [`32c9da1`](https://github.com/synfig/synfig/commit/32c9da10772d758fee8662fe17419be7899978a7) refactor: avoid build warning due to unused parameter ([#3202](https://github.com/synfig/synfig/issues/3202)) [core]
- [`a189a43`](https://github.com/synfig/synfig/commit/a189a43b1788a9fb4bc335c1b2a8ebc69ed97bac) fix: new MotionBLur subsampling None used wrong blend method ([#3201](https://github.com/synfig/synfig/issues/3201)) [core]
- [`bb67147`](https://github.com/synfig/synfig/commit/bb67147365155d1ea3a048d2b55d98621b7c4b3b) feat: layer Motion Blur now can create an non blurred trail ([#3173](https://github.com/synfig/synfig/issues/3173)) [core]
- [`b9afc45`](https://github.com/synfig/synfig/commit/b9afc452965f9bbc19c8487a6101cf9870b66ba0) refactor: port more layers to Cobra renderer: some Gradient layers ([#2562](https://github.com/synfig/synfig/issues/2562)) [core]
- [`09e01f0`](https://github.com/synfig/synfig/commit/09e01f07ec4b02fefd4ec2428cbec39ae263fda2) fix: toolbox isn't updated when switching document tabs ([#3170](https://github.com/synfig/synfig/issues/3170)) [studio]
- [`567c796`](https://github.com/synfig/synfig/commit/567c7964576c7730244a025e3f356f6bd7cb2efb) refactor: remove old macOS specific code ([#3192](https://github.com/synfig/synfig/issues/3192)) [studio]
- [`4e47fc0`](https://github.com/synfig/synfig/commit/4e47fc059fc5bc7fa4ce11fd70367c4457dc04e4) fix(plugin): requesting current_time invalidates JSON data ([#3194](https://github.com/synfig/synfig/issues/3194)) [studio]
- [`03eecaf`](https://github.com/synfig/synfig/commit/03eecafbef8daa814d578574f343a457305d8583) refactor: avoid g++ 13 compiler warning ([#3193](https://github.com/synfig/synfig/issues/3193)) [core]
- [`c28287d`](https://github.com/synfig/synfig/commit/c28287df3596f3a9ad75a68b3f8d1ec53cec7ad7) fix: uninitialized value in ValueNode_DynamicList::ListEntry::amount_at_time() ([#3081](https://github.com/synfig/synfig/issues/3081)) [core]
- [`72c3ae2`](https://github.com/synfig/synfig/commit/72c3ae2899ac76522a00eb59362a852dd538d9bd) feat: added path and button to open plugin folder in Preferences window ([#3162](https://github.com/synfig/synfig/issues/3162)) [studio]
- [`e4f9059`](https://github.com/synfig/synfig/commit/e4f90592380e39df13310dc4a1029fa9e56446fc) fix: timetrack toolbar disappears when closing a file ([#3188](https://github.com/synfig/synfig/issues/3188)) [studio]
- [`6c28f60`](https://github.com/synfig/synfig/commit/6c28f60bf481285f5b51c042e1cce91c0c16015d) style: indentation inconsistencies in `state_circle.cpp` ([#3183](https://github.com/synfig/synfig/issues/3183)) [studio]
- [`dde975f`](https://github.com/synfig/synfig/commit/dde975f4fb8160bb32615e9b968afc1b5b953914) fix: missing cstring header in png_trgt ([#3171](https://github.com/synfig/synfig/issues/3171)) [core]
- [`8f06423`](https://github.com/synfig/synfig/commit/8f064232ab7b832c35060034dc53a87adce35d8a) fix(plugins): crash when selected layers are optional and there is none ([#3178](https://github.com/synfig/synfig/issues/3178)) [studio]
- [`12d62c4`](https://github.com/synfig/synfig/commit/12d62c42c8e31ae99b925badb84e0fee2f3a27ec) fix: current time widget color in dark theme ([#3163](https://github.com/synfig/synfig/issues/3163)) [studio]
- [`4d08c0f`](https://github.com/synfig/synfig/commit/4d08c0f0f4d4caf20d0564cbdce7d38c7481568e) refactor: remove unneeded special XML encoding for subtract valuenode ([#3141](https://github.com/synfig/synfig/issues/3141)) [core]
- [`9b0df0e`](https://github.com/synfig/synfig/commit/9b0df0e88920ee9ed55a812d40278268dcbcad54) refactor: remove unnecessary `const` in internal typedef ([#3168](https://github.com/synfig/synfig/issues/3168)) [core]
- [`936b29a`](https://github.com/synfig/synfig/commit/936b29a5f6e87657186f1f058e428a42a2cb36ab) fix: wrong Copy and Cut icon names ([#3166](https://github.com/synfig/synfig/issues/3166)) [studio]
- [`9f76c7b`](https://github.com/synfig/synfig/commit/9f76c7bd71f4ec651180213a1cba7535258753f4) fix: filesystem::Path::relative_to() didn't work for empty paths ([#3135](https://github.com/synfig/synfig/issues/3135)) [core]
- [`386a172`](https://github.com/synfig/synfig/commit/386a17232777084642adaf95e4bb4aec01db17fe) fix: preferences dialog should list only themes with index.theme file ([#3140](https://github.com/synfig/synfig/issues/3140)) [studio]
- [`cf74901`](https://github.com/synfig/synfig/commit/cf7490198540254b4c602b554a30950dbd7fcd98) fix: build on Debian 9 ([#3164](https://github.com/synfig/synfig/issues/3164)) [core]
- [`79ae40c`](https://github.com/synfig/synfig/commit/79ae40cd586089887b19c0f989e92c076ffef038) refactor: replaced Gtk::StockID in tool labels with custom implementation ([#3134](https://github.com/synfig/synfig/issues/3134)) [studio]
- [`8967af0`](https://github.com/synfig/synfig/commit/8967af09b3876c699389913688dc777af27714ab) refactor: sketch filename now uses filesystem::Path ([#3138](https://github.com/synfig/synfig/issues/3138)) [studio]
- [`0d26e60`](https://github.com/synfig/synfig/commit/0d26e602f4199e55d40a57b2c67c362dad8ca3c0) fix: fixed icons in Preferences dialog in Windows ([#3156](https://github.com/synfig/synfig/issues/3156)) [studio]
- [`e232831`](https://github.com/synfig/synfig/commit/e2328316a5b9749f3b7ba292260a2144b2d28b06) fix: brush tool crashes synfig if no layer is selected in the dialog ([#3157](https://github.com/synfig/synfig/issues/3157)) [studio]
- [`0925416`](https://github.com/synfig/synfig/commit/0925416d6323a4af2259399f35e66a80cde3b210) refactor: add missing fallthrough mark in other switch cases ([#3151](https://github.com/synfig/synfig/issues/3151)) [core]
- [`329a584`](https://github.com/synfig/synfig/commit/329a584aa76928791fa6db67aa6e28eddeffa994) feat: double clicking guides opens edit dialog ([#3152](https://github.com/synfig/synfig/issues/3152)) [studio]
- [`655a042`](https://github.com/synfig/synfig/commit/655a04290fba9f439eae14848ee571ba97e39941) refactor: add fallthrough mark in switch cases to avoid unneeded warning ([#3143](https://github.com/synfig/synfig/issues/3143)) [core] [studio]
- [`5603b49`](https://github.com/synfig/synfig/commit/5603b4972b4c1c505fef45c155e540c3f3950ade) perf: use reference, not copy, on range-based for loops ([#3147](https://github.com/synfig/synfig/issues/3147)) [core] [studio]
- [`1cdcfd5`](https://github.com/synfig/synfig/commit/1cdcfd5249b5e74880b2091114a56d8fd8c86431) refactor: make argument name consistent in method declaration and definition ([#3122](https://github.com/synfig/synfig/issues/3122)) [studio]
- [`86bb59f`](https://github.com/synfig/synfig/commit/86bb59fd4b9680172fea61d3f6c4d44be3297c09) chore: add .cache folder to .gitignore ([#3145](https://github.com/synfig/synfig/issues/3145))
- [`5b774b1`](https://github.com/synfig/synfig/commit/5b774b12d4c84dc8a01da8d5a6bd518a3b1ac025) fix: restore shortcuts for edit cut/copy/paste and app quit ([#3133](https://github.com/synfig/synfig/issues/3133)) [studio]
- [`25b1b5a`](https://github.com/synfig/synfig/commit/25b1b5ada0c7618cdac7ef851b69489bfa8fc92c) refactor: remove unused actions ([#3132](https://github.com/synfig/synfig/issues/3132)) [studio]
- [`cc636bc`](https://github.com/synfig/synfig/commit/cc636bc412a5ebef207f0b7d2b2b9a3b8bdcdc17) fix: find the second closest guide no matter the guide list order ([#3090](https://github.com/synfig/synfig/issues/3090)) [studio]
- [`28ae7c3`](https://github.com/synfig/synfig/commit/28ae7c3f199c6e3645987543aecb65544b9a0d3e) fix: filename was shown truncated in Render dialog ([#3129](https://github.com/synfig/synfig/issues/3129)) [studio]
- [`d0145da`](https://github.com/synfig/synfig/commit/d0145da8b6e14e409135c637193f8972593e2c2b) style: prefer override rather virtual, spaces surrounding const ([#3130](https://github.com/synfig/synfig/issues/3130)) [studio]
- [`1b5c291`](https://github.com/synfig/synfig/commit/1b5c2918a5d250a908d71b92b96a4fa3da06b70c) refactor: remove unneeded variable in `state_normal.cpp` ([#3123](https://github.com/synfig/synfig/issues/3123)) [studio]
- [`f0fee6c`](https://github.com/synfig/synfig/commit/f0fee6ce5f9f1d51d4a63c032b21f31f2abb1b4d) refactor: prefer icon names rather deprecated Gtk::StockID ([#3125](https://github.com/synfig/synfig/issues/3125)) [studio]
- [`9405e5b`](https://github.com/synfig/synfig/commit/9405e5b926dfb5dfcd3dec6d54907bdeb87a22dd) refactor: remove unused cursor methods in studio::IconController class ([#3126](https://github.com/synfig/synfig/issues/3126)) [studio]
- [`55568f8`](https://github.com/synfig/synfig/commit/55568f8e4c98a8ff9c33bad01e222eeb88d68dcf) fix: tool tooltip didn't show the shortcut/hotkey ([#3127](https://github.com/synfig/synfig/issues/3127)) [studio]
- [`4222437`](https://github.com/synfig/synfig/commit/4222437f787b7209f122ad0fa538199fc84869ba) fix: properly report failure on pipe creation on POSIX systems ([#3045](https://github.com/synfig/synfig/issues/3045)) [core]
- [`13b3211`](https://github.com/synfig/synfig/commit/13b3211b07f7c260516cbfbfd4edd566fa1a19f9) refactor: brush size increase/decrease buttons now use theme icons ([#3091](https://github.com/synfig/synfig/issues/3091)) [studio]
- [`9dfa49b`](https://github.com/synfig/synfig/commit/9dfa49b9d0aef15e5968254a744af4f2b9cd4c79) fix: make delete icon name independent of old Gtk ([#3120](https://github.com/synfig/synfig/issues/3120)) [studio]
- [`5bf2912`](https://github.com/synfig/synfig/commit/5bf2912d6e78f19288eb3312febebfcce8181655) refactor(Time): change epsilon_() method to constant; remove c_str() ([#3079](https://github.com/synfig/synfig/issues/3079)) [core]
- [`5ecd9c1`](https://github.com/synfig/synfig/commit/5ecd9c1beb6998dd274426459ec81bb4018c5474) refactor: remove unused ParamDesc constructor argument ([#3092](https://github.com/synfig/synfig/issues/3092)) [core] [studio]
- [`9a7fb6c`](https://github.com/synfig/synfig/commit/9a7fb6cfdb0af4b72773958ab43eea7a92814313) refactor: delete old debug envvars that aren't needed anymore ([#3108](https://github.com/synfig/synfig/issues/3108)) [studio]
- [`117665a`](https://github.com/synfig/synfig/commit/117665a43d88d5134201d9dde398b47c720043d9) fix: restore Save All shortcut missing since [#3072](https://github.com/synfig/synfig/issues/3072) ([#3110](https://github.com/synfig/synfig/issues/3110)) [studio]
- [`80c2d28`](https://github.com/synfig/synfig/commit/80c2d28b117f19f5cebeb18cdb71a932f2758651) fix: some icons didn't follow icon theme ([#3109](https://github.com/synfig/synfig/issues/3109)) [studio]
- [`a3091ae`](https://github.com/synfig/synfig/commit/a3091aeeacf527495b2ab3cdc0d0796652747d89) refactor: remove unused macro ([#3111](https://github.com/synfig/synfig/issues/3111)) [studio]
- [`719186a`](https://github.com/synfig/synfig/commit/719186aba54dafa92a34e821d211628fcec6ef56) fix: avoid crash if icon theme does not provide type_bool_icon file ([#3107](https://github.com/synfig/synfig/issues/3107)) [studio]
- [`fd8e796`](https://github.com/synfig/synfig/commit/fd8e796034d47829bad30e1ee9502463a32ecad3) refactor: remove unneeded target_names variable from RenderSettings dialog ([#3096](https://github.com/synfig/synfig/issues/3096)) [studio]
- [`d08e269`](https://github.com/synfig/synfig/commit/d08e2694ebb7432385d2e3ed1299c7d3a79735c7) refactor: minor cleanup in synfig-core/tool/main.cpp ([#3102](https://github.com/synfig/synfig/issues/3102)) [core]
- [`fd37089`](https://github.com/synfig/synfig/commit/fd370893420548fb7d53b02d85968d476362e7b3) refactor: use a common function as base to App::dialog_open_*() and simplify methods ([#3103](https://github.com/synfig/synfig/issues/3103)) [core] [studio]
- [`3504138`](https://github.com/synfig/synfig/commit/35041381acb5aa111f025f21432fea214b6fbefc) refactor: create filesystem::current_path() and filesystem::absolute() ([#3100](https://github.com/synfig/synfig/issues/3100)) [core]
- [`71b7633`](https://github.com/synfig/synfig/commit/71b7633893570cc0efd330507c77487677d3cbd2) refactor: prefer initialization list on constructor ([#3099](https://github.com/synfig/synfig/issues/3099)) [core]
- [`4e1d286`](https://github.com/synfig/synfig/commit/4e1d28685a7ed6df7b5925523cc8a826c09023bf) refactor: avoid malloc() ([#3098](https://github.com/synfig/synfig/issues/3098)) [core]
- [`4682ff4`](https://github.com/synfig/synfig/commit/4682ff40f5d4de27217a55b20293c482b0c8a98b) refactor: synfig-cli job now uses filesystem::Path ([#3095](https://github.com/synfig/synfig/issues/3095)) [core]
- [`f8e7654`](https://github.com/synfig/synfig/commit/f8e7654b6f48c71575f39d4afd84a1b134c03293) refactor: cleanup Target::BookEntry ([#3093](https://github.com/synfig/synfig/issues/3093)) [core]
- [`50dcf93`](https://github.com/synfig/synfig/commit/50dcf93b70208b023170c022ff6b791cb3af8a52) refactor: minor cleanup in state Lasso and Draw ([#3088](https://github.com/synfig/synfig/issues/3088)) [studio]
- [`85d3401`](https://github.com/synfig/synfig/commit/85d34016b5c8aee402ac9cf7d7a4aa39dfba7c7b) refactor: render settings dialog now uses synfig::filesystem::Path ([#3094](https://github.com/synfig/synfig/issues/3094)) [studio]
- [`905ff3f`](https://github.com/synfig/synfig/commit/905ff3f16fbc8447755f702f991714fd6c09ab05) fix: allow string to be properly translated ([#3089](https://github.com/synfig/synfig/issues/3089)) [studio]
- [`8e87b99`](https://github.com/synfig/synfig/commit/8e87b996a52eb63f43e78234119e0ca0cfcdada9) refactor: update studio_menubar.xml ([#3075](https://github.com/synfig/synfig/issues/3075)) [studio]
- [`e94dece`](https://github.com/synfig/synfig/commit/e94dece405cef1f4486379257894d7110a194c1c) refactor: prefer initialization list rather constructor body ([#3086](https://github.com/synfig/synfig/issues/3086)) [core] [studio]
- [`fdf4013`](https://github.com/synfig/synfig/commit/fdf4013f8c2a8ed99f080067f88a3b9d2dbe36b3) refactor: throw exception itself, not a copy ([#3087](https://github.com/synfig/synfig/issues/3087)) [studio]
- [`011a34c`](https://github.com/synfig/synfig/commit/011a34cd29a6d506dbb07fdd1f3b8e893265db53) feat: plugins can  have simple dialog and receive current time and selected layer xpath ([#2996](https://github.com/synfig/synfig/issues/2996)) [studio]
- [`6d88671`](https://github.com/synfig/synfig/commit/6d886710f4a0456fad9b5471fc8b91fa326b2438) refactor: prefer prefix ++ operators for non-primitive types (part 2) ([#3085](https://github.com/synfig/synfig/issues/3085)) [core] [studio]
- [`dd26f66`](https://github.com/synfig/synfig/commit/dd26f6622e74af66e7a08d406ff04f9d6f660486) feat: always show "Add Waypoint" menu item for animatable parameters ([#3006](https://github.com/synfig/synfig/issues/3006)) [studio]
- [`022a016`](https://github.com/synfig/synfig/commit/022a016d79b801409bee055c652fc16edf575075) refactor: prefer prefix `++` operators for non-primitive types ([#3077](https://github.com/synfig/synfig/issues/3077)) [core] [studio]
- [`6e69e7e`](https://github.com/synfig/synfig/commit/6e69e7ea436051db4f45ef864a29a68fef5b88d6) refactor!: rename action "KeyframeToggl" as "KeyframeToggle" ([#3078](https://github.com/synfig/synfig/issues/3078)) [studio]
- [`7c38135`](https://github.com/synfig/synfig/commit/7c38135e1bd1f93939e1d7b8ee03d1dd1e78ea49) refactor: add missing `const` to Duckmatic::add_to_ducks() parameter ([#3082](https://github.com/synfig/synfig/issues/3082)) [studio]
- [`dcae44e`](https://github.com/synfig/synfig/commit/dcae44e696eca32d590e0138a07180bed61fd15b) refactor: list document actions in a std::vector to better readability ([#3076](https://github.com/synfig/synfig/issues/3076)) [studio]
- [`b8d1046`](https://github.com/synfig/synfig/commit/b8d104648f11ff46ceed0d1293ea346be3a16a73) refactor: add missing `const` on some synfig::ParamDesc methods ([#3080](https://github.com/synfig/synfig/issues/3080)) [core]
- [`b172e37`](https://github.com/synfig/synfig/commit/b172e3771a131dbd26879aae334b84ac26bcb6e6) feat: added the ability to rotate guides in the canvas ([#2777](https://github.com/synfig/synfig/issues/2777)) [studio]
- [`99aae13`](https://github.com/synfig/synfig/commit/99aae13aa4714da3bac72cb9baa3ebabdced7456) refactor: prefer Layer_*::Handle and alike rather etl::handle ([#3041](https://github.com/synfig/synfig/issues/3041)) [core] [studio]
- [`445e872`](https://github.com/synfig/synfig/commit/445e8723a6d7b0594a526b3269d7f1c98da3bcf2) refactor: move `save_all()` (documents) from `CanvasView` to `MainWindow` ([#3072](https://github.com/synfig/synfig/issues/3072)) [studio]
- [`6d62c48`](https://github.com/synfig/synfig/commit/6d62c48f41462d678cc212f8c01707d09b91fbbc) refactor: prefer CanvasView::Handle & others instead of etl::handle ([#3073](https://github.com/synfig/synfig/issues/3073)) [studio]
- [`1171954`](https://github.com/synfig/synfig/commit/1171954999056ea360d887380d2b1639f0a9a0ed) refactor: remove unused synfig::rendering::Resource ([#3074](https://github.com/synfig/synfig/issues/3074)) [ETL] [core]
- [`449a7e1`](https://github.com/synfig/synfig/commit/449a7e1a48c07884f2719a562d9471d62ccdb8bf) fix: Toolbox panel wasn't updated on switching tools via shortcuts ([#3067](https://github.com/synfig/synfig/issues/3067)) [studio]
- [`5834fda`](https://github.com/synfig/synfig/commit/5834fda48e390497bf88263fca7121805e935387) fix: update Tool tip when user changes its shortcut at runtime ([#3066](https://github.com/synfig/synfig/issues/3066)) [studio]
- [`bb10cd1`](https://github.com/synfig/synfig/commit/bb10cd10240e057cc3f5dd35c270e94c527d7ba3) feat: add handles to Bevel layer parameters ([#3044](https://github.com/synfig/synfig/issues/3044)) [core]
- [`3688e7f`](https://github.com/synfig/synfig/commit/3688e7f6037cc5828431c2afe0da902be7701f73) fix: Width handles must be visible with Skeleton layer ([#3061](https://github.com/synfig/synfig/issues/3061)) [studio]
- [`d2e084f`](https://github.com/synfig/synfig/commit/d2e084ffa6492157a3fcc51858802abd2d9a09c8) build: fix `make distcheck` build ([#3069](https://github.com/synfig/synfig/issues/3069)) [core] [studio]
- [`37fb8aa`](https://github.com/synfig/synfig/commit/37fb8aa790ed9474b18c1673c023ce662acb631b) test: use preset variable of AutoTools to some directories ([#3068](https://github.com/synfig/synfig/issues/3068)) [core] [studio]
- [`71a0657`](https://github.com/synfig/synfig/commit/71a0657e6fd30a95a9bf57a43d507a5a3ce471ee) chore: update changelog ([#3065](https://github.com/synfig/synfig/issues/3065))
- [`3d3c9fa`](https://github.com/synfig/synfig/commit/3d3c9fa63f4816505a4f2867732ac7946c252cad) fix: fix dependencies script for ALT Linux ([#3056](https://github.com/synfig/synfig/issues/3056))
- [`61432e9`](https://github.com/synfig/synfig/commit/61432e9a0faedb46ed684f2d1358ca357c13f4d8) refactor: rename method to `get_link_description(...)` to avoid ambiguity ([#3060](https://github.com/synfig/synfig/issues/3060)) [core] [studio]
- [`b13a58b`](https://github.com/synfig/synfig/commit/b13a58b60bd60b7ee534f29116bf0ba8f85e8af2) refactor: avoid mutable vars in Layer ([#3059](https://github.com/synfig/synfig/issues/3059)) [core]
- [`009a5d0`](https://github.com/synfig/synfig/commit/009a5d040f74a06ec0ade1182d3d40da9cd91eb7) refactor!: move filepath handling methods to synfig::filesystem::Path ([#2710](https://github.com/synfig/synfig/issues/2710)) [ETL] [core] [studio]
- [`571d7ea`](https://github.com/synfig/synfig/commit/571d7ea098bf145653099e3a6f9fc02a3f636fd5) fix: pasting of external exported valuenodes ([#2086](https://github.com/synfig/synfig/issues/2086)) [studio]
- [`0ed2621`](https://github.com/synfig/synfig/commit/0ed2621015012cd41cd09f20a7eb2628349985f4) feat: new Chroma Key layer ([#2553](https://github.com/synfig/synfig/issues/2553)) [core] [studio]
- [`a31487f`](https://github.com/synfig/synfig/commit/a31487ff22ed0edd2f7184547d769cd85d027325) refactor: removed unused members of CanvasView ([#3052](https://github.com/synfig/synfig/issues/3052)) [studio]
- [`5ac0a2b`](https://github.com/synfig/synfig/commit/5ac0a2b11d83772998192bccac231e1512462742) test: marking_node_as_changed_changes_the_last_time_changed fails on AppVeyor ([#3053](https://github.com/synfig/synfig/issues/3053)) [core]
- [`1ff9bf0`](https://github.com/synfig/synfig/commit/1ff9bf03916bea7d7e28c914d3fefd824d755012) refactor: code cleanup in Targets ([#3043](https://github.com/synfig/synfig/issues/3043)) [core]
- [`893c531`](https://github.com/synfig/synfig/commit/893c531a1fab065a6263c5e4155d1baf0525eb36) fix: possible invalid memory access on replacing valuenodes ([#3050](https://github.com/synfig/synfig/issues/3050)) [core]
- [`199fee3`](https://github.com/synfig/synfig/commit/199fee3ae54babc960cd365ad5626e71b5eaaf30) fix(canvas-dependencies): properly identify the file to avoid clash ([#3048](https://github.com/synfig/synfig/issues/3048)) [studio]
- [`eab7938`](https://github.com/synfig/synfig/commit/eab79388e4d7edecb905279634b52121c0424d99) refactor: remove unused method in CanvasFileNaming ([#3047](https://github.com/synfig/synfig/issues/3047)) [core]
- [`f984fb2`](https://github.com/synfig/synfig/commit/f984fb2d7c2c89fd7c33d141b419ada21f1f4111) refactor: remove unused #include ([#3040](https://github.com/synfig/synfig/issues/3040)) [core] [studio]
- [`59791bf`](https://github.com/synfig/synfig/commit/59791bfa6d2732a6e9be03345b476777504bca77) ci: enabled tests on GitHub Actions ([#2740](https://github.com/synfig/synfig/issues/2740)) [ETL] [core] [studio]
- [`5d645fe`](https://github.com/synfig/synfig/commit/5d645fe5923b23ac6294beb8a7237abd26be5a16) fix: added a missing `init_children_vocab()` call in ValueNode constructors ([#3027](https://github.com/synfig/synfig/issues/3027)) [core]
- [`550b8bd`](https://github.com/synfig/synfig/commit/550b8bd92f034b68211a96ee5af945be79c8f8d0) fix: sigsegv when `LANGUAGE`/`LANG` environment variable is not set ([#3033](https://github.com/synfig/synfig/issues/3033)) [core]
- [`df5cfaa`](https://github.com/synfig/synfig/commit/df5cfaa3695a117bd1b6dde92b96dc3e32659350) refactor: joblistprocessor code split into smaller functions ([#3032](https://github.com/synfig/synfig/issues/3032)) [core]
- [`3af6898`](https://github.com/synfig/synfig/commit/3af689874af4b61346ff91c3979e8be33fe463ac) feat: cleaner cli render progress output ([#3024](https://github.com/synfig/synfig/issues/3024)) [core]
- [`7a9dca4`](https://github.com/synfig/synfig/commit/7a9dca43ebb9a5f79dd7c4ec22df08138735e589) feat: added ability to choose render engine from command line ([#2970](https://github.com/synfig/synfig/issues/2970)) [core] [studio]
- [`3eca7c9`](https://github.com/synfig/synfig/commit/3eca7c97a618bc1df28ffc1fd435185c63d6e588) fix: missing translation for plugin names in main menu ([#2998](https://github.com/synfig/synfig/issues/2998)) [core] [studio]
- [`f0e2908`](https://github.com/synfig/synfig/commit/f0e2908c95e0817751791cba9039e7cd96b29f1e) refactor: simplified target_scanline.cpp ([#3025](https://github.com/synfig/synfig/issues/3025)) [core]
- [`3af0969`](https://github.com/synfig/synfig/commit/3af09694ea3e7f8b30f4d51657fac9398813cbbe) chore: fix various typos ([#3031](https://github.com/synfig/synfig/issues/3031)) [core] [studio]
- [`25ccd5a`](https://github.com/synfig/synfig/commit/25ccd5ad2e49ed8c01186450e3d363d719ba2e96) feat: add a CLI flag(--set-repeats) for rendering the same target multiple times ([#3018](https://github.com/synfig/synfig/issues/3018)) [core]
- [`03c9c20`](https://github.com/synfig/synfig/commit/03c9c20882700a2b4bc7c2305d3a074e9915f14d) refactor: remove useless return statement at the end of a function ([#3020](https://github.com/synfig/synfig/issues/3020)) [studio]
- [`e5a50f0`](https://github.com/synfig/synfig/commit/e5a50f03d33a22ec26bf07c91efb171ae15d954e) refactor: remove deprecated `Widget::override_color()` ([#3015](https://github.com/synfig/synfig/issues/3015)) [studio]
- [`313878d`](https://github.com/synfig/synfig/commit/313878d4d12a32f24b533d0832a6660b63ee149a) refactor: use RadioToolButton instead of ToggleToolButton for tools dock ([#3012](https://github.com/synfig/synfig/issues/3012)) [studio]
- [`3288e76`](https://github.com/synfig/synfig/commit/3288e7611283388ff6f273130c78dc0fc0ade768) build: patch for autoconf 2.72 h/t Frédéric Bérat ([#3011](https://github.com/synfig/synfig/issues/3011))
- [`3faf9f0`](https://github.com/synfig/synfig/commit/3faf9f0b998f2ba2856fc66cf87f72556020ea2a) refactor: replace deprecated `Gtk::HBox` with `Gtk::Box` ([#3002](https://github.com/synfig/synfig/issues/3002)) [studio]
- [`75d2684`](https://github.com/synfig/synfig/commit/75d2684ca0adf80c7405a987c06d52efdd69ff3f) chore: fix typo in comment in valuedescset.h ([#3005](https://github.com/synfig/synfig/issues/3005)) [studio]
- [`b2ee19d`](https://github.com/synfig/synfig/commit/b2ee19d997551ba186aa944b1899182fd5293f49) fix: inconsequential fixes regarding synfig::rendering::Tokens ([#3000](https://github.com/synfig/synfig/issues/3000)) [core]
- [`7b25a95`](https://github.com/synfig/synfig/commit/7b25a95c3129a406e38e857aaaf38783db6f527d) build: change exported cmake targets and provide a way to find deps ([#2999](https://github.com/synfig/synfig/issues/2999)) [core]
- [`53560d3`](https://github.com/synfig/synfig/commit/53560d3683c58ecff3884f207896657ef9bc27f5) fix: drawing tablet didn't work on Wayland ([#2991](https://github.com/synfig/synfig/issues/2991)) [studio]
- [`90e09d2`](https://github.com/synfig/synfig/commit/90e09d2a841b13b50dd5eabba92867392c59d9f4) fix: missing CanvasResize files in POTFILES.in ([#2992](https://github.com/synfig/synfig/issues/2992)) [studio]
- [`55bba4b`](https://github.com/synfig/synfig/commit/55bba4bbc450e50fb6436dde7c09e16b6e7730c4) refactor: prefer <Class>::Handle rather etl::handle<Class> ([#2990](https://github.com/synfig/synfig/issues/2990)) [core] [studio]
- [`38a85c0`](https://github.com/synfig/synfig/commit/38a85c0e70ed7f1576c4d00f5506e7f47de696d7) feat: simplified canvas resize ([#1895](https://github.com/synfig/synfig/issues/1895)) [core] [studio]
- [`e172f0b`](https://github.com/synfig/synfig/commit/e172f0b4402d21c8eee58c1b88846dad102343b8) refactor: change VectorizerSettings dialog to use Glade and Builder ([#2080](https://github.com/synfig/synfig/issues/2080)) [studio]
- [`147b926`](https://github.com/synfig/synfig/commit/147b9265abdf7653955f3d2aa83fb6d21a1f36ec) refactor(valuenodes): remove some unused #include ([#2989](https://github.com/synfig/synfig/issues/2989)) [core]
- [`93262db`](https://github.com/synfig/synfig/commit/93262dbc0e15fc1420de76f307936e29f03fe219) fix: build on Ubuntu 16.04 ([#2965](https://github.com/synfig/synfig/issues/2965)) [core] [studio]
- [`387d6ec`](https://github.com/synfig/synfig/commit/387d6ec292dd5c1fe6acd1366a38133223ab4d9f) ci: enabled ImageMagick ([#2986](https://github.com/synfig/synfig/issues/2986))
- [`50cf228`](https://github.com/synfig/synfig/commit/50cf2287ffaf36a920041a5d5fde1207dce88909) fix: vectorizer not working when Switch layer uses Layer Depth, not Name ([#2981](https://github.com/synfig/synfig/issues/2981)) [studio]
- [`d5e703e`](https://github.com/synfig/synfig/commit/d5e703e9fae1a4aa5849f2772a67af47b2baf9ec) refactor(instance): cleanup in add_special_layer_actions_to_group ([#2983](https://github.com/synfig/synfig/issues/2983)) [studio]
- [`107aab7`](https://github.com/synfig/synfig/commit/107aab7b997b74c62046fdebe688b9a1142c3ec5) refactor(iconcontroller): list icons in std::vector to better readability ([#2982](https://github.com/synfig/synfig/issues/2982)) [studio]
- [`edd4d48`](https://github.com/synfig/synfig/commit/edd4d485dabd0b81a96aa14c1f38203f1504df49) perf: don't iterate the whole Canvas if index is negative ([#2980](https://github.com/synfig/synfig/issues/2980)) [core]
- [`f74ec83`](https://github.com/synfig/synfig/commit/f74ec83ca3ad08eea025e39f1386abc3374dc1c9) refactor: cleanup module.cpp ([#2960](https://github.com/synfig/synfig/issues/2960)) [core]
- [`39527f6`](https://github.com/synfig/synfig/commit/39527f633988d8afc04698f22746ffae0a29fb09) refactor: replaced deprecated `hvseparator` include by `separator` ([#2984](https://github.com/synfig/synfig/issues/2984)) [studio]
- [`e087e44`](https://github.com/synfig/synfig/commit/e087e44e449510fd9da1f741e00a0fbeb0f42ba6) refactor: use camelcase for MotionBlur and SolidColor layer names ([#2978](https://github.com/synfig/synfig/issues/2978)) [core] [studio]
- [`b5ef88f`](https://github.com/synfig/synfig/commit/b5ef88f5e9a69523e0e181277fb1288f490b1dcf) refactor: micro cleanup in iconcontroller ([#2979](https://github.com/synfig/synfig/issues/2979)) [studio]
- [`8557dde`](https://github.com/synfig/synfig/commit/8557dde5184ec0f8715b6ff84252b55ef843bb62) refactor: create methods strtolower() and strtoupper() to change cases ([#2977](https://github.com/synfig/synfig/issues/2977)) [core] [studio]
- [`a68a354`](https://github.com/synfig/synfig/commit/a68a354c47ad0165796ca68a231dc451e2fab639) fix: preview dialog now shows the correct start and end times ([#2974](https://github.com/synfig/synfig/issues/2974)) [studio]
- [`742560f`](https://github.com/synfig/synfig/commit/742560f4874e2fefe536c998bf55835e7b9a4730) refactor: rename CanvasView::toggle_show_toolbar() to set_show_toolbars() ([#2975](https://github.com/synfig/synfig/issues/2975)) [studio]
- [`9290c60`](https://github.com/synfig/synfig/commit/9290c6089554592c6a33c90bdccfd233d314e6f2) refactor: remove unused #define POPEN_BINARY_READ_TYPE ([#2925](https://github.com/synfig/synfig/issues/2925)) [ETL]

- [`abad0b8`](https://github.com/synfig/synfig/commit/abad0b8a481f3b914c9b182c0627f747ee3d04e7) refactor: move etl::reference_counter to synfig namespace ([#2949](https://github.com/synfig/synfig/issues/2949)) [ETL] [core] [studio]
- [`f985aac`](https://github.com/synfig/synfig/commit/f985aacdb97fcad7d7de698dc0867ba754651076) refactor: replaced deprecated `signal_pressed()`  with `signal_clicked()` ([#2962](https://github.com/synfig/synfig/issues/2962)) [studio]
- [`be84b8e`](https://github.com/synfig/synfig/commit/be84b8e8e27aa0c75a611148b003ba0eddf5bc61) feat: added hotkey for duplicate layer button ([#2895](https://github.com/synfig/synfig/issues/2895)) [studio]
- [`7e0b486`](https://github.com/synfig/synfig/commit/7e0b48626e9a1880dae93b476ba5d88cecfd2f1b) chore: bump  year to 2023 ([#2966](https://github.com/synfig/synfig/issues/2966)) [studio]
- [`41389cf`](https://github.com/synfig/synfig/commit/41389cfe1ea641075acc52a98ea0452758fc40e1) refactor: remove useless initialization in blur ([#2922](https://github.com/synfig/synfig/issues/2922)) [core]
- [`1e0d777`](https://github.com/synfig/synfig/commit/1e0d777ce411e21a8761c17d097c7979b5ad765f) fix: support FontConfig older than version 2.11.91 ([#2917](https://github.com/synfig/synfig/issues/2917)) [core]
- [`eb625b9`](https://github.com/synfig/synfig/commit/eb625b90032457b4a11144e6dc38077cabf35190) feat: added missing icons and more ([#2955](https://github.com/synfig/synfig/issues/2955)) [studio]
- [`9c96667`](https://github.com/synfig/synfig/commit/9c966671e395df713aeeeabf2978c2455133dea1) fix: show/hide main window toolbar should affect both toolbars ([#2947](https://github.com/synfig/synfig/issues/2947)) [studio]
- [`b2a0c5a`](https://github.com/synfig/synfig/commit/b2a0c5a1ceee03fbd1c3b12f7aad61234d5985f9) refactor: removed deprecated Gtk::VBox and get_vbox() ([#2967](https://github.com/synfig/synfig/issues/2967)) [studio]
- [`80aabd4`](https://github.com/synfig/synfig/commit/80aabd44ddff5e4af0d0d16944fa4abc7903bf21) refactor: remove commented-out methods since march 2005 ([#2956](https://github.com/synfig/synfig/issues/2956)) [studio]
- [`76dbcd1`](https://github.com/synfig/synfig/commit/76dbcd19ce8f95c86a1129b6f5f2aa717efe9b73) refactor: added internal escape_underline() in MainWindow ([#2952](https://github.com/synfig/synfig/issues/2952)) [studio]
- [`414b5d7`](https://github.com/synfig/synfig/commit/414b5d7e42ce0822d07989b4851edf072897e8e7) refactor: move workspace methods from App to MainWindow ([#2942](https://github.com/synfig/synfig/issues/2942)) [studio]
- [`7480fb8`](https://github.com/synfig/synfig/commit/7480fb80de2f03692bd860606a07d33a76ef6211) fix: get_binary_path() for FreeBSD, DragonFlyBSD, NetBSD and OpenBSD ([#2950](https://github.com/synfig/synfig/issues/2950)) [core]
- [`18b6d7f`](https://github.com/synfig/synfig/commit/18b6d7f8b0269b9a3a2ee481de69f3d5c7e7db90) style: some indentation inconsistencies in app.cpp ([#2946](https://github.com/synfig/synfig/issues/2946)) [studio]
- [`54667f3`](https://github.com/synfig/synfig/commit/54667f34bd7f86fd4fd582b1a70d63b4c5ab10bf) fix: no context menu when right-clicking on waypoint ([#2877](https://github.com/synfig/synfig/issues/2877)) [core] [studio]
- [`a1f2a55`](https://github.com/synfig/synfig/commit/a1f2a55416c4e99787dcfe1d64617bbf8a697a6b) refactor: rename load_file_window_size() to load_recent_files() ([#2945](https://github.com/synfig/synfig/issues/2945)) [studio]
- [`04bd002`](https://github.com/synfig/synfig/commit/04bd002911dc1d88f68fa2e551f756c443238fb9) fix: typo in future menubar ([#2948](https://github.com/synfig/synfig/issues/2948)) [studio]
- [`8ff76d0`](https://github.com/synfig/synfig/commit/8ff76d09afae5458f0ef2ce0d624c06329175f4b) refactor!: move ETL blur files to the new synfig/blur folder ([#2924](https://github.com/synfig/synfig/issues/2924)) [ETL] [core] [studio]
- [`a5df2ff`](https://github.com/synfig/synfig/commit/a5df2ffc0f01a90de83d12b85380152dbd84972b) fix: use format string instead of string concatenation ([#2938](https://github.com/synfig/synfig/issues/2938)) [studio]
- [`9be0e01`](https://github.com/synfig/synfig/commit/9be0e01056834a1841162b924d2dc26575c29818) refactor: switched `MainWindow` to `Gtk::ApplicationWindow` ([#2935](https://github.com/synfig/synfig/issues/2935)) [studio]
- [`f1ff964`](https://github.com/synfig/synfig/commit/f1ff9649f6c96ad9edcd59c03d26c79193853162) fix: allow to open external editor for tiff, ppm (& variations) and webp ([#2934](https://github.com/synfig/synfig/issues/2934)) [studio]
- [`9a5d209`](https://github.com/synfig/synfig/commit/9a5d209ca46fd21823956a01adfffb7ca269fa56) fix: wrong Papagayo file extension in Canvas Dependencies dialog ([#2936](https://github.com/synfig/synfig/issues/2936)) [studio]
- [`26733dc`](https://github.com/synfig/synfig/commit/26733dc3b42cf415e8c63835d1bfac936664c625) refactor: no need to change locale on saving accel map ([#2937](https://github.com/synfig/synfig/issues/2937)) [studio]
- [`fcb0ea4`](https://github.com/synfig/synfig/commit/fcb0ea471c577f683f50c032b057dc11279475fc) chore: update ChangeLog ([#2929](https://github.com/synfig/synfig/issues/2929))
- [`8f28ef7`](https://github.com/synfig/synfig/commit/8f28ef77418b9866352b4c77bb2fb842293019cf) refactor: remove unneeded `using namespace etl` and `Action` ([#2923](https://github.com/synfig/synfig/issues/2923)) [core] [studio]
- [`63e661f`](https://github.com/synfig/synfig/commit/63e661f3e3fe99d50a5d572c6060e856adea000e) chore: added `build-cmake/` folder to .gitignore ([#2898](https://github.com/synfig/synfig/issues/2898))
- [`5b33b5f`](https://github.com/synfig/synfig/commit/5b33b5f60610c30edb4e2af58d14f4fa34332bdf) chore: added license description in readme ([#2916](https://github.com/synfig/synfig/issues/2916))
- [`b9e389a`](https://github.com/synfig/synfig/commit/b9e389a6e155d8d0429fe7a2c9c4b380cc3be0cb) feat: added support for `Ctr+<num>` hotkey to change animation tabs ([#2731](https://github.com/synfig/synfig/issues/2731)) [studio]
- [`09d6af8`](https://github.com/synfig/synfig/commit/09d6af81c7b579e30804ab0b2a1506a0287a63a9) refactor: removed unused #includes ([#2920](https://github.com/synfig/synfig/issues/2920)) [core]
- [`ec6ec85`](https://github.com/synfig/synfig/commit/ec6ec85b3b0651aa343d5517c9b6714b5a89d2ae) fix(ffmpeg): logic for detection of image-only videos was inverted ([#2918](https://github.com/synfig/synfig/issues/2918)) [core]
- [`cd34fb3`](https://github.com/synfig/synfig/commit/cd34fb30f955aa6ef39f3f4252c5998549bec3d9) revert: "fix: after exporting audio via ffmpeg, SoundProcessor wasn't stopped" ([#2919](https://github.com/synfig/synfig/issues/2919)) [core]
- [`7a13496`](https://github.com/synfig/synfig/commit/7a13496534706c71a309273bc16126e68e28e85b) fix: after exporting audio via ffmpeg, SoundProcessor wasn't stopped ([#2914](https://github.com/synfig/synfig/issues/2914)) [core]
- [`c91ce50`](https://github.com/synfig/synfig/commit/c91ce50797be72fa56b59f4aa36c986ef504e7b4) fix(ffmpeg): do not try to export audio for gif or mng ([#2915](https://github.com/synfig/synfig/issues/2915)) [core]
- [`a2bb1c5`](https://github.com/synfig/synfig/commit/a2bb1c564221e605862b1d9d26ccd449de70bd38) feat: eyedropper tool now takes fill color instead of outline color by default ([#2908](https://github.com/synfig/synfig/issues/2908)) [studio]
- [`5429e5f`](https://github.com/synfig/synfig/commit/5429e5ffd4d476355355a12a5ee6d2d2d977c11d) ci: added `synchronize` to the list of processed events ([#2913](https://github.com/synfig/synfig/issues/2913))
- [`8155567`](https://github.com/synfig/synfig/commit/81555677e3495fa0174470da0b4cc447019521ef) refactor: cleanup etl blur files ([#2910](https://github.com/synfig/synfig/issues/2910)) [ETL] [core]
- [`189556c`](https://github.com/synfig/synfig/commit/189556c8ea75d15fa188385055ebff9456d00940) fix: canvas dependencies dialog crashes with empty filenames or without extension ([#2904](https://github.com/synfig/synfig/issues/2904)) [studio]
- [`fbdf4b6`](https://github.com/synfig/synfig/commit/fbdf4b665263509d457ca1cfc8b4dc90628d7bff) ci: bump Ubuntu version ([#2839](https://github.com/synfig/synfig/issues/2839))
- [`cc48fed`](https://github.com/synfig/synfig/commit/cc48fed938fcbebdfd40779bad951af42d8880cf) ci: bump GitHub actions ([#2907](https://github.com/synfig/synfig/issues/2907))
- [`31f3457`](https://github.com/synfig/synfig/commit/31f3457d0b8da53fde38dbd2d98301a62bc2329d) ci: added conventional commits style check for PR titles ([#2909](https://github.com/synfig/synfig/issues/2909))
- [`b88a544`](https://github.com/synfig/synfig/commit/b88a544996aff4112b2c801b47257f26916c0f4e) refactor: move pen classes from ETL to synfig-core ([#2888](https://github.com/synfig/synfig/issues/2888)) [ETL] [core]
- [`e8c2b55`](https://github.com/synfig/synfig/commit/e8c2b5519dbc989c4018d428f2506d5074a2306e) refactor(UI): rename Eyedrop Tool to Eyedropper Tool ([#2902](https://github.com/synfig/synfig/issues/2902)) [studio]
- [`135f7fe`](https://github.com/synfig/synfig/commit/135f7fe25b3c50d09fb9002fccb70a7c92113781) refactor: use some current C++-11 or gtkmm-3 methods ([#2903](https://github.com/synfig/synfig/issues/2903)) [studio]
- [`e41f5a7`](https://github.com/synfig/synfig/commit/e41f5a7dfcfed3b255664acba87e7336ea6487a0) fix: don't list empty filenames on Canvas Dependencies dialog ([#2905](https://github.com/synfig/synfig/issues/2905)) [studio]
- [`3c0c35a`](https://github.com/synfig/synfig/commit/3c0c35ad0aa43c7f1efdf2236259cb66eaafaa8f) feat: New and updated icons for "width interpolation" ([#2882](https://github.com/synfig/synfig/issues/2882)) [studio] [core]
- [`520bec6`](https://github.com/synfig/synfig/commit/520bec620d3070f110f760aced3bceed3a5c33b4) feat: add Show Canvas External Dependencies dialog ([#2472](https://github.com/synfig/synfig/issues/2472)) [core] [studio]
- [`3d3f008`](https://github.com/synfig/synfig/commit/3d3f0086ade92630e2649e5e8b4c2df45ca77837) test: fix synfig/benchmark test build ([#2890](https://github.com/synfig/synfig/issues/2890)) [core]
- [`1e55a85`](https://github.com/synfig/synfig/commit/1e55a859e7de051ff6ad8ead0e5b97775ea7c47d) refactor: avoid std::iterator_traits in ETL/gaussian ([#2889](https://github.com/synfig/synfig/issues/2889)) [ETL]
- [`72ed46d`](https://github.com/synfig/synfig/commit/72ed46db11a062edad03ffe44b9d19bcb4ca36cb) fix(lang): Spanish translation typo ([#2879](https://github.com/synfig/synfig/issues/2879)) [studio]
- [`ecd8ea6`](https://github.com/synfig/synfig/commit/ecd8ea634ee45dcbb6ceb941988c55d1ae99be46) refactor(NoiseDistort): remove useless method, argument, intermediate var ([#2887](https://github.com/synfig/synfig/issues/2887)) [core]
- [`980fd1e`](https://github.com/synfig/synfig/commit/980fd1e8230e25f3ab4e8d325ccda54c82993ae6) build(appveyor): added missing libpcre2 ([#2886](https://github.com/synfig/synfig/issues/2886))
- [`94b9861`](https://github.com/synfig/synfig/commit/94b98610c974c1d30a78c93af9492be7592fa24f) refactor: cleanup on ETL/pen ([#2881](https://github.com/synfig/synfig/issues/2881)) [ETL]
- [`8d50079`](https://github.com/synfig/synfig/commit/8d50079c16095b0cc8f49ff946d52a03c2226781) refactor: minor cleanup in ETL box_blur ([#2873](https://github.com/synfig/synfig/issues/2873)) [ETL]
- [`5584006`](https://github.com/synfig/synfig/commit/558400604d215fb91d9984788ecc3313f9f2e0bb) refactor: removed unused Gtk::IconSIze ([#2878](https://github.com/synfig/synfig/issues/2878)) [studio]
- [`2c1244b`](https://github.com/synfig/synfig/commit/2c1244b5425ffeceea523fddf4c9d672b125f624) refactor: remove some unused methods and add docs to synfig::surface ([#2871](https://github.com/synfig/synfig/issues/2871)) [core]
- [`7760dc2`](https://github.com/synfig/synfig/commit/7760dc2db65d0151da61b9c2b56de98ff3aab2ec) refactor: move ETL/misc to synfig/misc.h ([#2874](https://github.com/synfig/synfig/issues/2874)) [ETL] [core] [studio]
- [`8bf9c30`](https://github.com/synfig/synfig/commit/8bf9c30cbef249b842f3d5f2c002a71897ee94c5) fix: Fixes issue [#2857](https://github.com/synfig/synfig/issues/2857) when changing interpolation of Canvas parameter changes interpolation for other waypoints ([#2858](https://github.com/synfig/synfig/issues/2858)) [core]
- [`92b537c`](https://github.com/synfig/synfig/commit/92b537c14a5992b13125aa9c98622e949390cdd5) ui: Rename "Target" dropdown to "Module" in rendering dialog ([#2869](https://github.com/synfig/synfig/issues/2869)) [studio]
- [`284723d`](https://github.com/synfig/synfig/commit/284723da82463729b632d11a03f4a7dbc53647e1) refactor!: move ETL/surface to synfig/surface_etl.h and its test file ([#2870](https://github.com/synfig/synfig/issues/2870)) [ETL] [core]
- [`d9a37d3`](https://github.com/synfig/synfig/commit/d9a37d301cbdf0eaadb1bdbd2083ab7a05835b29) refactor: remove unused class `debugclass` ([#2865](https://github.com/synfig/synfig/issues/2865)) [studio]
- [`1cfeeee`](https://github.com/synfig/synfig/commit/1cfeeee8bcc18bd722a76241b68501db5addc330) chore: fix typos ([#2863](https://github.com/synfig/synfig/issues/2863)) [core] [studio]
- [`71a3041`](https://github.com/synfig/synfig/commit/71a30418475bf1800d97b1437561a22272cad02d) perf: avoid double computation ([#2849](https://github.com/synfig/synfig/issues/2849)) [core]
- [`06f4ca8`](https://github.com/synfig/synfig/commit/06f4ca8a72b1792032892194fcf602ab635c6a41) fix: hide bone width handles when they are meaningless ([#2778](https://github.com/synfig/synfig/issues/2778)) [studio]
- [`296bd31`](https://github.com/synfig/synfig/commit/296bd31b3636b51c6d65bdc2f6b30043525cdd60) refactor: remove unused alternative clamping functions ([#2845](https://github.com/synfig/synfig/issues/2845)) [ETL] [core]
- [`cf5adb6`](https://github.com/synfig/synfig/commit/cf5adb6ad0c9b9f10cbf56d9adcbecde2d106214) refactor: remove some unused #include directives ([#2851](https://github.com/synfig/synfig/issues/2851)) [core]
- [`d918328`](https://github.com/synfig/synfig/commit/d918328c60a553c9838ede48f0332d3fca967bca) fix: use correct `abs()` function for integer variable ([#2852](https://github.com/synfig/synfig/issues/2852)) [core]
- [`72ad997`](https://github.com/synfig/synfig/commit/72ad997726643b97112baa12ba3617adb99957be) refactor: remove Accumulator type for etl::pen and etl::surface ([#2854](https://github.com/synfig/synfig/issues/2854)) [ETL] [core]
- [`c23a440`](https://github.com/synfig/synfig/commit/c23a44029d4a304ca3500a97de858a0b353331ae) refactor: remove unused methods in blur.cpp ([#2848](https://github.com/synfig/synfig/issues/2848)) [core]
- [`ced73c9`](https://github.com/synfig/synfig/commit/ced73c9251724c9ae420a12081b5e2cd8a3c2a93) feat(studio): added buttons to change interpolation for selected waypoints ([#2615](https://github.com/synfig/synfig/issues/2615)) [studio]
- [`3793e18`](https://github.com/synfig/synfig/commit/3793e18be9493a428ec8258e2ec8df6416efd359) refactor: move non-portable popen code to one place ([#2491](https://github.com/synfig/synfig/issues/2491)) [core] [studio]
- [`6ae600b`](https://github.com/synfig/synfig/commit/6ae600b7e530e74aaec377336b9d9a824371a49a) perf: improved performance by reducing memory copying when working with valuenodes ([#2831](https://github.com/synfig/synfig/issues/2831)) [core] [studio]
- [`a747d1c`](https://github.com/synfig/synfig/commit/a747d1cdf902ddd2cb305da9720f438f0b41d3cc) refactor!: etl::bezier and etl::hermite are now in synfig folder and namespace ([#2840](https://github.com/synfig/synfig/issues/2840)) [ETL] [core] [studio]
- [`d1abacc`](https://github.com/synfig/synfig/commit/d1abacc42fc88faf49c56370a82b5ee98486640f) build: updated dependencies for Debian 11 based distros ([#2837](https://github.com/synfig/synfig/issues/2837))
- [`2e3bcd9`](https://github.com/synfig/synfig/commit/2e3bcd9d7dfa6cab8ec1505f06e2bd8469bd5a81) refactor: cleanup, add docs and merge ETL/hermite with ETL/bezier ([#2808](https://github.com/synfig/synfig/issues/2808)) [ETL] [core] [studio]
- [`d6dd306`](https://github.com/synfig/synfig/commit/d6dd30671e9abfa1873fb9470601291a0ea6fd14) fix: use runtime check of openGL availability, instead of compile-time ([#2835](https://github.com/synfig/synfig/issues/2835)) [studio]
- [`630eddc`](https://github.com/synfig/synfig/commit/630eddc0c92c37322aae4dc0309c152ea4bc7f2e) feat: Added support for scrolling through text in text paragraph dialog ([#2810](https://github.com/synfig/synfig/issues/2810)) [studio]
- [`0be02a8`](https://github.com/synfig/synfig/commit/0be02a8f146429d88798766fe2c0fe62a10b2be3) fix: broken opengl build (due to ETL_DIRECTORY_SEPARATOR) and typos ([#2834](https://github.com/synfig/synfig/issues/2834)) [core]
- [`994622b`](https://github.com/synfig/synfig/commit/994622bb93d3abcf2e4fa2b168951b8369422905) fix: prevent crash or hang when frame cannot be imported ([#2830](https://github.com/synfig/synfig/issues/2830)) [core]
- [`fbe312d`](https://github.com/synfig/synfig/commit/fbe312da00d7a748b553f4b5b97dc2fe14b546de) feat: reduced displayed floating point precision ([#2809](https://github.com/synfig/synfig/issues/2809)) [core] [studio]
- [`ef1cb75`](https://github.com/synfig/synfig/commit/ef1cb75f5f187b06d8b39d25d1c2a411fe2140d5) build(cmake): fixed build when path contains non-Latin characters (MSYS2) ([#2821](https://github.com/synfig/synfig/issues/2821)) [studio]
- [`64b8aa0`](https://github.com/synfig/synfig/commit/64b8aa0f98acc7486cc684cd78a3fa7ee191bba9) build(autotools): fix MSYS2 build ([#2818](https://github.com/synfig/synfig/issues/2818)) [core]
- [`9625d20`](https://github.com/synfig/synfig/commit/9625d20d90dc93cf98246a616a37eec5c6ace21a) feat: ico format added to `mod_imagemagick` list of exported formats ([#2820](https://github.com/synfig/synfig/issues/2820)) [core]
- [`c6ff86f`](https://github.com/synfig/synfig/commit/c6ff86f0eb722189b7fd3f88afda8cffe0a9d698) refactor: replaced deprecated Gtk::Arrow with Gtk::Button with icon ([#2824](https://github.com/synfig/synfig/issues/2824)) [studio]
- [`11387aa`](https://github.com/synfig/synfig/commit/11387aa840051300a5c7866b0b8fe89bd9dd731e) fix: "rule of two" : copy constructor and copy assignment operator ([#2823](https://github.com/synfig/synfig/issues/2823)) [core] [studio]
- [`2d4d77a`](https://github.com/synfig/synfig/commit/2d4d77a5711646544b8c7b65a6d250e32fc2ad82) refactor: clean up Magick++ target a bit ([#2822](https://github.com/synfig/synfig/issues/2822)) [core]
- [`1ce65b6`](https://github.com/synfig/synfig/commit/1ce65b6f96a210c56c45d309be7310bffac16507) fix: pressing the cancel button still adds the text layer ([#2814](https://github.com/synfig/synfig/issues/2814)) [studio]
- [`da13b77`](https://github.com/synfig/synfig/commit/da13b77425c833434723dc8d22ce5c25410105e1) build(vcpkg): `cmake --install` now also installs required dependencies ([#2816](https://github.com/synfig/synfig/issues/2816)) [core] [studio]
- [`dd55c0f`](https://github.com/synfig/synfig/commit/dd55c0f3f982d676696e58fafb9175e4cd388e13) fix(msvc): fixed debug build in MSVC ([#2812](https://github.com/synfig/synfig/issues/2812)) [core]
- [`c6eb41d`](https://github.com/synfig/synfig/commit/c6eb41d71876092484cf2a814c6a294beb78ac1e) build: Use vcpkg to build synfig ([#2725](https://github.com/synfig/synfig/issues/2725)) [core] [studio]
- [`9cecd2a`](https://github.com/synfig/synfig/commit/9cecd2abe143e29cf0564e511183beebab7dfafb) feat: added ability to show/hide rulers ([#2634](https://github.com/synfig/synfig/issues/2634)) [studio]
- [`5aee83b`](https://github.com/synfig/synfig/commit/5aee83b4f54d15f1b4b3b216e1122da064c69d63) fix: params panel doesn't update after layer switch ([#2811](https://github.com/synfig/synfig/issues/2811)) [studio]
- [`36896b9`](https://github.com/synfig/synfig/commit/36896b9237a3a1e0e73a117b9775a738da6c7446) fix: avoid rebuild ParamTreeStore when animating a parameter ([#2729](https://github.com/synfig/synfig/issues/2729)) [studio]
- [`361ffce`](https://github.com/synfig/synfig/commit/361ffce745bbe2534ffdee5e05dca80b7cdb55e1) chore: updated changelog ([#2774](https://github.com/synfig/synfig/issues/2774))
- [`9cc796e`](https://github.com/synfig/synfig/commit/9cc796e08727bf478c87dc93a74e46822398a16b) refactor!: add etl::hermite::derivative() and remove ETL/calculus ([#2791](https://github.com/synfig/synfig/issues/2791)) [ETL] [core] [studio]
- [`4c99713`](https://github.com/synfig/synfig/commit/4c997135228c7b2f3767bb2f6420bb9acdd93f59) fix: hit_check for gradient & paste_canvas layers with BEHIND and ONTO blends ([#2804](https://github.com/synfig/synfig/issues/2804)) [core]
- [`ac8214e`](https://github.com/synfig/synfig/commit/ac8214e47fd71dbec1066f475e98bd9dda5859e7) fix: Fixed issue with incorrect ffmpeg search on Windows ([#2797](https://github.com/synfig/synfig/issues/2797)) [core]
- [`e289d69`](https://github.com/synfig/synfig/commit/e289d69bbccffe77158d7d2b65d932896c0fac04) feat: added support for SVG image sequence with lst files ([#2795](https://github.com/synfig/synfig/issues/2795)) [core]
- [`fc78ce7`](https://github.com/synfig/synfig/commit/fc78ce7992df6171e24ebd57292c19a5dfc3a45c) chore: fix source typos ([#2803](https://github.com/synfig/synfig/issues/2803)) [studio]
- [`2d13c78`](https://github.com/synfig/synfig/commit/2d13c78149795212602d54272a3efaec6e2a2eb2) fix: check whether iterator is valid before dereferencing ([#2798](https://github.com/synfig/synfig/issues/2798)) [studio]
- [`e049441`](https://github.com/synfig/synfig/commit/e049441d38a714e142a586d73086847c5330aba0) chore: fix various typos ([#2799](https://github.com/synfig/synfig/issues/2799)) [ETL] [core] [studio]
- [`226b22d`](https://github.com/synfig/synfig/commit/226b22dfc12b94bb064ab6fc9676c0f3ddd0ada1) build: remove nonexistent files listed in synfig-core/po/POTFILES.in ([#2794](https://github.com/synfig/synfig/issues/2794)) [core]
- [`6bf36b9`](https://github.com/synfig/synfig/commit/6bf36b96769badbc4aa66976f6df928cac3acc78) fix: using invalid iterator in ValueNode_Bone ([#2793](https://github.com/synfig/synfig/issues/2793)) [core]
- [`25f28b1`](https://github.com/synfig/synfig/commit/25f28b14214bcc98d736ce88138e79f087d56510) fix!: imagemagick didn't import anything ([#2789](https://github.com/synfig/synfig/issues/2789)) [core]
- [`0a545cc`](https://github.com/synfig/synfig/commit/0a545ccbbdf1dd255de1c45a23797b428d9c4e75) build(autotools): include UI files created via PR [#2638](https://github.com/synfig/synfig/issues/2638) ([#2786](https://github.com/synfig/synfig/issues/2786)) [studio]
- [`12252fe`](https://github.com/synfig/synfig/commit/12252fefb172c4b6d4d78a4f5cf8b6351b83961f) ci: disabled `mod_magickpp` in macOS builds ([#2790](https://github.com/synfig/synfig/issues/2790))
- [`38cc869`](https://github.com/synfig/synfig/commit/38cc869732922a2f2e61fb986626fb4fb513c952) chore: typo in comment ([#2785](https://github.com/synfig/synfig/issues/2785)) [core]
- [`671407c`](https://github.com/synfig/synfig/commit/671407c3e6e073a8127e82172206f5b88275af40) test: missing keyframe test in CMake ([#2784](https://github.com/synfig/synfig/issues/2784)) [core]
- [`c7b3bf0`](https://github.com/synfig/synfig/commit/c7b3bf03b5e1b6cbcf02cb5660bb86388309dc14) refactor: removed code from ImageMagick module commented out from 2005 ([#2783](https://github.com/synfig/synfig/issues/2783)) [core]
- [`54e4987`](https://github.com/synfig/synfig/commit/54e49872deb52b39457ac2406812e4280531c7ca) ci: Updated ChangeLog generator script ([#2782](https://github.com/synfig/synfig/issues/2782))
- [`19e3e5f`](https://github.com/synfig/synfig/commit/19e3e5f51d718dd59d2b65a1104925416380c954) fix: Interface background became white after clicking OK in Preferences dialog ([#2732](https://github.com/synfig/synfig/issues/2732)) [studio]
- [`fc38d7c`](https://github.com/synfig/synfig/commit/fc38d7c0daf676760ca06523a644ebdc386fd77e) refactor: prefer FileSystemNative rather GLib ([#2780](https://github.com/synfig/synfig/issues/2780)) [core]
- [`0ce508f`](https://github.com/synfig/synfig/commit/0ce508fcfcf32671dab1e6f36d4c4a286ad7034f) refactor: remove deprecated Gtk::StockID used by some Gtk::Image constructors ([#2776](https://github.com/synfig/synfig/issues/2776)) [studio]
- [`021410d`](https://github.com/synfig/synfig/commit/021410d7ddde74960a4fbdc957b346457b42d7d6) fix: fixed broken synfig.dll debugging in MSVC build ([#2764](https://github.com/synfig/synfig/issues/2764)) [core] [studio]
- [`f05ee82`](https://github.com/synfig/synfig/commit/f05ee822ec59d47cf019b56aeb054428498175ac) fix: Alpha channel always resets when changing color in HSV wheel ([#2690](https://github.com/synfig/synfig/issues/2690)) [studio]
- [`fa54ae6`](https://github.com/synfig/synfig/commit/fa54ae61b8cf22a7de528a0ef6f2dc911f44fa34) refactor: clean `synfig::Target` a bit ([#2775](https://github.com/synfig/synfig/issues/2775)) [core]
- [`be79626`](https://github.com/synfig/synfig/commit/be796264b44503bda1bcd6338ff033d1293c63e1) refactor!: remove etl::unix_to_local() ([#2773](https://github.com/synfig/synfig/issues/2773)) [ETL] [core]
- [`f4d73a0`](https://github.com/synfig/synfig/commit/f4d73a08d5d4e6abaca4934d7121b6d6a7666d2a) chore: Fixed a typo in Preferences->Language dropdown ([#2770](https://github.com/synfig/synfig/issues/2770)) [studio]
- [`4f42a90`](https://github.com/synfig/synfig/commit/4f42a902e5bf5304a71b0afa843560db81f9cfd3) fix: Fix cross-compilation with MinGW on Debian 11 ([#2772](https://github.com/synfig/synfig/issues/2772)) [ETL] [core] [studio]
- [`53c5984`](https://github.com/synfig/synfig/commit/53c5984cfcfbc4e73a6c1dd7656f9badf147264f) revert: eliminate the need to set_time() on the search for bones ([#2771](https://github.com/synfig/synfig/issues/2771)) [studio]
- [`fc4c3b3`](https://github.com/synfig/synfig/commit/fc4c3b390062d3e45c5451bc75b100dc56b6802e) fix: fixed a bug when saving a file to a Windows drive root path and then reusing the file dialog ([#2762](https://github.com/synfig/synfig/issues/2762)) [ETL]
- [`f43ba68`](https://github.com/synfig/synfig/commit/f43ba68d4bdd0e7bda2abe84d5cfc68837e275c5) test: Disabled failing test of `synfig::Node` class for now ([#2769](https://github.com/synfig/synfig/issues/2769)) [core]
- [`61fc780`](https://github.com/synfig/synfig/commit/61fc7801ae12f15c6f76d2409fb33acfc095606d) fix: fixed build when MLT library not found ([#2760](https://github.com/synfig/synfig/issues/2760)) [core]
- [`6fb0596`](https://github.com/synfig/synfig/commit/6fb0596575c2755b594e38b76ce9b819e3b8b8e3) fix: synfig studio was not saving synfigapp settings on quit ([#2751](https://github.com/synfig/synfig/issues/2751)) [studio]
- [`19bbb77`](https://github.com/synfig/synfig/commit/19bbb770be6ca20a48f0424ce622633653451291) ci: bump macOS version ([#2761](https://github.com/synfig/synfig/issues/2761))
- [`2363d73`](https://github.com/synfig/synfig/commit/2363d73a95a586f6200daea3666f395a1063c28e) fix!: for some layers hit_check() missed some blend method influence ([#2754](https://github.com/synfig/synfig/issues/2754)) [core]
- [`c5e6833`](https://github.com/synfig/synfig/commit/c5e6833f7d1b1da385ceba57c7809773b9aad600) fix: setting filename parameter of Layer Sound corrupts file ([#2758](https://github.com/synfig/synfig/issues/2758)) [core]
- [`d1192e1`](https://github.com/synfig/synfig/commit/d1192e1d4685b0e4db9d1a0b94423fdcd0b0d90b) Merge PR [#2712](https://github.com/synfig/synfig/issues/2712): refactor!: clean `synfig::Keyframe` [core]
- [`77c13ef`](https://github.com/synfig/synfig/commit/77c13ef64ac70e813aefdd9f2687a0bb89fbebf0) fix: small memory leak with Mlt++ ([#2752](https://github.com/synfig/synfig/issues/2752)) [core]
- [`7656b65`](https://github.com/synfig/synfig/commit/7656b65b2dff182e0114b17dce1dbcc529c28901) refactor: removed unused Widget_CompSelect ([#2753](https://github.com/synfig/synfig/issues/2753)) [studio]
- [`c6075b3`](https://github.com/synfig/synfig/commit/c6075b308b9717c7591ed4b1f1afe4992d131406) Merge PR [#2735](https://github.com/synfig/synfig/issues/2735): refactor!: move strprintf(), strscan(), etc from etl to synfig namespace [ETL] [core] [studio]
- [`aa3f1a7`](https://github.com/synfig/synfig/commit/aa3f1a7e39644c3e9bb6a6991da97b2dc7863fa8) test: create tests for synfig/string_helper.h ([#2738](https://github.com/synfig/synfig/issues/2738)) [core]
- [`e8b6de0`](https://github.com/synfig/synfig/commit/e8b6de075b1e5e5fa5d810aca6d3a7710b1bd0d2) ci(AppVeyor): bump artifact version ([#2749](https://github.com/synfig/synfig/issues/2749))
- [`0bebfe6`](https://github.com/synfig/synfig/commit/0bebfe665740cc33b13513e8547fea2e3dcb7e64) fix: Spline tool blocks hotkey presses ([#2748](https://github.com/synfig/synfig/issues/2748)) [studio]
- [`b836a72`](https://github.com/synfig/synfig/commit/b836a72d4149552d562863db62efd5fa567fbe51) build(CMake): moved synfig-core tests to `bin/test` folder ([#2746](https://github.com/synfig/synfig/issues/2746)) [core]
- [`cd4f64e`](https://github.com/synfig/synfig/commit/cd4f64e353fb6875d02cf6300adee4afc47dd669) build(autotools): removed Apple G5-specific flags ([#2745](https://github.com/synfig/synfig/issues/2745)) [ETL] [core] [studio]
- [`b142f0e`](https://github.com/synfig/synfig/commit/b142f0e39a89b37e83a4eb6c53932abce110e411) build(autotools): fixed node test build ([#2744](https://github.com/synfig/synfig/issues/2744)) [ETL] [core] [studio]
- [`1958902`](https://github.com/synfig/synfig/commit/1958902d74a377987994fb3cc33a6e3f8b0533d9) test: define ‘operator<<’ for operands std::string and std::nullptr_t ([#2742](https://github.com/synfig/synfig/issues/2742)) [core] [studio]
- [`163100e`](https://github.com/synfig/synfig/commit/163100eb6ca41432e118d1d88aed4ff8ac404b24) fix: Missing menu in Synfig when path to plugins contains non-Latin symbols (Windows) ([#2652](https://github.com/synfig/synfig/issues/2652)) [studio]
- [`ae38d79`](https://github.com/synfig/synfig/commit/ae38d7928726fcc377fae111016e4d656a5f0647) refactor: Replaced deprecated Gtk::StockID in Sets panel ([#2683](https://github.com/synfig/synfig/issues/2683)) [studio]
- [`aa8f1f3`](https://github.com/synfig/synfig/commit/aa8f1f35bcd67a7aaf765b6c7b3e152a39cfc1af) build(CMake): added synfig tests to CMake ([#2741](https://github.com/synfig/synfig/issues/2741)) [core]
- [`f0acb53`](https://github.com/synfig/synfig/commit/f0acb53c4063513d0f3d89b7320f6068bc1fda0d) Merge PR [#2726](https://github.com/synfig/synfig/issues/2726): fix: Parameter & Library Panels are now more similar to TimeTrack Panel [studio]
- [`e40d909`](https://github.com/synfig/synfig/commit/e40d90912e7103a4fcfd7cab51d92812a4bae9c9) build(CMake): enabled `mod_libavcodec` build in CMake ([#2736](https://github.com/synfig/synfig/issues/2736)) [core]
- [`18bc75f`](https://github.com/synfig/synfig/commit/18bc75fed3c6034b067049cdc6e0012366962738) Merge PR [#2718](https://github.com/synfig/synfig/issues/2718): refactor!: `smach` class is now moved to `studio` namespace [studio]
- [`cc088a0`](https://github.com/synfig/synfig/commit/cc088a06c4d0105c8883db60121e19725ccc2f59) Merge PR [#2733](https://github.com/synfig/synfig/issues/2733): refactor(ETL): delete unneeded etl_config.h [ETL]
- [`23adb48`](https://github.com/synfig/synfig/commit/23adb486a6a71091cb9bfb71b65a70ca4edd46ea) Merge PR [#2715](https://github.com/synfig/synfig/issues/2715): refactor!: removed etl::angle; replaced by synfig::Angle [ETL] [core] [studio]
- [`e64c7d6`](https://github.com/synfig/synfig/commit/e64c7d6784fa10ab8b1753c0c03ab120269fa1c0) fix: Indicate segments where points are disabled in Timetrack Panel (regression) ([#2719](https://github.com/synfig/synfig/issues/2719)) [studio]
- [`383ac11`](https://github.com/synfig/synfig/commit/383ac11215883a80017d2754bb0718ae6eb7194c) fix(FreeType): Duplicating Text Layer resets Font Family parameter ([#2728](https://github.com/synfig/synfig/issues/2728)) [core]
- [`9a6b616`](https://github.com/synfig/synfig/commit/9a6b6168eedc9b936b9227ddfc386328719f0e01) fix: layers parameter 'filename' does not accept backslash as directory separator ([#2727](https://github.com/synfig/synfig/issues/2727)) [core]
- [`081d9ab`](https://github.com/synfig/synfig/commit/081d9ab94fee9e3083b6db3a9f7f4dd002847d57) Merge PR [#2722](https://github.com/synfig/synfig/issues/2722): fix: palette loading [core]
- [`0cead9d`](https://github.com/synfig/synfig/commit/0cead9d7c05e98f8cf7ab9ea2f4f9cbd3eb23628) refactor: remove unneeded #include <ETL/misc> directives ([#2713](https://github.com/synfig/synfig/issues/2713)) [core] [studio]
- [`1585dd5`](https://github.com/synfig/synfig/commit/1585dd5840e0b960ca7be0141a6571aa3f837acf) refactor!: rename `etl::clock` to `synfig::clock` ([#2711](https://github.com/synfig/synfig/issues/2711)) [ETL] [core] [studio]
- [`4dbf2cd`](https://github.com/synfig/synfig/commit/4dbf2cdf7cacf3b3e0cebb88c0f7a77bdccabaf9) refactor: make use of synfig::clamp instead of std::max(std::min()) ([#2714](https://github.com/synfig/synfig/issues/2714)) [core] [studio]
- [`5b8a8b9`](https://github.com/synfig/synfig/commit/5b8a8b9c445f85c8faca9308db6e019fe020f5a8) Merge PR [#2385](https://github.com/synfig/synfig/issues/2385): fix: Added missing timetrack marks (animated_file timepoints and active points on/off) [studio]
- [`cc59c12`](https://github.com/synfig/synfig/commit/cc59c1247fcdaa1c293bc1fc704922bd9348f7a1) refactor: Replaced deprecated Gtk::StockID in ResolutionDial ([#2697](https://github.com/synfig/synfig/issues/2697)) [studio]
- [`69dc1f7`](https://github.com/synfig/synfig/commit/69dc1f7b9f06ba36273c393eebc29214e46a3e46) fix: Synfig does not start if the OS username contains non-Latin characters (Windows) ([#2650](https://github.com/synfig/synfig/issues/2650)) [core] [studio]
- [`af37e2a`](https://github.com/synfig/synfig/commit/af37e2af26e0b49d7aabd4ec72d121c786142091) Merge PR [#2708](https://github.com/synfig/synfig/issues/2708): refactor!: clean etl::angle [ETL]
- [`e1c9ab6`](https://github.com/synfig/synfig/commit/e1c9ab6f6dc19c410dea4687fdc1d6f1fb596227) refactor: Replaced deprecated Gtk::StockID in Palette Editor ([#2685](https://github.com/synfig/synfig/issues/2685)) [studio]
- [`16bab1d`](https://github.com/synfig/synfig/commit/16bab1d4d6cc679424ad32f4d60603832e197c32) refactor: remove `ETL_DIRECTORY_SEPARATORS`; use them directly ([#2706](https://github.com/synfig/synfig/issues/2706)) [ETL] [studio]
- [`d768672`](https://github.com/synfig/synfig/commit/d7686727280ded16b14591393ba0252559324683) test(etl): remove unused methods for etl::angle ([#2705](https://github.com/synfig/synfig/issues/2705)) [ETL]
- [`df98681`](https://github.com/synfig/synfig/commit/df98681de39d4e011020bf4515642a8bf805cd2d) test(etl): remove unused methods for etl::hermite ([#2707](https://github.com/synfig/synfig/issues/2707)) [ETL]
- [`fb75250`](https://github.com/synfig/synfig/commit/fb7525059980eafb361f7bd435e05099271c3dfd) refactor(core)!: rename ValueNode::is_descendant() to is_ancestor_of() ([#2702](https://github.com/synfig/synfig/issues/2702)) [core] [studio]
- [`603ded0`](https://github.com/synfig/synfig/commit/603ded0b7fc27bc7da6ea61c53142e031a3fbec1) refactor: use etl::is_separator() instead of directory separator chars ([#2704](https://github.com/synfig/synfig/issues/2704)) [ETL] [core]
- [`9840962`](https://github.com/synfig/synfig/commit/984096283c18f8ba99f78484a3c2f987b05abf92) refactor: use `/` as directory separator where a fixed folder name is used ([#2703](https://github.com/synfig/synfig/issues/2703)) [ETL] [core] [studio]
- [`e93442f`](https://github.com/synfig/synfig/commit/e93442f6e2e485572f3dbfa2a68d1ec28ec08d23) test(studio): as in synfig-core, separate test_base.h ([#2701](https://github.com/synfig/synfig/issues/2701)) [studio]
- [`d6f4d4d`](https://github.com/synfig/synfig/commit/d6f4d4d404e51c0716e30bcd4f4e544413d2023f) chore: update license statement for test_base.h ([#2700](https://github.com/synfig/synfig/issues/2700)) [core]
- [`cd9c265`](https://github.com/synfig/synfig/commit/cd9c265f6a7c70377482d4894552ec5a0d38ddb4) Merge PR [#2699](https://github.com/synfig/synfig/issues/2699): refactor!: remove `etl::ceil_to_int` and `etl::floor_to_int` [ETL] [core] [studio]
- [`334b9a5`](https://github.com/synfig/synfig/commit/334b9a5b40320967d1d8cf89a8f98a3eb15a6bc3) refactor: Replaced deprecated Gtk::StockID (non-visual) ([#2668](https://github.com/synfig/synfig/issues/2668)) [studio]
- [`3e5e005`](https://github.com/synfig/synfig/commit/3e5e00588650ff239ed1dd719d5c7039eac5dd05) refactor: remove unused header/class synfig::Protocol ([#2698](https://github.com/synfig/synfig/issues/2698)) [core]
- [`6086e34`](https://github.com/synfig/synfig/commit/6086e341d0f382cd0d2f20233938162fcda2acaa) feat: Added support for `Ctr+Enter` to complete text input in Text tool dialog ([#2689](https://github.com/synfig/synfig/issues/2689)) [studio]
- [`5f3563a`](https://github.com/synfig/synfig/commit/5f3563a83884e867f1d9716dfa5751d50b074bad) refactor: removed deprecated `std::unary_function` and `std::binary_function` classes ([#2696](https://github.com/synfig/synfig/issues/2696)) [ETL] [core]
- [`886cff7`](https://github.com/synfig/synfig/commit/886cff70fdfe6c8881f59a28772e2b085eb82720) fix: Synfig hanging after right-click on sub-sub-parameter ([#2693](https://github.com/synfig/synfig/issues/2693)) [core]
- [`c71f381`](https://github.com/synfig/synfig/commit/c71f381307afce72230a9aa690da2c3d85d74293) Merge PR [#2695](https://github.com/synfig/synfig/issues/2695): refactor: remove NULL; use nullptr instead - part 2 [ETL] [core]
- [`6bb848b`](https://github.com/synfig/synfig/commit/6bb848ba874392232d0a96492371451cb266e6aa) Merge PR [#2691](https://github.com/synfig/synfig/issues/2691): refactor: remove NULL; use nullptr instead [ETL] [studio]
- [`d308459`](https://github.com/synfig/synfig/commit/d308459c9822ac096a0d7f1a9863de0d240ba032) refactor: Replaced deprecated Gtk::StockID in WidgetLink ([#2665](https://github.com/synfig/synfig/issues/2665)) [studio]
- [`6bf8494`](https://github.com/synfig/synfig/commit/6bf84945486c54423db70dba41200aa26c2dfe2a) refactor: Replaced deprecated Gtk::StockID in Widget Interpolation ([#2666](https://github.com/synfig/synfig/issues/2666)) [studio]
- [`051a740`](https://github.com/synfig/synfig/commit/051a740a750dcd87675eeb35cf0fc41557ea1f4a) fix: Wrong color in HSV wheel when color was changed with paint bucket ([#2679](https://github.com/synfig/synfig/issues/2679)) [studio]
- [`ec3fd21`](https://github.com/synfig/synfig/commit/ec3fd21b14f2e175bc7e79fd924310c10bae001a) BREAKING CHANGE: replace `etl::smart_ptr` with `std::shared_ptr` ([#2686](https://github.com/synfig/synfig/issues/2686)) [ETL] [core] [studio]
- [`a7039b5`](https://github.com/synfig/synfig/commit/a7039b5a094f1c9b7f4f5210cec6febb2d48a793) refactor: Replaced deprecated Gtk::StockID in Filename widget ([#2682](https://github.com/synfig/synfig/issues/2682)) [studio]
- [`c13d945`](https://github.com/synfig/synfig/commit/c13d9459607b4698b1c41d6a76bc886d4537a6fb) feat: Reproducible build ([#2613](https://github.com/synfig/synfig/issues/2613)) [core] [studio]
- [`aa7b21b`](https://github.com/synfig/synfig/commit/aa7b21b810c56cbd4731f455a836e9dbdfe62817) refactor: Replaced deprecated Gtk::StockID in Parameters panel ([#2670](https://github.com/synfig/synfig/issues/2670)) [studio]
- [`c7417c5`](https://github.com/synfig/synfig/commit/c7417c5bc1ecb211112659eff50d0d87b68f16d3) build(CMake): small refactoring and code cleanup ([#2684](https://github.com/synfig/synfig/issues/2684)) [core] [studio]
- [`8066c7d`](https://github.com/synfig/synfig/commit/8066c7d0affc94c6e1a2ce3fbfa996f2482e9768) refactor: Replaced deprecated Gtk::StockID in Jack widget ([#2664](https://github.com/synfig/synfig/issues/2664)) [studio]
- [`c5b37aa`](https://github.com/synfig/synfig/commit/c5b37aa5f5f5e5f1964ae8ddcbd790370ad6ea8e) build: Added Jack audio support to CMake ([#2681](https://github.com/synfig/synfig/issues/2681)) [studio]
- [`b53134d`](https://github.com/synfig/synfig/commit/b53134d6bfd3f8e8917337e6e95b03fdc11b9b61) refactor: Replaced deprecated Gtk::StockID in Layers panel ([#2669](https://github.com/synfig/synfig/issues/2669)) [studio]
- [`de23e01`](https://github.com/synfig/synfig/commit/de23e01a471674071062035de211af826ba83318) Fixed build warnings (GCC 9.4.0) ([#2671](https://github.com/synfig/synfig/issues/2671)) [studio]
- [`1db0bff`](https://github.com/synfig/synfig/commit/1db0bff5c89424eac20c0b8cd2c4cf2378d3f859) chore: missing files in POTFILES.in for synfig-studio ([#2675](https://github.com/synfig/synfig/issues/2675)) [studio]
- [`590ed73`](https://github.com/synfig/synfig/commit/590ed739ce27ee87d8e6408b952e04ce50dc0b87) refactor(core): Cleaned up registration function ([#2622](https://github.com/synfig/synfig/issues/2622)) [core]
- [`eab541c`](https://github.com/synfig/synfig/commit/eab541c5b9e153cc543a5be20689f608a7a387b9) build: Use CMake's PkgConfig imported targets ([#2676](https://github.com/synfig/synfig/issues/2676)) [ETL] [core] [studio]
- [`a18ac7b`](https://github.com/synfig/synfig/commit/a18ac7be69c99923536ccc2e5761903de2a72ab2) fix(bone-tool): new bone position when active bone is invalid ([#2673](https://github.com/synfig/synfig/issues/2673)) [studio]
- [`3db1b82`](https://github.com/synfig/synfig/commit/3db1b821ba146c8a9b61bcb715c851a85897353e) fix: No context menu shown for Transformation parameter of Group Layer ([#2674](https://github.com/synfig/synfig/issues/2674)) [studio]
- [`17b8f43`](https://github.com/synfig/synfig/commit/17b8f43ab44d80b2d84ee9741b0b3b591f94c31d) Merge PR [#2465](https://github.com/synfig/synfig/issues/2465): Refactoring and bugfix for ValueDescBoneSetParent [core] [studio]
- [`3bf0203`](https://github.com/synfig/synfig/commit/3bf0203ba1fc3f093945820d6512130263c79cb3) Replaced deprecated Gtk::StockID in Preview window ([#2663](https://github.com/synfig/synfig/issues/2663)) [studio]
- [`e7b7757`](https://github.com/synfig/synfig/commit/e7b7757fe86441711045e4c9637cecb2f567fa47) Replaced deprecated Gtk::StockID in Dockables ([#2662](https://github.com/synfig/synfig/issues/2662)) [studio]
- [`f00ba2e`](https://github.com/synfig/synfig/commit/f00ba2e9bcbcb81c0874dfbf173e2b3db0941b87) Refactored KeyFrameDial class ([#2661](https://github.com/synfig/synfig/issues/2661)) [studio]
- [`86a3346`](https://github.com/synfig/synfig/commit/86a334636a1d6f2913addce98bf15674d03e6a1b) Replaced deprecated Gtk::StockId in DuckDial icons ([#2656](https://github.com/synfig/synfig/issues/2656)) [studio]
- [`af4e43b`](https://github.com/synfig/synfig/commit/af4e43b554b5e771e7a543637427b40d214e82ee) Replaced deprecated Gtk::StockId in FrameDial icons ([#2655](https://github.com/synfig/synfig/issues/2655)) [studio]
- [`592424e`](https://github.com/synfig/synfig/commit/592424eeb83206dc2ec2f64c0d559f7053e5e35f) Replaced deprecated Gdk::Color with Gdk:RGBA ([#2654](https://github.com/synfig/synfig/issues/2654)) [studio]
- [`7860f93`](https://github.com/synfig/synfig/commit/7860f93effebc3640789b640a0689d3254978449) Added a mnemonic for the text layer input dialog ([#2582](https://github.com/synfig/synfig/issues/2582)) [studio]
- [`9345566`](https://github.com/synfig/synfig/commit/93455660e70bdcf938b0c3f7e40d340f619e7b7c) Refactored python search algorithm ([#2658](https://github.com/synfig/synfig/issues/2658)) [studio]
- [`e7ee1ca`](https://github.com/synfig/synfig/commit/e7ee1ca4be9bd252fccbdaec67c66add84c7b3f5) Fixed incorrect lines offset in Graphs Panel ([#2653](https://github.com/synfig/synfig/issues/2653)) [studio]
- [`9765397`](https://github.com/synfig/synfig/commit/9765397cc9714bc8a108678721069000d80fb744) fix behavior after Tool process a key event: only proceeds when RESULT_OK ([#2509](https://github.com/synfig/synfig/issues/2509)) [studio]
- [`789db47`](https://github.com/synfig/synfig/commit/789db47e71dce200982ba52bb662dab8ba4a784e) Fixed issue with python search on Ubuntu 18 ([#2657](https://github.com/synfig/synfig/issues/2657)) [studio]
- [`3740966`](https://github.com/synfig/synfig/commit/3740966de2709348ad5c0793453e09b0d6ea2a69) Fixed an issue with plugins not working when there are spaces in the Python path (Windows) ([#2651](https://github.com/synfig/synfig/issues/2651)) [studio]
- [`d2cad43`](https://github.com/synfig/synfig/commit/d2cad432cdcf60de20e123b8965413d32bab1665) [Studio] Hide "Make Parent To Active Bone" menu item when not using Skeleton Tool ([#2064](https://github.com/synfig/synfig/issues/2064)) [studio]
- [`8b2950e`](https://github.com/synfig/synfig/commit/8b2950e88fec2d50e1fcad0af188e07643e5f6af) Fix ValueNode local name not being translated ([#2569](https://github.com/synfig/synfig/issues/2569)) [core] [studio]
- [`32a4153`](https://github.com/synfig/synfig/commit/32a4153e567cce245dbb41add47ead8838b0db28) Merge PR [#2398](https://github.com/synfig/synfig/issues/2398): Make Node::parent_set private [core] [studio]
- [`ba0352c`](https://github.com/synfig/synfig/commit/ba0352c215db8470cd7da4c9b01c347aec965bc8) Returned the ability to set a GTK theme using an environment variable ([#2645](https://github.com/synfig/synfig/issues/2645)) [studio]
- [`b14ade5`](https://github.com/synfig/synfig/commit/b14ade5f1c3c82035e7621a4d6766fb427108539) Fixed empty "Icon Theme" dropdown in Preferences ([#2642](https://github.com/synfig/synfig/issues/2642)) [studio]
- [`7c2183e`](https://github.com/synfig/synfig/commit/7c2183ed978266d64119b488ec5ff6664a6fb08a) Fixed missing icons in tool options ([#2640](https://github.com/synfig/synfig/issues/2640)) [studio]
- [`0b455f3`](https://github.com/synfig/synfig/commit/0b455f370fc7fcf3d640eecd4c988729af0d25d8) Added .glade/xml files for gtk::builder ([#2638](https://github.com/synfig/synfig/issues/2638)) [studio]
- [`865f197`](https://github.com/synfig/synfig/commit/865f1977d0a3e4129a1031cc39d7ea7514bc7158) Merge PR [#2632](https://github.com/synfig/synfig/issues/2632): Added basic support for Gtk theme [studio]
- [`9b5140f`](https://github.com/synfig/synfig/commit/9b5140ffb49b6ec64a4c729e8862b9c87cb791e0) Fix typo in source ([#2631](https://github.com/synfig/synfig/issues/2631)) [core]
- [`78f08a4`](https://github.com/synfig/synfig/commit/78f08a426835a98dcc40c4cc458218b05710b939) [CMake] Added option to link with tcmalloc library ([#2602](https://github.com/synfig/synfig/issues/2602)) [core] [studio]
- [`08202f4`](https://github.com/synfig/synfig/commit/08202f400bffb75031b907c7eab02f517ad99fef) Removed old .cvsignore files ([#2616](https://github.com/synfig/synfig/issues/2616))
- [`ead44ed`](https://github.com/morevnaproject/morevna-builds/commit/ead44ed5a5e8ac6fb20815b3cc37a452c0953acf) Fix issue [#2410](https://github.com/synfig/synfig/issues/2410) - Can't import file into a saved SIF animation (if both are on the same disk) [studio]
- [`05f5108`](https://github.com/synfig/synfig/commit/05f51084218d75c4317a7c9533dcc0a756b052b7) Fix various typos ([#2614](https://github.com/synfig/synfig/issues/2614)) [core] [studio]
- [`368a50f`](https://github.com/synfig/synfig/commit/368a50f9f322bf0083067af9b4aaf113816b063b) Fix crash when switching workspaces ([#2591](https://github.com/synfig/synfig/issues/2591)) [studio]
- [`e54c25d`](https://github.com/synfig/synfig/commit/e54c25dc051f6ad38f8ec2ed8ca95371be4a3cd4) Update contributor name list ([#2600](https://github.com/synfig/synfig/issues/2600)) [studio]
- [`473af1c`](https://github.com/synfig/synfig/commit/473af1c1b1a3b990812825c7e01ea46ec3728fd9) improve output readability of unit tests with test_base.h ([#2583](https://github.com/synfig/synfig/issues/2583)) [core]
- [`c42885f`](https://github.com/synfig/synfig/commit/c42885f91faebc63fa1a8b5149dcc3da7f6ff067) Added the ability to set the build type from the command line to the 2-build-msys-cmake.sh script ([#2573](https://github.com/synfig/synfig/issues/2573))
- [`113dc73`](https://github.com/synfig/synfig/commit/113dc73784273e7a358c6c41004920dad51483c9) Allow to call regression test script outside of Travis ([#2585](https://github.com/synfig/synfig/issues/2585))
- [`f64f99f`](https://github.com/synfig/synfig/commit/f64f99f020f0689fb006969a7c649c101c52d066) Added hotkey for grouping layers (Ctrl+G). Grid toggle hotkey changed to #. ([#2581](https://github.com/synfig/synfig/issues/2581)) [studio]
- [`8459f46`](https://github.com/synfig/synfig/commit/8459f46b6def28d14373d4550448b384fb5e669c) Fixed MSYS2 dependencies ([#2575](https://github.com/synfig/synfig/issues/2575))
- [`0dbad45`](https://github.com/synfig/synfig/commit/0dbad4502e861f4433afd989f338224966692d0f) Added the ability to select the parent layer through the keyboard shortcut Alt+Page Up.  ([#2567](https://github.com/synfig/synfig/issues/2567)) [studio]
- [`a113b35`](https://github.com/synfig/synfig/commit/a113b35235bd35b6ae1aa8999f9fe9d6d0136c8e) Layer SuperSample: remove unused parameters and minor cleanup ([#2580](https://github.com/synfig/synfig/issues/2580)) [core]
- [`4fd97a8`](https://github.com/synfig/synfig/commit/4fd97a849ef6fc2941c04b10471138acb4b0becd) simplify Widget_Sublayer by using Gtk::ComboBoxText ([#2578](https://github.com/synfig/synfig/issues/2578)) [studio]
- [`0bcb812`](https://github.com/synfig/synfig/commit/0bcb812027ca334fdcc38b6627c4ac1a47a0feec) Merge PR [#2568](https://github.com/synfig/synfig/issues/2568): add new ValueNode "Modulo" for modulo operation [core]
- [`1d1a2eb`](https://github.com/synfig/synfig/commit/1d1a2ebef9ceec4c67b0d98012445f827dee4d90) fix RendDesc::get_pixels_to_world_matrix() contents ([#2574](https://github.com/synfig/synfig/issues/2574)) [core]
- [`1f702df`](https://github.com/synfig/synfig/commit/1f702dfdcf9deb71eff5691e922dbb8803037b33) [MSYS2] Removed patch for libintl ([#2576](https://github.com/synfig/synfig/issues/2576))
- [`ef30ad6`](https://github.com/synfig/synfig/commit/ef30ad6f2bd2b12f1200bfa753dd6ad3345e807c) [MSYS2] Updated packages list ([#2566](https://github.com/synfig/synfig/issues/2566))
- [`17a48a4`](https://github.com/synfig/synfig/commit/17a48a42d5263012c7019749dc40ccf72d9050b5) FFmpeg targets: allow to render alpha channel for webm and hap videos ([#2563](https://github.com/synfig/synfig/issues/2563)) [core]
- [`e5afcb5`](https://github.com/synfig/synfig/commit/e5afcb56c565eefd32838998a2247fe91e1c2a5b) eliminate the need to set_time() on the search for bones ([#2504](https://github.com/synfig/synfig/issues/2504)) [studio]
- [`dbbdd87`](https://github.com/synfig/synfig/commit/dbbdd87373d629c7370bebb5f5959c00cba57c28) WIP - basic support for importing .kra (Krita) and .ora (OpenRaster) ([#2513](https://github.com/synfig/synfig/issues/2513)) [core] [studio]
- [`1344831`](https://github.com/synfig/synfig/commit/1344831a0043b67ddc4e13051b67a43b60991dcd) Fixed PVS-Studio warning v730 ([#2522](https://github.com/synfig/synfig/issues/2522)) [ETL] [core] [studio]
- [`b618efd`](https://github.com/synfig/synfig/commit/b618efd13447c12e6a1700029a2933b5cecad5c3) Simplify "Render Mode ComboBox Changed" callback & add GL if available ([#2552](https://github.com/synfig/synfig/issues/2552)) [studio]
- [`630b036`](https://github.com/synfig/synfig/commit/630b0362b94d6ecb296106950ad43df2fb75f02e) add documentation to some synfig::rendering stuff ([#2549](https://github.com/synfig/synfig/issues/2549)) [core]
- [`b23b68f`](https://github.com/synfig/synfig/commit/b23b68fd58ac7a4e07373cb4f86c6f50b873406e) make some cleanup on headers of synfig-core ([#2561](https://github.com/synfig/synfig/issues/2561)) [core]
- [`640506a`](https://github.com/synfig/synfig/commit/640506a003d719c80b6bdc4197aeeda7d04b7e11) add more synfig::Node tests ([#2559](https://github.com/synfig/synfig/issues/2559)) [core]
- [`be5c9f4`](https://github.com/synfig/synfig/commit/be5c9f4114163d5fba1a4f8ec60736eb26297517) Ensure computed GUID is not zero ([#2560](https://github.com/synfig/synfig/issues/2560)) [core]
- [`e430652`](https://github.com/synfig/synfig/commit/e430652f0d46c8507a7fbdce3e4a343ca4533420) Merge PR [#2535](https://github.com/synfig/synfig/issues/2535): Fix Bone Shape of Skeleton Deformation affected by Transformations [studio]
- [`ba24736`](https://github.com/synfig/synfig/commit/ba2473605d12bd0da326355c56202eeb95888fda) bump LumaKey layer version: it now have less parameters ([#2554](https://github.com/synfig/synfig/issues/2554)) [core]
- [`2a3d339`](https://github.com/synfig/synfig/commit/2a3d3398b58421132a109345309e1becae94dfdc) Add "destructive-action" and "suggested-action" to dialog when trying to quit before saving changes ([#2498](https://github.com/synfig/synfig/issues/2498)) [studio]
- [`7f9a987`](https://github.com/synfig/synfig/commit/7f9a98770f9d64af41cc17af61c1c3fb161cf9ad) add "check" action to build.sh in order to run tests ([#2557](https://github.com/synfig/synfig/issues/2557))
- [`cd97b9f`](https://github.com/synfig/synfig/commit/cd97b9fe87b60e6609b128e2e3469c9e7a62db49) add missing Widget_Interpolation files in POTFILES.in ([#2556](https://github.com/synfig/synfig/issues/2556)) [studio]
- [`364fa14`](https://github.com/synfig/synfig/commit/364fa14ba28a86596756a2ac624f3f96171cc57d) create synfig::Node unit tests ([#2558](https://github.com/synfig/synfig/issues/2558)) [core]
- [`7920d18`](https://github.com/synfig/synfig/commit/7920d184f86b1220e8280b69ac437f46d0244a40) Merge PR [#2551](https://github.com/synfig/synfig/issues/2551): Port Luma Key to Cobra renderer engine [core]
- [`1e2fc13`](https://github.com/synfig/synfig/commit/1e2fc134eed71ac9db622cf2c9c1778d5449d032) BlinePoint Origin is not coordinates, but a relative position (0.0-1.0) ([#2548](https://github.com/synfig/synfig/issues/2548)) [core]
- [`7f6b24e`](https://github.com/synfig/synfig/commit/7f6b24e7b396013f4c85b4e6115d14915f44bfec) Fixed ETL CMake tests ([#2545](https://github.com/synfig/synfig/issues/2545)) [ETL]
- [`12a342b`](https://github.com/synfig/synfig/commit/12a342bc2edafb9f76a329a871218a68f6adf817) Added ability to set custom FFmpeg codec ([#2541](https://github.com/synfig/synfig/issues/2541)) [studio]
- [`027338a`](https://github.com/synfig/synfig/commit/027338a1fa258d96bf39b0a43a945f1b0a4aa6e9) Added description to FFmpeg units for "Video Bit Rate" field (kbps) ([#2542](https://github.com/synfig/synfig/issues/2542)) [studio]
- [`4af3ca7`](https://github.com/synfig/synfig/commit/4af3ca76fe3c544d4cad12e0483961539b5fe98b) Create Widget_Interpolation: avoid code duplication and ease maintenance ([#2543](https://github.com/synfig/synfig/issues/2543)) [studio]
- [`d870ad1`](https://github.com/synfig/synfig/commit/d870ad1069940a5f6389637c76c3990c679a175b) Removed unused "using namespace etl;" (Part 2) ([#2537](https://github.com/synfig/synfig/issues/2537)) [core] [studio]
- [`e054801`](https://github.com/synfig/synfig/commit/e0548010697637acc2c5a187434a937b262f94d2) remove not-implemented and unused method ([#2533](https://github.com/synfig/synfig/issues/2533)) [studio]
- [`0c47007`](https://github.com/synfig/synfig/commit/0c470076473be12a5ea00c12858fbe3284ce945c) Merge PR [#2534](https://github.com/synfig/synfig/issues/2534): Minor icon cleanup [studio]
- [`c7a9167`](https://github.com/synfig/synfig/commit/c7a91678022226e1e645f4b61a586fdd4d1e1b04) Use gtkmm Gtk::Settings instead of plain GtkSettings ([#2532](https://github.com/synfig/synfig/issues/2532)) [studio]
- [`462ea80`](https://github.com/synfig/synfig/commit/462ea802524e9e13bfa2aefdd213a7fc03c5adcb) Merge PR [#2518](https://github.com/synfig/synfig/issues/2518):  Added the ability to select a compression method for zstreambuf [core] [studio]
- [`9b80219`](https://github.com/synfig/synfig/commit/9b8021936d2e00d5823055fe21037d30a79e9edc) Removed unused `using namespace etl;` ([#2530](https://github.com/synfig/synfig/issues/2530)) [ETL] [core]
- [`7408ab5`](https://github.com/synfig/synfig/commit/7408ab5158ffbce5f17fa198d6bca7d8dba1fbef) Update Installation section ([#2531](https://github.com/synfig/synfig/issues/2531))
- [`a5ec91d`](https://github.com/synfig/synfig/commit/a5ec91db5b751dc12e4400ccfb5c063fd6d2d928) Removed "using namespace std;" ([#2520](https://github.com/synfig/synfig/issues/2520)) [ETL] [core] [studio]
- [`668e8c4`](https://github.com/synfig/synfig/commit/668e8c410f9bedd7f4faa7abba61da16163ed305) Fixed PVS-Studio warning v656 ([#2524](https://github.com/synfig/synfig/issues/2524)) [core] [studio]
- [`f71cdee`](https://github.com/synfig/synfig/commit/f71cdee789baa73e1e8978bcb53dd060b96494a3) Bone Tool: Fix selection of active bone when clicking on a bone control point ([#2488](https://github.com/synfig/synfig/issues/2488)) [studio]
- [`62743b7`](https://github.com/synfig/synfig/commit/62743b7de5647ed3a6939493af764fd565383dd8) Show bone shape when Skeleton Deformation layer is disabled ([#2467](https://github.com/synfig/synfig/issues/2467)). Closes [#1625](https://github.com/synfig/synfig/issues/1625). [studio]
- [`efe9326`](https://github.com/synfig/synfig/commit/efe9326992418f9fbc1c9a654fa0050c35c2641e) Fixed PVS-Studio warning v817 ([#2523](https://github.com/synfig/synfig/issues/2523)) [core] [studio]
- [`61eba07`](https://github.com/synfig/synfig/commit/61eba079c983db043f787d3c318bac3b60796673) Merge PR [#2497](https://github.com/synfig/synfig/issues/2497): Porting to Gtk::Application - part 1 [core] [studio]
- [`ad03efe`](https://github.com/synfig/synfig/commit/ad03efe3b70e507a4632fe14a55acd149be60477) FileSystem::Identifier::empty() returned wrong value ([#2510](https://github.com/synfig/synfig/issues/2510)) [core]
- [`78081fd`](https://github.com/synfig/synfig/commit/78081fd256b6a4a095f7240dd9875e6f82028415) make "Background" (layer description) string translatable ([#2515](https://github.com/synfig/synfig/issues/2515)) [studio]
- [`cb9abcf`](https://github.com/synfig/synfig/commit/cb9abcf7ddd8f9a51dde5c5ede47a25486fbacda) fix error message on Target_Scanline ([#2511](https://github.com/synfig/synfig/issues/2511)) [core]
- [`14b3ce6`](https://github.com/synfig/synfig/commit/14b3ce6b5c25a164534f53df0bd71f9f080f293d) Merge PR [#2514](https://github.com/synfig/synfig/issues/2514): Fix text layer hit check for Text Layer (issue when size was too small). Closes [#2508](https://github.com/synfig/synfig/issues/2508). [core]
- [`7ae9d4a`](https://github.com/synfig/synfig/commit/7ae9d4a900ee8cadcf44606f9b050c96cde4bdb7) Re-enable "Create Child Bone" action ([#2507](https://github.com/synfig/synfig/issues/2507)) [studio]
- [`d581517`](https://github.com/synfig/synfig/commit/d581517237410a685ac24dd86ee35a019294d7f5) Remove unused variables ([#2502](https://github.com/synfig/synfig/issues/2502)) [studio]
- [`e3ba578`](https://github.com/synfig/synfig/commit/e3ba5788d727b3497c0441d71799727af2412bab) Bone Tool: Fixed issue where skeleton "name" wasn't updated as new Layers are created ([#2493](https://github.com/synfig/synfig/issues/2493)) [studio]
- [`7019f19`](https://github.com/synfig/synfig/commit/7019f19d7bb12a98b94f3821ed6260a65e751f7e) Merge PR [#2499](https://github.com/synfig/synfig/issues/2499): Fix hit check for Layer_Freetype [core]
- [`20b7035`](https://github.com/synfig/synfig/commit/20b7035fbad2212f5aa3e76447a87a2b612cd0c1) make UIInterface::confirmation() implementation consistent to signature ([#2487](https://github.com/synfig/synfig/issues/2487)) [studio]
- [`4c64fe5`](https://github.com/synfig/synfig/commit/4c64fe5ab1b45a9683a78b78718ac77e2de4a335) avoid decimal point in Distance strings due to i18n issues ([#2489](https://github.com/synfig/synfig/issues/2489)) [studio]
- [`ad4c714`](https://github.com/synfig/synfig/commit/ad4c71486d24cb7abe5c8bb757266eb7e6b64b48) Removed unused alert message about experimental features ([#2490](https://github.com/synfig/synfig/issues/2490)) [studio]
- [`da6cb0f`](https://github.com/synfig/synfig/commit/da6cb0fa8d6d345e241946a4b985592957045e9d) Updated GitHub actions/cache version ([#2492](https://github.com/synfig/synfig/issues/2492))
- [`237e968`](https://github.com/synfig/synfig/commit/237e96811fd829e2b7f8e3dd798248389d595470) Minor cleanup on TypePair<Bone,Bone> usage ([#2486](https://github.com/synfig/synfig/issues/2486)) [studio]
- [`97abc46`](https://github.com/synfig/synfig/commit/97abc463015fe57c7b14691d3bb60ab95f2d68ab) Bone Tool: fix regression on Bone width auto change requested in [#1658](https://github.com/synfig/synfig/issues/1658) ([#2483](https://github.com/synfig/synfig/issues/2483)) [studio]
- [`db4f941`](https://github.com/synfig/synfig/commit/db4f9418d248b074a070d4257818371049f22b24) Bone Tool:remove deprecated method set_alignment that use default values ([#2484](https://github.com/synfig/synfig/issues/2484)) [studio]
- [`34e1eba`](https://github.com/synfig/synfig/commit/34e1eba0e95f802bdb1b8c3dc80af19d6a2502bf) fix regression on loading and saving of settings Distance type (i18n) ([#2485](https://github.com/synfig/synfig/issues/2485)) [studio]
- [`52a105a`](https://github.com/synfig/synfig/commit/52a105a3bc57ba87c42291f09eacf61b146b27d6) Merge PR [#2480](https://github.com/synfig/synfig/issues/2480): Fix rendering of some glyphs [core]
- [`5cad551`](https://github.com/synfig/synfig/commit/5cad5518bc69c3e217f2483706beff8cdeda3974) Layer_Sound is Layer_Invisible, not Layer_Composite ([#2478](https://github.com/synfig/synfig/issues/2478)) [core]
- [`b5b39f9`](https://github.com/synfig/synfig/commit/b5b39f9711e82a877f44e7eb07d3f482bc2cba32) Update Github Issue Templates ([#2476](https://github.com/synfig/synfig/issues/2476))
- [`3960ef2`](https://github.com/synfig/synfig/commit/3960ef2ad39dd65db11bf1895c784a8276979cd8) Svg_parser: fix not creating last vertex of cubic path segment ([#2473](https://github.com/synfig/synfig/issues/2473)) [core]
- [`a8278a3`](https://github.com/synfig/synfig/commit/a8278a3f82fbab3b823ec08f524552b14afdb4f3) Fixed bug introduced in [#2458](https://github.com/synfig/synfig/issues/2458): it should not return at that point ([#2470](https://github.com/synfig/synfig/issues/2470)) [studio]
- [`d5b4443`](https://github.com/synfig/synfig/commit/d5b44434512f02fb198017aab3b8d8cd41cb31fe) Added ability for escape key to close  editing box in Value column in the Parameters panel ([#2455](https://github.com/synfig/synfig/issues/2455)) [studio]
- [`bddb813`](https://github.com/synfig/synfig/commit/bddb8134e9d890ebbf7c549bfc1b3791a1a1d0d4) Merge PR [#2466](https://github.com/synfig/synfig/issues/2466): Fix bone width handle visibility. Closes [#2088](https://github.com/synfig/synfig/issues/2088). [studio]
- [`310aaad`](https://github.com/synfig/synfig/commit/310aaad378224b6db22cc0639e66e36dfc45368c) ValueDescSet for Skeleton Deformation bone: Minor refactoring and add return ([#2458](https://github.com/synfig/synfig/issues/2458)) [studio]
- [`0bff94e`](https://github.com/synfig/synfig/commit/0bff94eac5844b2784b7b0a60a15c79fb8ef95ef) [MacOS M1] Fixed autotools build ([#2424](https://github.com/synfig/synfig/issues/2424))
- [`f1938c9`](https://github.com/synfig/synfig/commit/f1938c9cfc0ac60a529dcf04d38480891336b93f) Refactored SynfigToolGeneralOptions singleton ([#2453](https://github.com/synfig/synfig/issues/2453)) [core]
- [`1d97e5a`](https://github.com/synfig/synfig/commit/1d97e5abb19260ac4175898e29768a2b466cf41e) Fixed Travis-CI broken link ([#2461](https://github.com/synfig/synfig/issues/2461))
- [`15e75dc`](https://github.com/synfig/synfig/commit/15e75dc3000ee1db7c4bf3bcb37ef6bef5394b69) Fixed appdata.xml check CI ([#2464](https://github.com/synfig/synfig/issues/2464))
- [`98b2bab`](https://github.com/synfig/synfig/commit/98b2babfd41319c0d06380251408e6a67c716830) Bone Tool: Correctly apply offset to Second bone when First bone of Skeleton Deformation Layer changed ([#2457](https://github.com/synfig/synfig/issues/2457)) [studio]
- [`ec35bd8`](https://github.com/synfig/synfig/commit/ec35bd850a913b0c6e99660850cc4a771decd99a) Fixed warning on MODULE_INVENTORY_BEGIN: misleading indentation ([#2430](https://github.com/synfig/synfig/issues/2430)) [core]
- [`c5fbb27`](https://github.com/synfig/synfig/commit/c5fbb27b3e817a1fb0e846e1dd98d9bdf7a6bb17) [Studio] Bone Tool: fix how to check for skeleton deformation ([#2217](https://github.com/synfig/synfig/issues/2217)) [studio]
- [`bea6969`](https://github.com/synfig/synfig/commit/bea6969f273a6bd2716a6c36c2dafde46a94df1a) Fixed potential null pointer dereferencing ([#2454](https://github.com/synfig/synfig/issues/2454)) [studio]
- [`d37e72a`](https://github.com/synfig/synfig/commit/d37e72ac3dcb42bbf64deb0ae6b9d1c90649f229) Refactored import file: added is_same_file method ([#2451](https://github.com/synfig/synfig/issues/2451)) [studio]
- [`55d09c2`](https://github.com/synfig/synfig/commit/55d09c27f3dd81bdf79c9d43303f5412280938f9) Added ability to import multiple files ([#2439](https://github.com/synfig/synfig/issues/2439)) [studio]
- [`32808d9`](https://github.com/synfig/synfig/commit/32808d9f80505505958aea012cae4d771bde48a1) Merge PR [#2449](https://github.com/synfig/synfig/issues/2449): Fix MSYS2 build
- [`943ca1e`](https://github.com/synfig/synfig/commit/943ca1e9aa835935111ff53acaef703de5591158) Autotools: detects libpng via pkg-config ([#2443](https://github.com/synfig/synfig/issues/2443)) [core]
- [`ed40cc0`](https://github.com/synfig/synfig/commit/ed40cc08f0bc9b1e421d7285ec784351dbcc0569) Autotools: remove code for very old libtool versions ([#2444](https://github.com/synfig/synfig/issues/2444)) [core]
- [`4bfeae6`](https://github.com/synfig/synfig/commit/4bfeae6b4a2d1d16b4fd441457b09c6883d668f0) [CMake] Improved libmng search ([#2441](https://github.com/synfig/synfig/issues/2441)) [core]
- [`0015d71`](https://github.com/synfig/synfig/commit/0015d71a723c7a0f3314cdfeee5d33f56a79c2a6) Wider time track space at start and end. Closes [#2417](https://github.com/synfig/synfig/issues/2417). ([#2438](https://github.com/synfig/synfig/issues/2438)) [studio]
- [`d312076`](https://github.com/synfig/synfig/commit/d3120764b4f8715b17d485353fededd5aac471be) Fixed build warnings ([#2425](https://github.com/synfig/synfig/issues/2425)) [core] [studio]
- [`de82c5d`](https://github.com/synfig/synfig/commit/de82c5da235860481cd05ccfb643651df41d7157) [CMake] Improved search for libraries ([#2428](https://github.com/synfig/synfig/issues/2428)) [core]
- [`2ce7109`](https://github.com/synfig/synfig/commit/2ce7109e2f8a2973c8c85255d74516b052004bee) Fix distance values on settings ([#2402](https://github.com/synfig/synfig/issues/2402)) [studio]
- [`ea4777d`](https://github.com/synfig/synfig/commit/ea4777dbe5ee4cbc03ec6323f0c0c357f5caf9de) Svg_parser: primitive rect properly uses style ([#2429](https://github.com/synfig/synfig/issues/2429)) [core]
- [`957bc26`](https://github.com/synfig/synfig/commit/957bc26fb5c3815d0475d0ed410d95d7746ff3d1) fix compilation warning for unused parameters on valuenode methods ([#2432](https://github.com/synfig/synfig/issues/2432)) [core]
- [`6e3a450`](https://github.com/synfig/synfig/commit/6e3a4502338b8c32b554d8b42b61a199c70ad113) Svg_parser: fix warning: unused parameters ([#2431](https://github.com/synfig/synfig/issues/2431)) [core]
- [`9b6004e`](https://github.com/synfig/synfig/commit/9b6004eb4f9d829c8f606d5657ee893f2b029444) Move variable closer to its use and rename it to avoid confusion ([#2421](https://github.com/synfig/synfig/issues/2421)) [studio]
- [`5a40a64`](https://github.com/synfig/synfig/commit/5a40a6436024b87c19a9ee551c5aae77ad83b94b) Don't let user drag a waypoint to a time lower than current minimum ([#2420](https://github.com/synfig/synfig/issues/2420)) [studio]
- [`e795752`](https://github.com/synfig/synfig/commit/e7957520c2622cbca0acc5c82210eae1a9a0244d) Add completion to Widget_FontFamily ([#2414](https://github.com/synfig/synfig/issues/2414)) [studio]
- [`61d95f9`](https://github.com/synfig/synfig/commit/61d95f97b3439268beef6def86dc9af5984ba19a) Fix dragging area of a waypoint in CellRenderer_Timetrack ([#2419](https://github.com/synfig/synfig/issues/2419)) [studio]
- [`d83dfab`](https://github.com/synfig/synfig/commit/d83dfab3bd9ec11d5919cdc99300650a9e2d1f1a) Linux build: Autodetect number of threads ([#2416](https://github.com/synfig/synfig/issues/2416))
- [`2443e86`](https://github.com/synfig/synfig/commit/2443e8641c3d09001190af5275f8f378c29494db) Merge PR ([#2299](https://github.com/synfig/synfig/issues/2299)): [Core] fix access modifiers for valuenode classes [core]
- [`398c745`](https://github.com/synfig/synfig/commit/398c7450fab72700cba7b460f7bb8704cb29da6d) Svg_parser: remove unused properties & method, restrict var scope ([#2418](https://github.com/synfig/synfig/issues/2418)) [core]
- [`177d4aa`](https://github.com/synfig/synfig/commit/177d4aa38bdb9a96811ef1932fec3157d993b13a) Clear Redo History on new action by default; new user preference ([#2395](https://github.com/synfig/synfig/issues/2395)) [studio]
- [`055e0f9`](https://github.com/synfig/synfig/commit/055e0f940dd8b8e22fac1a89e3c8351076e2f10d) Studio: avoid lambda functions for signal callbacks ([#2294](https://github.com/synfig/synfig/issues/2294)) [studio]
- [`cbc06c9`](https://github.com/synfig/synfig/commit/cbc06c90c135bdaadd2e48794d855e5ab4bd150c) Merge PR ([#2296](https://github.com/synfig/synfig/issues/2296)): Moved layer and valuenode iteration methods to synfig-core [core] [studio]
- [`26e22df`](https://github.com/synfig/synfig/commit/26e22dfc7139516496b9e3a3f2ff4dc964b25c7d) Svg_parser: support more outline/stroke styles ([#2407](https://github.com/synfig/synfig/issues/2407)) [core]
- [`33ff874`](https://github.com/synfig/synfig/commit/33ff874b331af3075ef03c65dc558c98374d4417) Svg_parser: rename method to follow its meaning: isFirst -> isEqualTo() ([#2409](https://github.com/synfig/synfig/issues/2409)) [core]
- [`e2e1cb2`](https://github.com/synfig/synfig/commit/e2e1cb213a43312364150f1ace72b704a8c6cdd1) Tab/Shift-Tab support for Widget_Vector ([#2404](https://github.com/synfig/synfig/issues/2404)) [studio]
- [`c75975e`](https://github.com/synfig/synfig/commit/c75975ef35fd28f2761fddab9f7287439900de92) Merge PR ([#2216](https://github.com/synfig/synfig/issues/2216)): SVG importer: fix outlined rectangle and implement missing shapes [core]
- [`21ff720`](https://github.com/synfig/synfig/commit/21ff720f48d815e0af511447bd56c1cfaf45ee94) Svg_parser: better method name: initializeGroupLayerNode() ([#2408](https://github.com/synfig/synfig/issues/2408)) [core]
- [`641f9da`](https://github.com/synfig/synfig/commit/641f9da82450bc54c8f58b109c364cd4c7796df0) Svg_parser: fix default fill color: black instead of none ([#2405](https://github.com/synfig/synfig/issues/2405)) [core]
- [`a335c25`](https://github.com/synfig/synfig/commit/a335c2510e9f3d7e917f069468bcb9d1dca538ee) Merge PR ([#2406](https://github.com/synfig/synfig/issues/2406)): SVG: fix transform parsing [core]
- [`811a95a`](https://github.com/synfig/synfig/commit/811a95a72a59f1b6e4b0df4694bfd05d4d5dc809) Merge PR ([#2401](https://github.com/synfig/synfig/issues/2401)): Svg_parser: cleanups and some outline-related fixes [core]
- [`e4a48c0`](https://github.com/synfig/synfig/commit/e4a48c07dfee329ee2b4b7f0ed52d49a9018649a) Added support for MLT 7 for CMake build system ([#2386](https://github.com/synfig/synfig/issues/2386)) [core] [studio]
- [`5582c6f`](https://github.com/synfig/synfig/commit/5582c6faaee43e9b4b97856b9599bec1a0b3d5c8) Merge PR ([#2394](https://github.com/synfig/synfig/issues/2394)): SVG: Ellipse arcs work now [core]
- [`aa3c69d`](https://github.com/synfig/synfig/commit/aa3c69d9dd30db8a42f1ae1ae63e764781f37e93) Fix various typos ([#2396](https://github.com/synfig/synfig/issues/2396)) [core] [studio]
- [`6bea935`](https://github.com/synfig/synfig/commit/6bea935646041a54536d896c8ef01e8a29ee0423) Merge PR ([#2372](https://github.com/synfig/synfig/issues/2372)): Fix Orientation parameter display on Text Tool Options Panel [core] [studio]
- [`fd16669`](https://github.com/synfig/synfig/commit/fd166696bc0e7e800f1ab366c0cdac2b8053e1af) Add margins to TimeTrack to ease handling of initial waypoint and keyframe ([#2400](https://github.com/synfig/synfig/issues/2400)) [studio]
- [`78e045f`](https://github.com/synfig/synfig/commit/78e045f940364f2754a09956c7990b5d270db833) CMake/Brew removed cairo/pango requirements ([#2387](https://github.com/synfig/synfig/issues/2387)) [core] [studio]
- [`65850b9`](https://github.com/synfig/synfig/commit/65850b9ffa24dc048e6b3acd9e9dd29230f558bc) CellRenderer_TimeTrack now uses TimePlotData too ([#2384](https://github.com/synfig/synfig/issues/2384)) [studio]
- [`71a3455`](https://github.com/synfig/synfig/commit/71a34552401999d1fa7083b38301e4b40865c08a) fix Gtk warning "'GTK_IS_WIDGET (widget)' failed" ([#2388](https://github.com/synfig/synfig/issues/2388)) [studio]
- [`cf1c176`](https://github.com/synfig/synfig/commit/cf1c1769ea16e51385a1e82cf6c6c3784da68293) Merge PR ([#2327](https://github.com/synfig/synfig/issues/2327)): SVG: fix parser for `<path>` element (except for A commands) [core]
- [`2fe4a82`](https://github.com/synfig/synfig/commit/2fe4a8267bfa29bee1ea2be5a6b1a84305cb0a6e) Layer_Freetype: Added check if HOME environment is set on MacOS ([#2295](https://github.com/synfig/synfig/issues/2295)) [core]
- [`333182e`](https://github.com/synfig/synfig/commit/333182e6d904251d6788da9f9c92b1f5eb79bec4) Merge PR ([#1793](https://github.com/synfig/synfig/issues/1793)): 'Update' file headers: license notices, \file and other minor changes [ETL] [core] [studio]
- [`f6b3f24`](https://github.com/synfig/synfig/commit/f6b3f24e9048a0eb1fd8b0061d8cf612a2b6d767) Merge PR ([#2382](https://github.com/synfig/synfig/issues/2382)): Widget_Keyframe_List: clean up (and make use of TimePlotData) [studio]

## Version 1.5.2 [core] [studio]

- [`80a3386`](https://github.com/synfig/synfig/commit/80a3386c701049f597cf3642bb924d2ff832ae05) build(autotools): patch for autoconf 2.72 h/t Frédéric Bérat ([#2930](https://github.com/synfig/synfig/issues/2930)) [core]
- [`1143a1d`](https://github.com/synfig/synfig/commit/1143a1da0e6c115b9659515ced5feeae9f7f042b) build(autotools): suppress warnings from libxml++ ([#3290](https://github.com/synfig/synfig/issues/3290)) [core]
- [`18b9d2b`](https://github.com/synfig/synfig/commit/18b9d2b58b1cd07e0c7fb6306711766950f5a906) refactor: removed boost dependency ([#2792](https://github.com/synfig/synfig/issues/2792)) [core]
- [`9c2796c`](https://github.com/synfig/synfig/commit/9c2796c2bde9d33dca7ac6524b93e6dc256c96da) Fixed includes for harfbuzz and fribidi libraries ([#2442](https://github.com/synfig/synfig/issues/2442)) [core]
- [`f684b24`](https://github.com/synfig/synfig/commit/f684b24f0db31ab8ea7aadc417fc23e3084b4138) fix(mod_libavcodec): fixed build with FFMPEG 5.0 ([#2734](https://github.com/synfig/synfig/issues/2734)) [core]
- [`0bd2c22`](https://github.com/synfig/synfig/commit/0bd2c224bff04a6c6de15f5821064e46518ad62a) fix: mod_libavcodec didn't compile with MinGW ([#2737](https://github.com/synfig/synfig/issues/2737)) [core]
- [`938cfc0`](https://github.com/synfig/synfig/commit/938cfc08f9453464f0ea78bbb7ccfb2ea0850263) fix Debian 9 building ([#2517](https://github.com/synfig/synfig/issues/2517)) [studio]

## Version 1.5.1 [ETL] [core] [studio]

- [`17b5212`](https://github.com/synfig/synfig/commit/17b52129e04f721e6c26229f15f22fd534c1f3aa) Merge PR ([#2362](https://github.com/synfig/synfig/issues/2362)): Text Layer ported to Cobra render engine [core]
- [`1d38aea`](https://github.com/synfig/synfig/commit/1d38aeaa472c1dd4fbd7867e9834c050b6f27b76) fix rendering of empty rows inside contour when Invert is on ([#2367](https://github.com/synfig/synfig/issues/2367)) [core]
- [`876ed89`](https://github.com/synfig/synfig/commit/876ed89d9c6602d9cf1acc12a9a72bdd060e8884) Merge PR ([#2376](https://github.com/synfig/synfig/issues/2376)): Remove dead/dummy translations [core] [studio]
- [`dd7a1c4`](https://github.com/synfig/synfig/commit/dd7a1c4c2fa38c51935e1daea703605a1bd736e0) TimeTrack: Fix missing context menu for waypoints at Canvas Parameter ([#2363](https://github.com/synfig/synfig/issues/2363)). Closes [#2357](https://github.com/synfig/synfig/issues/2357). [studio]
- [`9a248d3`](https://github.com/synfig/synfig/commit/9a248d3f03f1d29cd45fbed9435292285245f31d) Fix active bone selection for Skeleton Deformation Layer ([#2340](https://github.com/synfig/synfig/issues/2340)) [studio]
- [`188126e`](https://github.com/synfig/synfig/commit/188126edecefe08270959ee60fb2f6777d2b4889) Fix broken bone selection for Skeleton Deformation Layer ([#2365](https://github.com/synfig/synfig/issues/2365)) [studio]
- [`56fc601`](https://github.com/synfig/synfig/commit/56fc601b3ad5e261b2bbe7266d1a017625201718) Refactored open canvas map ([#2360](https://github.com/synfig/synfig/issues/2360)) [core]
- [`09bdfc6`](https://github.com/synfig/synfig/commit/09bdfc6435acd890bb0d2aa1a819695b382ba8ad) Refresh Widget_RendDesc on width/height link toggling ([#2368](https://github.com/synfig/synfig/issues/2368)) [studio]
- [`ef56525`](https://github.com/synfig/synfig/commit/ef565258e3317d35a58b6534526219aad63882bd) Circle Tool: remove deprecated falloff option ([#2366](https://github.com/synfig/synfig/issues/2366)) [studio]
- [`2f91d69`](https://github.com/synfig/synfig/commit/2f91d69bde04939d0f93cca8b0570e73bb1d726e) Fix typos in translation strings ([#2370](https://github.com/synfig/synfig/issues/2370)) [core] [studio]
- [`8384686`](https://github.com/synfig/synfig/commit/8384686e01629bfa0e0d944e79281c75546947c5) more Canvas class cleanup: remove unused field and signal ([#2371](https://github.com/synfig/synfig/issues/2371)) [core]
- [`e0cdef3`](https://github.com/synfig/synfig/commit/e0cdef39ec5e91947a44c59d0679c0c558832a87) Merge PR ([#2364](https://github.com/synfig/synfig/issues/2364)): Refactored Canvas class [core] [studio]
- [`fe640ca`](https://github.com/synfig/synfig/commit/fe640ca8dccdee12613bc28490c348d6bba08502) Removed unused variables ([#2361](https://github.com/synfig/synfig/issues/2361)) [ETL] [core] [studio]
- [`b53d194`](https://github.com/synfig/synfig/commit/b53d1943891c69e6fc8883bb689ec6b5bd2ae0b2) Merge PR [#2358](https://github.com/synfig/synfig/issues/2358): cleanup and fix Intersector class [core]
- [`4f80ad1`](https://github.com/synfig/synfig/commit/4f80ad1f48d63d3c47ad16dd4bc1dd17f913de75) Use Widget_FontFamily in Text Tool toolbox and reorder widgets ([#2355](https://github.com/synfig/synfig/issues/2355)) [studio]
- [`639585c`](https://github.com/synfig/synfig/commit/639585c618353fccd29a1673da1cd91288e96f68) remove unused file synfig/polygon.h ([#2353](https://github.com/synfig/synfig/issues/2353)) [core]
- [`f9db3ee`](https://github.com/synfig/synfig/commit/f9db3eeae3d75f123caf34db0947aeea9899b6c2) fix crash on ValueDescSet action: not every list is a dynamic one ([#2354](https://github.com/synfig/synfig/issues/2354)) [studio]
- [`b613379`](https://github.com/synfig/synfig/commit/b613379476de2f3b0aba60a5554642ae740252b5) remove unneeded #include ([#2342](https://github.com/synfig/synfig/issues/2342)) [core]
- [`014f0bd`](https://github.com/synfig/synfig/commit/014f0bd2e2f9308238a9f6ce216a58098f1818d4) Bone Parent parameter should be static by default ([#2349](https://github.com/synfig/synfig/issues/2349)) [core]
- [`10e7c64`](https://github.com/synfig/synfig/commit/10e7c64962d36c273644edccd120264fbaaf6c95) Bevel parameter of Rectangle layer is a relative value, not distance ([#2350](https://github.com/synfig/synfig/issues/2350)) [core]
- [`1210f50`](https://github.com/synfig/synfig/commit/1210f50b67ffa33d34f6312c7e6a14bf12e87a91) Add Handle type to Skeleton and SkeletonDeformation layers ([#2348](https://github.com/synfig/synfig/issues/2348)) [core] [studio]
- [`d7fcc40`](https://github.com/synfig/synfig/commit/d7fcc40d177250ae3a5b646b2dac8889e6c3f6d7) Bone Tool: Fix crash when undoing Child Bone until first one ([#2341](https://github.com/synfig/synfig/issues/2341)) [studio]
- [`61a290b`](https://github.com/synfig/synfig/commit/61a290b1aaf58366149662ae0ad224127711aea8) Fixed crash of test on Void Linux ([#2265](https://github.com/synfig/synfig/issues/2265)) [studio]
- [`269d895`](https://github.com/synfig/synfig/commit/269d895a128b947130f4b91a3e498b6070a5b4fd) Select parent group after image import ([#2339](https://github.com/synfig/synfig/issues/2339)) [studio]
- [`84f1241`](https://github.com/synfig/synfig/commit/84f124171763b449efb9dca024b1ba4abaa79051) Bone Tool: fix default bone width preference loading ([#2343](https://github.com/synfig/synfig/issues/2343)) [studio]
- [`5312fea`](https://github.com/synfig/synfig/commit/5312fea69f2bbbca5c8f552990a1f8c16d506ccc) Merge PR [#2232](https://github.com/synfig/synfig/issues/2232): Add better support for RTL text to Text Layer [core]
- [`fcaa6fb`](https://github.com/synfig/synfig/commit/fcaa6fb5f05886e48ffac315ead3767a1104c0b2) Merge PR [#2325](https://github.com/synfig/synfig/issues/2325): Skeleton Tool cleanup [studio]
- [`fb374ca`](https://github.com/synfig/synfig/commit/fb374cabd9db10cd4d49e1ad83ffbb5bb5d0be91) minor cleanup in ValueDescBoneSetParent action ([#2331](https://github.com/synfig/synfig/issues/2331)) [studio]
- [`cbdc86a`](https://github.com/synfig/synfig/commit/cbdc86ad63aefe27253a883a49435fbd8eebe44b) Fix *again* dialog responses. Mistakes made in 5ffa7928dd55ae66f77b8ea4e61f2864f0f72b10 ([#2329](https://github.com/synfig/synfig/issues/2329)) [studio]
- [`3ed1d3f`](https://github.com/synfig/synfig/commit/3ed1d3fd87025fc5b318ea840f1fcbd1fa01cf44) Skeleton Deformation: improve "Bones" parameter tooltip/description ([#2332](https://github.com/synfig/synfig/issues/2332)) [core]
- [`e0cfca4`](https://github.com/synfig/synfig/commit/e0cfca4bb12e033bdf59b592379f84c13be013cb) add explicit namespace synfigapp for Action macros ([#2334](https://github.com/synfig/synfig/issues/2334)) [studio]
- [`c185ad2`](https://github.com/synfig/synfig/commit/c185ad22c35e50d4cda20e2107a11940f9888c66) minor cleanup on SynfigCommandLineParser ([#2335](https://github.com/synfig/synfig/issues/2335)) [core]
- [`88c9e97`](https://github.com/synfig/synfig/commit/88c9e976c1a150ef86452c6fed81746af57322bc) Made shared_objects non-copyable ([#2291](https://github.com/synfig/synfig/issues/2291)) [ETL] [core]
- [`5ffa792`](https://github.com/synfig/synfig/commit/5ffa7928dd55ae66f77b8ea4e61f2864f0f72b10) Fix dialog responses for user pressing Esc key ([#2309](https://github.com/synfig/synfig/issues/2309)) [studio]
- [`c78c447`](https://github.com/synfig/synfig/commit/c78c4479e66b9f3dff14deb2356921079bdeb1fb) Minor cleanup in CreateChildBone action ([#2315](https://github.com/synfig/synfig/issues/2315)) [studio]
- [`be2b1db`](https://github.com/synfig/synfig/commit/be2b1dbf98d7d294fcb27c91f102848166de9fef) Improve hints for Dash item parameters ([#2314](https://github.com/synfig/synfig/issues/2314)) [core]
- [`23d997a`](https://github.com/synfig/synfig/commit/23d997a803cb9f99cc7e3be2895eeea51fe4c67c) Merge PR [#2303](https://github.com/synfig/synfig/issues/2303): SVG parser: refactor style parser [core]
- [`7f1444e`](https://github.com/synfig/synfig/commit/7f1444e46825ce3eca2493589f422145f4f59541) Don't let inner layer be duplicated twice when copying ([#2317](https://github.com/synfig/synfig/issues/2317)) [studio]
- [`039ec6f`](https://github.com/synfig/synfig/commit/039ec6f690bfa74126dac92c3527c6458bfdf712) When the user imports the file the imported layer becomes selected ([#2308](https://github.com/synfig/synfig/issues/2308)) [studio]
- [`db9db14`](https://github.com/synfig/synfig/commit/db9db14fb9d1513c8c84c68dab7c5aeba3b8b35b) Create a new vertex on a Spline on double-click ([#2312](https://github.com/synfig/synfig/issues/2312)) [studio]
- [`96f9856`](https://github.com/synfig/synfig/commit/96f9856dda598a3d6a5baeac557613ffe4708d04) Update time track area when keyframe is changed from keyframe header ([#2289](https://github.com/synfig/synfig/issues/2289)) [studio]
- [`2cbce01`](https://github.com/synfig/synfig/commit/2cbce018087fe63227afa099760ce83ecb4005f3) Fixed soundwave for some audio files that couldn't be loaded ([#2301](https://github.com/synfig/synfig/issues/2301)) [studio]
- [`1e94508`](https://github.com/synfig/synfig/commit/1e94508a38e0f14800dabea9fe6a86baa24ae99f) Remove unused classes ([#2298](https://github.com/synfig/synfig/issues/2298)) [studio]
- [`0cb03f3`](https://github.com/synfig/synfig/commit/0cb03f306ce8f12c92faa0349434177801dbb511) Replaced using std/etl namespaces with explicit namespace name ([#2292](https://github.com/synfig/synfig/issues/2292)) [ETL] [core] [studio]
- [`3c8ae63`](https://github.com/synfig/synfig/commit/3c8ae63c0fa0fa8a47c5cc213e012753f8098efe) Merge PR [#2166](https://github.com/synfig/synfig/issues/2166): Add Onion Skin ability to choose between Keyframes and Frames [studio]
- [`e074b30`](https://github.com/synfig/synfig/commit/e074b30da70e61b8b95ad9be2698f72853b4f1e0) Removed unused std/etl namespaces ([#2290](https://github.com/synfig/synfig/issues/2290)) [ETL] [core] [studio]
- [`9a86ba4`](https://github.com/synfig/synfig/commit/9a86ba492f04d23b1bb9a8410a49a2ac47750c8e) Fix crash when moving origin point of child bone in Skeleton Deformation Layer using Bone Tool ([#2049](https://github.com/synfig/synfig/issues/2049)) [studio]
- [`3ede603`](https://github.com/synfig/synfig/commit/3ede60357ad029f4376519fb2a1b85bd74e36624) Extracted layer size update as a separate function ([#2282](https://github.com/synfig/synfig/issues/2282)) [studio]
- [`c29dddf`](https://github.com/synfig/synfig/commit/c29dddf3485204724f407a211888085cf734efac) Merge PR [#2278](https://github.com/synfig/synfig/issues/2278): Fix "files left after uninstall" error for "distuninstallcheck" target [studio]
- [`f62997a`](https://github.com/synfig/synfig/commit/f62997ab0e426a7b46b41273fd73c665c1fc345c) Added glibmm dependency PR [#2278](https://github.com/synfig/synfig/issues/2278) [ETL]
- [`bd50192`](https://github.com/synfig/synfig/commit/bd50192679428ee10371c2a78d072e7bd4b731cd) Update release scripts ([#2269](https://github.com/synfig/synfig/issues/2269))

## Version 1.5.0 [ETL] [core] [studio]

- [`4c3f97d`](https://github.com/synfig/synfig/commit/4c3f97dfd4340b74e72f0b2a033aeed70b6efc5a) fix importing into unsaved SIF file ([#2243](https://github.com/synfig/synfig/issues/2243)) [studio]
- [`736bc77`](https://github.com/synfig/synfig/commit/736bc7775325270275cd294d5b8f04983a186e09) Updated snap to 1.4.2 ([#2249](https://github.com/synfig/synfig/issues/2249))
- [`247909c`](https://github.com/synfig/synfig/commit/247909c2cd07a4121192f8ee8eddeb31c800fb86) [Core] ValueNode_AnimatedFile now supports more data types ([#2240](https://github.com/synfig/synfig/issues/2240)) [core]
- [`4b26b30`](https://github.com/synfig/synfig/commit/4b26b30a6ae4f76bbc3ce8ac21f915f9c1f14b9e) Refresh rend_desc of canvas interface when end time is changed from toolbar ([#2213](https://github.com/synfig/synfig/issues/2213)) [studio]
- [`101a5aa`](https://github.com/synfig/synfig/commit/101a5aa178019fddcaadf6436ea0c37cc1f5162f) Merge PR [#2236](https://github.com/synfig/synfig/issues/2236): [Lottie exporter] Add animation to addition/deletion of Bline points [studio]
- [`fb80f27`](https://github.com/synfig/synfig/commit/fb80f27e956d5a8dcc0b1b03db9262bd76388d24) Added Synfig tests to Github CI workflow ([#2238](https://github.com/synfig/synfig/issues/2238))
- [`4717669`](https://github.com/synfig/synfig/commit/4717669e5b5f8aabe272a8013607c060adcd9409) Disabled some Travis CI build jobs ([#2237](https://github.com/synfig/synfig/issues/2237))
- [`f32ae7f`](https://github.com/synfig/synfig/commit/f32ae7fbb91f037b0203e1709c32261ee749ee92) [Lottie exporter] Add animation to addition/deletion of Width points and Dash items in advanced outline ([#2233](https://github.com/synfig/synfig/issues/2233)) [studio]
- [`1dce9a1`](https://github.com/synfig/synfig/commit/1dce9a1c5282edd13feb35f417b2e5663e3759b0) Pass param_desc only if value_desc is a layer ([#2234](https://github.com/synfig/synfig/issues/2234)) [studio]
- [`bc658a2`](https://github.com/synfig/synfig/commit/bc658a2aa0610b61477b5b9dffa7b0ad75d56b89) Merge PR [#2215](https://github.com/synfig/synfig/issues/2215): Layers in sets can now be selected with a single click, rather than a double click [studio]
- [`a195452`](https://github.com/synfig/synfig/commit/a195452d01409e1a395f35679be1228c17a9e867) Fixed accidentally removed Brush widget in Widget_Defaults ([#2218](https://github.com/synfig/synfig/issues/2218)) [studio]
- [`960c100`](https://github.com/synfig/synfig/commit/960c100c98e31a11023c525a9a77b7870237e6ba) Fixed missing namespace in unit test code ([#2214](https://github.com/synfig/synfig/issues/2214)) [core]
- [`87d79b0`](https://github.com/synfig/synfig/commit/87d79b060a3a4542adb757517da13e88f8321fe9) Merge PR [#2207](https://github.com/synfig/synfig/issues/2207): Added support for Rhubarb Lip Sync TSV and XML file formats for ValueNode_AnimatedFile [core] [studio]
- [`132b09e`](https://github.com/synfig/synfig/commit/132b09e0a9936168c217f818843a271fe20e82e6) Removed excessive use of std namespace (part 2) ([#2194](https://github.com/synfig/synfig/issues/2194)) [core] [studio]
- [`9acfd9c`](https://github.com/synfig/synfig/commit/9acfd9c0e1b42b5bdf6a31747930d2be855224ee) Merge PR [#2206](https://github.com/synfig/synfig/issues/2206): Clean synfigapp::ValueDesc a bit [studio]
- [`4f6cbf3`](https://github.com/synfig/synfig/commit/4f6cbf3f045806b169408f66b28195e1e2f7cb5e) Replaced deprecated Gtk::Alignment class using Widget margins ([#2187](https://github.com/synfig/synfig/issues/2187)) [studio]
- [`c3e196e`](https://github.com/synfig/synfig/commit/c3e196e1974108a264016c61909cf12f8d802560) Replaced `Gtk::Alignment` spaces with CSS margins ([#2195](https://github.com/synfig/synfig/issues/2195)) [studio]
- [`4273435`](https://github.com/synfig/synfig/commit/4273435309266fa4181269fdb3e9cc454cf14337) Removed excessive use of std namespace ([#2193](https://github.com/synfig/synfig/issues/2193)) [ETL] [core] [studio]
- [`bd86b81`](https://github.com/synfig/synfig/commit/bd86b81940487d3b4d4682f6e01df341211b97c3) New arrows icons ([#2192](https://github.com/synfig/synfig/issues/2192)) [studio]
- [`9b6c3a2`](https://github.com/synfig/synfig/commit/9b6c3a2a62796647f0937c6ad8354f1411c8776c) Merge PR [#2184](https://github.com/synfig/synfig/issues/2184): Fixed CMake icons build [studio]
- [`7d22123`](https://github.com/synfig/synfig/commit/7d22123c58d729146c0728414e07105eb649e8cd) Fixed [issue](https://github.com/synfig/synfig/issues/1803) with closed docks appearing after application restart ([#2185](https://github.com/synfig/synfig/issues/2185)) [studio]
- [`27a1a55`](https://github.com/synfig/synfig/commit/27a1a555aa5664d2466059203a9eedee81fd4bb3) Fixed incorrect behavior when passing '-DMSYS=1' to CMake [cmake] ([#2158](https://github.com/synfig/synfig/issues/2158))
- [`eafeda4`](https://github.com/synfig/synfig/commit/eafeda4828fea262646abba906b6650fb16591f4) Removed reminiscent Cairo (and Pango) stuff ([#2174](https://github.com/synfig/synfig/issues/2174)) [core]
- [`b75ef5e`](https://github.com/synfig/synfig/commit/b75ef5ed7a8eaa5409aba84cdb3e8f2afdcf9f97) Make sure sequence separator string is always in sync with Preferences ([#2171](https://github.com/synfig/synfig/issues/2171)) [studio]
- [`7ba303a`](https://github.com/synfig/synfig/commit/7ba303a3afab3edd5816b6a39d4af41a7f45d158) [Synfig Studio] Split top horizontal toolbar in two toolbars (horizontal+vertical) ([#1958](https://github.com/synfig/synfig/issues/1958)) [studio]
- [`a578526`](https://github.com/synfig/synfig/commit/a578526a75d44a0868881fee2bfc85a4c38f5656) Merge PR [#2154](https://github.com/synfig/synfig/issues/2154): Fix Warp not properly clipping noise gradient layer. Closes [#2124](https://github.com/synfig/synfig/issues/2124). [core]
- [`e5d547a`](https://github.com/synfig/synfig/commit/e5d547af4e0cfbba6c01ac1d3ce31906fe55493e) Fixed mod_dv build with MSVC compiler ([#2159](https://github.com/synfig/synfig/issues/2159)) [core]
- [`f5daba4`](https://github.com/synfig/synfig/commit/f5daba4a909b2bc989bd674ab9a21bc99584a4bc) Removed accels for no-more-existent actions (Change Preview Quality) ([#2164](https://github.com/synfig/synfig/issues/2164)) [studio]
- [`96c85ed`](https://github.com/synfig/synfig/commit/96c85edfa3cf72abaa5c2eb85ceb3903a9ff10be) Enabled AppVeyor artifacts back ([#2151](https://github.com/synfig/synfig/issues/2151))
- [`1233e4c`](https://github.com/synfig/synfig/commit/1233e4cd1913b64706881293e323a77d1d7641b6) Fixed misc. typos ([#2155](https://github.com/synfig/synfig/issues/2155)) [core]
- [`e0ad411`](https://github.com/synfig/synfig/commit/e0ad411a079db5cc545e99de286157d602144582) `1-setup-linux-native.sh` script now supports PipeWire ([#2145](https://github.com/synfig/synfig/issues/2145))
- [`ffb9852`](https://github.com/synfig/synfig/commit/ffb98528b4ec21bb888c5acd09448d0af0320239) [CMake] Removed unnecessary dependencies in modules ([#2129](https://github.com/synfig/synfig/issues/2129)) [core]
- [`47c01d2`](https://github.com/synfig/synfig/commit/47c01d220b3cfa45b03a236f2ec730159ae590dd) Update issue templates for GitHub ([#2150](https://github.com/synfig/synfig/issues/2150))
- [`a633cae`](https://github.com/synfig/synfig/commit/a633cae20ffebd14e0f3bb770471a93bd6b3806a) [MacOS] Removed unnecessary pip installation ([#2146](https://github.com/synfig/synfig/issues/2146))
- [`46ed36c`](https://github.com/synfig/synfig/commit/46ed36c9a100857b2f2b0a87de40c6ee734e5744) Merge PR [#2054](https://github.com/synfig/synfig/issues/2054): Removed unused CairoRenderer [core] [studio]
- [`2ef1e6f`](https://github.com/synfig/synfig/commit/2ef1e6f6553b2c6dd844a6b94014350b1b64ea83) [CMake] Disable the use of MLT if MLT library not found ([#2138](https://github.com/synfig/synfig/issues/2138)) [core] [studio]
- [`14eccd4`](https://github.com/synfig/synfig/commit/14eccd4c009557a03c536fc56761ce577a95ab40) Added the ability to create Plant and Curve Gradient layer from other Splines ([#1476](https://github.com/synfig/synfig/issues/1476)) [studio]
- [`6afeb2f`](https://github.com/synfig/synfig/commit/6afeb2f5c81e5a643e2a528979e626e809521b83) Align close button of animation tabs to the right for better looking layout ([#2136](https://github.com/synfig/synfig/issues/2136)) [studio]
- [`9048540`](https://github.com/synfig/synfig/commit/904854058c8a52c43a16fc8bcb30596172914ce4) [CMake] Fixed ETL tests ([#2135](https://github.com/synfig/synfig/issues/2135)) [ETL]
- [`7d4d8b7`](https://github.com/synfig/synfig/commit/7d4d8b79ba5e00e1e28d66fb3b2ebb30f875387e) Removed unused headers ([#2121](https://github.com/synfig/synfig/issues/2121)) [core]
- [`6329a76`](https://github.com/synfig/synfig/commit/6329a76d914718b74922c475b6c7f80cdb934068) [Synfig Studio] Replacing Gtk::HBox with Gtk::Box ([#2126](https://github.com/synfig/synfig/issues/2126)) [studio]
- [`8b1bc8c`](https://github.com/synfig/synfig/commit/8b1bc8c1aa7bbb7222b1539c5029ad13458e5ec9) [CMake] Fixed splash screen creation when build type is differs from debug/release. ([#2130](https://github.com/synfig/synfig/issues/2130)) [studio]
- [`e6bbcab`](https://github.com/synfig/synfig/commit/e6bbcabf2273bfe67909a2bb3ef63036c8eebda7) [CMake] Bump minimum required CMake version to 3.5 ([#2128](https://github.com/synfig/synfig/issues/2128)) [ETL] [core] [studio]
- [`b277312`](https://github.com/synfig/synfig/commit/b2773121ccd27694b8b86f01e896db25647bef56) [Synfig Studio] Replace some other deprecated Gtk libraries ([#2113](https://github.com/synfig/synfig/issues/2113)) [studio]
- [`d667744`](https://github.com/synfig/synfig/commit/d66774460d52b3a5b237cae04b81585c45970476) Replace deprecated get_vbox() method ([#2112](https://github.com/synfig/synfig/issues/2112)) [studio]
- [`d15df18`](https://github.com/synfig/synfig/commit/d15df1895026e4b6161056f6fec40cc664ae9e1c) Added Ctrl+E as keyboard shortcut for the "Save All" menu action ([#2114](https://github.com/synfig/synfig/issues/2114)) [studio]
- [`73f4540`](https://github.com/synfig/synfig/commit/73f4540df5291c20a6981f81e30347fdb621c005) Merge PR [#2093](https://github.com/synfig/synfig/issues/2093): Add tools for maintaining ChangeLog
- [`c76ede2`](https://github.com/synfig/synfig/commit/c76ede2b0f8625886ae5c7a2b4f243d56b4b8ca1) Merge PR [#2104](https://github.com/synfig/synfig/issues/2104): MSVC compilation fixes (04-2021) [core] [core] [studio]
- [`83f6394`](https://github.com/synfig/synfig/commit/83f6394ea858248bae7e80c117580a9340a46968) [Synfig Studio] Replace set_alignment and set_padding deprecated methods ([#2105](https://github.com/synfig/synfig/issues/2105)) [studio]
- [`f9ab463`](https://github.com/synfig/synfig/commit/f9ab46339ebd13f73b947d790617f3197687008e) Seek to begin/end follow playback bounds set by user ([#2097](https://github.com/synfig/synfig/issues/2097)) [studio]
- [`6c8966e`](https://github.com/synfig/synfig/commit/6c8966e6bb7550c904a49a5329409e8a0348f29e) Replace Render and Preview dialogs deprecated methods ([#2101](https://github.com/synfig/synfig/issues/2101)) [studio]
- [`687f788`](https://github.com/synfig/synfig/commit/687f788b8019680f0c0a70a8292e6699d20b941c) [MSVC] Fixed unresolved external symbol error when building `lyr_std` ([#2096](https://github.com/synfig/synfig/issues/2096)) [core]
- [`dc3e10a`](https://github.com/synfig/synfig/commit/dc3e10a398f336bddeeff1f113f9660232352747) Replace deprecated methods and disable window resizing ([#2100](https://github.com/synfig/synfig/issues/2100)) [studio]
- [`1d88a3d`](https://github.com/synfig/synfig/commit/1d88a3d8d903218e51e7d5fdcfdc960d3fda5f97) Replace deprecated Gtk::HScale with Gtk::Scale and fine-tune step increments ([#2098](https://github.com/synfig/synfig/issues/2098)) [studio]
- [`41b7682`](https://github.com/synfig/synfig/commit/41b7682921c0a83576d116a5f9b57991860620af) Changed the order of buttons in various dialog boxes (Color, Paragraph, Gradient, Target options) ([#2090](https://github.com/synfig/synfig/issues/2090)) [studio]
- [`ef901e4`](https://github.com/synfig/synfig/commit/ef901e498d8a9653b06971f034b9641946ba4f50) Reset progress bar in Info window as Preview rendering is stopped ([#2083](https://github.com/synfig/synfig/issues/2083)) [studio]
- [`0b5e1d2`](https://github.com/synfig/synfig/commit/0b5e1d29174f6b2e348a5560a7bd5b513b639b5e) [Synfig Studio] Stop rendering button has been moved to the right of the progress bar ([#2078](https://github.com/synfig/synfig/issues/2078)) [studio]
- [`1ffe5c3`](https://github.com/synfig/synfig/commit/1ffe5c321e0c8c6a13168e6a4f65025f4fbd0537) [Snapcraft] Added Lottie dependency (lxml) ([#2060](https://github.com/synfig/synfig/issues/2060))
- [`53153ef`](https://github.com/synfig/synfig/commit/53153efa00f93bd9e31e4c6c37676acec4875f83) [Synfig Studio] Toolbox migration from Gtk::Table to Gtk::Grid ([#2079](https://github.com/synfig/synfig/issues/2079)) [studio]
- [`25e03d1`](https://github.com/synfig/synfig/commit/25e03d14d0eacb471f06724e7a22e0fe8b720190) [Core/Studio] Fix coverity warnings ([#2045](https://github.com/synfig/synfig/issues/2045)) [core] [studio]
- [`209319c`](https://github.com/synfig/synfig/commit/209319c741b40ac43e8c8f3244caeacfa50ffa4a) [Python] Allow to use updated dependencies ([#2069](https://github.com/synfig/synfig/issues/2069))
- [`431ab77`](https://github.com/synfig/synfig/commit/431ab77d7a34d59b888a8b24fb572267b3761e48) [Synfig Studio] The canvas properties dialog now displays values correctly after being closed with the window close button. ([#2076](https://github.com/synfig/synfig/issues/2076)) [studio]
- [`7ffa0d6`](https://github.com/synfig/synfig/commit/7ffa0d67f8f3056c4f43d5229c012d62a22ae8ee) [Appveyor] Temporarily disable artifact storing (run out of space) ([#2072](https://github.com/synfig/synfig/issues/2072))
- [`2fd42d2`](https://github.com/synfig/synfig/commit/2fd42d255e6dd59f2024b17fef51d723e92e8d22) Bump pillow from 8.0.0 to 8.1.1 in /perf/scripts ([#2070](https://github.com/synfig/synfig/issues/2070))
- [`3f608be`](https://github.com/synfig/synfig/commit/3f608be77e6ffd44f3dee93aa12b463801d290da) [Synfig Studio] Duckmatic: minor cleanup ([#2056](https://github.com/synfig/synfig/issues/2056)) [studio]
- [`a1f27de`](https://github.com/synfig/synfig/commit/a1f27de8c154776c1822bccbc2931cbc5d9150dd) [Core] avoid comma operator and prefer return value of std::list::erase() ([#2053](https://github.com/synfig/synfig/issues/2053)) [core]
- [`23d0559`](https://github.com/synfig/synfig/commit/23d05595b97028b18a7b01b5aa2e4d0ecfeddc48) [Core] prefer std::thread rather deprecated Glib::Threads ([#2052](https://github.com/synfig/synfig/issues/2052)) [core]
- [`17d685c`](https://github.com/synfig/synfig/commit/17d685c6a81b483cb5c1475c25207f119bc960f9) [Synfig Studio] Bone Tool: fix bone width on wrong situations ([#2048](https://github.com/synfig/synfig/issues/2048)) [studio]
- [`ae6925b`](https://github.com/synfig/synfig/commit/ae6925bd26e03d15e566b96c42ce169801d40821) [Core] Fixed warnings ([#2044](https://github.com/synfig/synfig/issues/2044)) [studio]
- [`bc2e3e5`](https://github.com/synfig/synfig/commit/bc2e3e570a1e47a5e2b0245ad44f31efffcf35f8) [Synfig Studio] Noticeable progress bar ([#2019](https://github.com/synfig/synfig/issues/2019)) [studio]
- [`c7e0960`](https://github.com/synfig/synfig/commit/c7e0960da15c8dde969880c182940d2e85d283fd) [Synfig Studio] Remember the Number of rendering thread ([#2023](https://github.com/synfig/synfig/issues/2023)) [studio]
- [`94d8c47`](https://github.com/synfig/synfig/commit/94d8c476189891c0fab33fdff31f04b89db47daf) [Core/Studio] use std::thread::hardware_concurrency() instead of g_get_num_processors() ([#2042](https://github.com/synfig/synfig/issues/2042)) [core] [studio]
- [`5664a71`](https://github.com/synfig/synfig/commit/5664a7140e1f9e6120b747f2c22583d905fcd7a7) Merge PR [#2040](https://github.com/synfig/synfig/issues/2040): [CLI] minor cleanup in command-line option parser [core] [studio]
- [`d3ce556`](https://github.com/synfig/synfig/commit/d3ce5563e2315d72d786b2d0fb7d71a0832b6f07) Update issue templates
- [`7f67cc2`](https://github.com/synfig/synfig/commit/7f67cc22dc831edb199b82c71aab22b407aa3292) [Autotools] Fixed `make distcheck`. Reduced build output for synfigstudio-release.sh script. ([#2004](https://github.com/synfig/synfig/issues/2004)) [ETL] [core] [studio]
- [`05b1ee2`](https://github.com/synfig/synfig/commit/05b1ee273f564b1422b2e14c039e22455b380a5a) [ETL/Core] Fixed warnings ([#2013](https://github.com/synfig/synfig/issues/2013)) [ETL] [core] [studio]
- [`17c9a70`](https://github.com/synfig/synfig/commit/17c9a7080ad52e40b50f176b590e7a6d37d63de9) Turn off color dialog's resizability ([#2031](https://github.com/synfig/synfig/issues/2031)) [studio]
- [`a9f00b7`](https://github.com/synfig/synfig/commit/a9f00b73fc61a14cc4f1ed2c793547206c77d938) [Synfig Studio] Improve style context code to one line ([#2032](https://github.com/synfig/synfig/issues/2032)) [studio]
- [`73dcea6`](https://github.com/synfig/synfig/commit/73dcea631b8b5dd22d5babf613c63b6b2d2fc379) [Core] remove unused class GUIDHash ([#2030](https://github.com/synfig/synfig/issues/2030)) [core]
- [`9e653c6`](https://github.com/synfig/synfig/commit/9e653c6b0a013b1a40a414f314d3035285dffb1a) [Core] remove unused synfig/nodebase.h ([#2024](https://github.com/synfig/synfig/issues/2024)) [core]
- [`10b7715`](https://github.com/synfig/synfig/commit/10b7715872763b7b488e43fb2284f6535336a895) Merge PR [#2012](https://github.com/synfig/synfig/issues/2012): [Synfig Studio] Added support for merge/split tangents for multiple vertices of object [studio]
- [`4c33e75`](https://github.com/synfig/synfig/commit/4c33e75956ae62185f0b5103d0d0b03af437f628) [Core/Studio] Added support for user-installed fonts on Windows 10 (1809) ([#1997](https://github.com/synfig/synfig/issues/1997)) [core] [studio]
- [`fe6dd29`](https://github.com/synfig/synfig/commit/fe6dd2941ea77709ddf7f0ca0a98fb5a1b82917d) [Synfig Studio] Allow to set number of rendering threads from Preferences dialog ([#1999](https://github.com/synfig/synfig/issues/1999)) [core] [studio]
- [`39a0ab4`](https://github.com/synfig/synfig/commit/39a0ab456021155a85d2936fbedff59464c74023) Merge PR [#1970](https://github.com/synfig/synfig/issues/1970): [Synfig Studio] Implement Ctrl+Shift+Scroll to zoom horizontally in panels [studio]
- [`34127e8`](https://github.com/synfig/synfig/commit/34127e88e94ea3ec36a39a1246ee1d946093f58d) Merge PR [#1974](https://github.com/synfig/synfig/issues/1974): [Synfig Studio] Set Enum parameters to Static by default [core] [studio]
- [`76e827e`](https://github.com/synfig/synfig/commit/76e827e2ab186e4635cc5942478956b41cb86b0e) [Core] Refactored trgt_ffmpeg ([#1947](https://github.com/synfig/synfig/issues/1947)) [core]
- [`44b46a2`](https://github.com/synfig/synfig/commit/44b46a230c1a3e7f14451b3cfde5ea8f45e163dc) [CMake/Core] Added glib dependency ([#2009](https://github.com/synfig/synfig/issues/2009)) [core]
- [`53aebba`](https://github.com/synfig/synfig/commit/53aebba8412d1c28a3218365bf18d4105e955cd2) Merge PR [#1950](https://github.com/synfig/synfig/issues/1950): [ETL/Core] `rect` class moved from ETL to core. [ETL] [core] [studio]
- [`cf42eb4`](https://github.com/synfig/synfig/commit/cf42eb4ffc769737c43893877f92d8404cb63af4) [Synfig Studio] destructors should not call virtual methods ([#2003](https://github.com/synfig/synfig/issues/2003)) [studio]
- [`cc4aa73`](https://github.com/synfig/synfig/commit/cc4aa73b6114faec56afb7b7ac1c69fa9dea4a33) [Synfig Studio] remove unused variable mod_palette_ from App ([#2002](https://github.com/synfig/synfig/issues/2002)) [studio]
- [`cde3553`](https://github.com/synfig/synfig/commit/cde355308969770d4af2b78604bdbc7a36375c4d) [CI] Fixed wrong stable branch name for GitHub Actions ([#1998](https://github.com/synfig/synfig/issues/1998))
- [`a9b80ea`](https://github.com/synfig/synfig/commit/a9b80ea7e1531ccd2eaed074930526a246dce7df) [Synfig Studio] Improve layout of Workspaces editor ([#1991](https://github.com/synfig/synfig/issues/1991)) [studio]
- [`d75cd9f`](https://github.com/synfig/synfig/commit/d75cd9fd91a9702af3d49db64197a5298a45c728) [Synfig Studio] Removed unnecessary explicit cast std::string to Glib::ustring ([#1993](https://github.com/synfig/synfig/issues/1993)) [studio]
- [`99fe201`](https://github.com/synfig/synfig/commit/99fe201d203c450e69a9123a14f70b4d8a07069b) Merge PR [#1992](https://github.com/synfig/synfig/issues/1992): [Synfig Studio] Fix parameter values of several layers shown as distance metrics when they are not [core] [studio]
- [`12b29c7`](https://github.com/synfig/synfig/commit/12b29c735a62f1896e557361f5dfcc3de41a0a11) Merge PR [#1945](https://github.com/synfig/synfig/issues/1945): [Synfig Studio] Make Preview tooltips and titles consistent with other dialogs [studio]
- [`7ccb5d7`](https://github.com/synfig/synfig/commit/7ccb5d702f5369f09a3524e0e9715394d629be91) Merge PR [#1985](https://github.com/synfig/synfig/issues/1985): [CI] GitHub actions improvements
- [`c1e6ca0`](https://github.com/synfig/synfig/commit/c1e6ca001861dd5d815b91f9c6e35ccb0c59a84c) [Synfig Studio] fix states accelerator shortcut in tooltips ([#1959](https://github.com/synfig/synfig/issues/1959)) [studio]
- [`6d407c2`](https://github.com/synfig/synfig/commit/6d407c2c7a6e86eed34687214123fddc6fbc4a66) autotools: fix POTFILES.in again and Makefile.am ([#1981](https://github.com/synfig/synfig/issues/1981)) [studio]
- [`456bf8c`](https://github.com/synfig/synfig/commit/456bf8c80d8d78bbc37b6fb9eb92ca017e5a4813) [Synfig Studio] Fixed build error ([#1976](https://github.com/synfig/synfig/issues/1976)) [studio]
- [`0672879`](https://github.com/synfig/synfig/commit/06728793ad0432d8350ff7886ba7f7da16d7c180) Scroll step size set to 1 frame and 10 with Ctrl ([#1967](https://github.com/synfig/synfig/issues/1967)) [studio]
- [`4d7689b`](https://github.com/synfig/synfig/commit/4d7689b40a7a846400195672e9dfc3f2db653c1c) [CMake] Fixed issue with CMake generating file inside source tree when using out-of-source build ([#1964](https://github.com/synfig/synfig/issues/1964)) [core]
- [`8a893b8`](https://github.com/synfig/synfig/commit/8a893b8e2821da000d9a5feebd60b730b558c235) [CMake/MSVC] Added required packages ([#1962](https://github.com/synfig/synfig/issues/1962)) [core] [studio]
- [`55ec4cc`](https://github.com/synfig/synfig/commit/55ec4ccb3160783c2d2a5aeb0655be38cd036eb4) [Synfig Studio] Removed Win32 mkdir() redefinition ([#1960](https://github.com/synfig/synfig/issues/1960)) [studio]
- [`0954a7f`](https://github.com/synfig/synfig/commit/0954a7f07803855ab3c20ec2c83e615eaeb0a8c9) [Synfig Studio] remove unused headers ([#1957](https://github.com/synfig/synfig/issues/1957)) [studio]
- [`4b7f89b`](https://github.com/synfig/synfig/commit/4b7f89beab97bd565df50d7dd559124ebb163b52) [Synfig Studio] Make sure Show/Snap Guides toolbar buttons are always working ([#1949](https://github.com/synfig/synfig/issues/1949)) [studio]
- [`3f6e3c9`](https://github.com/synfig/synfig/commit/3f6e3c9215d6097391617ca97f7a846865d0b0cb) [Synfig Core] Removed unused headers ([#1944](https://github.com/synfig/synfig/issues/1944)) [core]
- [`d6ab408`](https://github.com/synfig/synfig/commit/d6ab4088273205931a69363fae2016bd77bb3d75) [Synfig Studio] Add Show/Snap Guides to Toolbar ([#1928](https://github.com/synfig/synfig/issues/1928)) [studio]
- [`70c5ff6`](https://github.com/synfig/synfig/commit/70c5ff6cc55eab34d86142b00d6d0f0d132b0af0) [Synfig Studio] Duckmatic: signal_grid_changed never emitted ([#1937](https://github.com/synfig/synfig/issues/1937)) [studio]
- [`4690620`](https://github.com/synfig/synfig/commit/4690620760afb60540ac52ee063eda3bafcc04e9) Merge PR [#1939](https://github.com/synfig/synfig/issues/1939): [Synfig Studio] app.cpp : some cleanup [studio]
- [`a9ef157`](https://github.com/synfig/synfig/commit/a9ef15773780308e462c55add44f445227097054) [Synfig Studio] refactored URI code in CanvasView ([#1943](https://github.com/synfig/synfig/issues/1943)) [studio]
- [`e320613`](https://github.com/synfig/synfig/commit/e3206139323757abdc878acc9cd5651ae0e24ce1) [Synfig Studio] Disabled resizing of the Preview Options dialog ([#1942](https://github.com/synfig/synfig/issues/1942)) [studio]
- [`c32de32`](https://github.com/synfig/synfig/commit/c32de327f81abcfb4786ca3f7f60e0440a67e036) [Synfig Core] Added freetype detail (font face/filename) to error description ([#1938](https://github.com/synfig/synfig/issues/1938)) [core]
- [`20f4bda`](https://github.com/synfig/synfig/commit/20f4bda968b7ca87901685f1a9fb86072fd95d34) [Synfig Studio] Add Eyedrop Tool legend in Toolbox ([#1925](https://github.com/synfig/synfig/issues/1925)) [studio]
- [`ca869b1`](https://github.com/synfig/synfig/commit/ca869b1cf3d6c602c9c8432022b2950a2c30df60) [Synfig Studio] Don't expand File Format Version drop-down list ([#1933](https://github.com/synfig/synfig/issues/1933)) [studio]
- [`ce8834e`](https://github.com/synfig/synfig/commit/ce8834ebbb2ba6a0136f2d98b93c0cbd88e27c6a) [CMake/Windows] Fixed missing `libgcc_s_dw2-1.dll` file in portable archive (x32) ([#1919](https://github.com/synfig/synfig/issues/1919))
- [`7e63655`](https://github.com/synfig/synfig/commit/7e636558274ba7c1a89347d99994dc211c80b047) [Core] Cleanup blur code ([#1918](https://github.com/synfig/synfig/issues/1918)) [core]
- [`6676204`](https://github.com/synfig/synfig/commit/6676204d88abf9f213d6fa5b342477c8afcadddb) [Synfig Studio] remove unused headers ([#1923](https://github.com/synfig/synfig/issues/1923)) [studio]
- [`a4327a8`](https://github.com/synfig/synfig/commit/a4327a87e36aaf19c71e143c7cfb642cddb0b7e1) [Synfig Studio] Don't expand Interpolation widget more than allocated width ([#1927](https://github.com/synfig/synfig/issues/1927)) [studio]
- [`9f51f5e`](https://github.com/synfig/synfig/commit/9f51f5ecafad570c64e38fdecaf455d7e44e3e1c) [Synfig Studio] Center "Scale to fit Canvas" switch vertically to avoid stretching ([#1926](https://github.com/synfig/synfig/issues/1926)) [studio]
- [`f25b03e`](https://github.com/synfig/synfig/commit/f25b03e06407558c9b49dc53ac0709bc095657ba) [Appveyor] Bump artifact version ([#1913](https://github.com/synfig/synfig/issues/1913))
- [`e84f6cb`](https://github.com/synfig/synfig/commit/e84f6cb328a2fce8fbb7bde1bbcc4227aefbfac9) [Synfig Studio] remove unused headers ([#1911](https://github.com/synfig/synfig/issues/1911))
- [`77039da`](https://github.com/synfig/synfig/commit/77039da08eed4197accb3f58b1fdb9fbe12eec4f) [Snap] Added snap for stable release. Fixed snap for git build ([#1897](https://github.com/synfig/synfig/issues/1897))
- [`4aac1b8`](https://github.com/synfig/synfig/commit/4aac1b85c241b3b5b000e7cd82a5139864efbcc2) [Synfig Studio] remove unused headers ([#1907](https://github.com/synfig/synfig/issues/1907)) [studio]
- [`4ed6b79`](https://github.com/synfig/synfig/commit/4ed6b79edc201011e7fa2aefc78f78c1db95caf0) [Synfig Studio] remove unused headers ([#1906](https://github.com/synfig/synfig/issues/1906)) [studio]
- [`bc33af8`](https://github.com/synfig/synfig/commit/bc33af859718feb026d064daa3db118313cad818) Merge PR [#1894](https://github.com/synfig/synfig/issues/1894): Minor cleanup for Dials [studio]
- [`cadeed3`](https://github.com/synfig/synfig/commit/cadeed3e2812fbb63158515db7d84f261ed8be7e) [Synfig Studio] Added ability to select available Sets when adding Layers to Sets ([#1878](https://github.com/synfig/synfig/issues/1878)) [studio]
- [`0febc74`](https://github.com/synfig/synfig/commit/0febc749210a7611880afd3139701455d04bdd3c) [Synfig Studio] Added extended information about possible errors in ValueDescCreateChildBone ([#1892](https://github.com/synfig/synfig/issues/1892)) [studio]
- [`05181f8`](https://github.com/synfig/synfig/commit/05181f850b9ca959e8d39b43a1d5902b781bbba4) [Synfig Studio] Removed unused headers ([#1893](https://github.com/synfig/synfig/issues/1893)) [studio]
- [`5276fd4`](https://github.com/synfig/synfig/commit/5276fd448f58878564aa75e10076ae0feedbf0d9) Updated README.md ([#1891](https://github.com/synfig/synfig/issues/1891))
- [`95dea12`](https://github.com/synfig/synfig/commit/95dea12eca788eba8323f9fb0c59a839ac3213d1) [Autotools] Added missing synfig_export.h file ([#1886](https://github.com/synfig/synfig/issues/1886)) [core]
- [`a623aac`](https://github.com/synfig/synfig/commit/a623aac9f456e078a53efe08b61a361f10ffe7a4) [CMake] Fixed incorrect MINGW_PREFIX path suggested in error message ([#1883](https://github.com/synfig/synfig/issues/1883))
- [`dd3dcd6`](https://github.com/synfig/synfig/commit/dd3dcd6ca133f9124063a812b7fb65956be5e15e) [Synfig Studio] Eyedropper tool: Added ability to select fill color using Ctrl+click ([#1872](https://github.com/synfig/synfig/issues/1872)) [studio]
- [`d254d74`](https://github.com/synfig/synfig/commit/d254d747bd2d3cb0bbf20a854247736a5af92dfa) Updated README.md ([#1884](https://github.com/synfig/synfig/issues/1884))
- [`5156403`](https://github.com/synfig/synfig/commit/5156403d193864c9afb76c24326f56c509ea9e15) Center vertically empty tool options label ([#1879](https://github.com/synfig/synfig/issues/1879)) [studio]
- [`bbb2dd7`](https://github.com/synfig/synfig/commit/bbb2dd7c274785398d7f46475175053a9a7d9bf0) [Synfig Studio] Removed some unused headers ([#1863](https://github.com/synfig/synfig/issues/1863)) [studio]
- [`3f90ae2`](https://github.com/synfig/synfig/commit/3f90ae2b9b16692e547335e0bd913b14e94b882a) Moving `ui` folder to `resources` folder ([#1865](https://github.com/synfig/synfig/issues/1865)) [studio]
- [`d80d64c`](https://github.com/synfig/synfig/commit/d80d64cc09c7f5f405da6686fd564704841a014e) Removed old CVS ID field from layers, importers, ([#1792](https://github.com/synfig/synfig/issues/1792)) [core] [studio]
- [`f41490a`](https://github.com/synfig/synfig/commit/f41490ac58de26500dabbe7097c2cde2b8bd3a7e) Fixed build on GitHub Actions (MacOS 11) ([#1870](https://github.com/synfig/synfig/issues/1870)) [studio]
- [`684dfa5`](https://github.com/synfig/synfig/commit/684dfa5744866bfe8fce12bdb0cf5a3eb513aa68) Fix GitHub actions ([#1867](https://github.com/synfig/synfig/issues/1867))
- [`32af8ad`](https://github.com/synfig/synfig/commit/32af8adf9bf20eee5faa8d4a1c8336d07c9249c5) [CI] Added GitHub Actions ([#1866](https://github.com/synfig/synfig/issues/1866))
- [`520d972`](https://github.com/synfig/synfig/commit/520d9721a9d28243f8d2ba2efce4c4178a8ecf9a) [CI] Disabled macOS builds on Travis-CI ([#1864](https://github.com/synfig/synfig/issues/1864))
- [`a1e4a17`](https://github.com/synfig/synfig/commit/a1e4a17a042fb648eea5719ca89fb612182151ec) Minor cleanup in WorkArea Renderers ([#1862](https://github.com/synfig/synfig/issues/1862)) [studio]
- [`24e6f86`](https://github.com/synfig/synfig/commit/24e6f868d63b1bbc8f37d0905b7f5c6ebdbe99c4) Removed unused `ETL/stringf` headers. Preparing to move stringf from ETL to core. ([#1856](https://github.com/synfig/synfig/issues/1856)) [core] [studio]
- [`1b9ec56`](https://github.com/synfig/synfig/commit/1b9ec56dd3234ae403cacc908a5692e45f4b1497) Fixed OpenGL build. But it still doesn't render :( ([#1845](https://github.com/synfig/synfig/issues/1845)) [core]
- [`3d32977`](https://github.com/synfig/synfig/commit/3d329775ff210eea3b5ce390485654e472bf1bc1) Merge PR [#1445](https://github.com/synfig/synfig/issues/1445): Restore Defaults is applied only on OK pressed [studio]
- [`05c760f`](https://github.com/synfig/synfig/commit/05c760f4506b42659e4aba0b3364c0e36159b677) Fix regression: didn't load font with relative path ([#1833](https://github.com/synfig/synfig/issues/1833)) [core]
- [`5e3a087`](https://github.com/synfig/synfig/commit/5e3a087dd7e28ebf6dab4ce4b60a315562da1e1b) Add double quotes and option when ID_LIKE=ubuntu debian in PopOS ([#1858](https://github.com/synfig/synfig/issues/1858))
- [`bac00ea`](https://github.com/synfig/synfig/commit/bac00ea77cc0c318e22a85da266ea5e6e097e952) [ETL] Removed `etl::trivial` class. Refactored `Param` class. ([#1839](https://github.com/synfig/synfig/issues/1839)) [ETL] [studio]
- [`67c3f77`](https://github.com/synfig/synfig/commit/67c3f77828ce2bdd26472bbc7ca11e8ac98f1533) Limit background rendering to playback bounds ([#1852](https://github.com/synfig/synfig/issues/1852)) [studio]
- [`ebf2eea`](https://github.com/synfig/synfig/commit/ebf2eeac25a9f2b73920569e646bd959bf82002b) Merge PR [#1844](https://github.com/synfig/synfig/issues/1844):  Fix doxygen [ETL] [core] [studio]
- [`ebc4b31`](https://github.com/synfig/synfig/commit/ebc4b316373368b3254d9736c32703b155b764cb) [CMake] Added CFLAGS from MagickCore to mod_magickpp (fixes build on some OS) ([#1819](https://github.com/synfig/synfig/issues/1819)) [core]
- [`d4eb1dc`](https://github.com/synfig/synfig/commit/d4eb1dc212b123e4b366588a471706cf4cd76cc1) OptionsProcessor small cleanup ([#1831](https://github.com/synfig/synfig/issues/1831)) [core]
- [`dbde6c6`](https://github.com/synfig/synfig/commit/dbde6c6f34d621b9d4a1b81d88cefe0a10479c1c) Fix regression: Text layer accepts font filename again ([#1828](https://github.com/synfig/synfig/issues/1828)) [core]
- [`5a9d9ab`](https://github.com/synfig/synfig/commit/5a9d9abd07576caddbe645c8ed1d480b452045b3) Update link to build ([#1824](https://github.com/synfig/synfig/issues/1824))
- [`5b37e43`](https://github.com/synfig/synfig/commit/5b37e43f9cccf160c7424d8a94a71206e2e5e657) Fixed clang warnings (unused variables, reorder) ([#1822](https://github.com/synfig/synfig/issues/1822)) [core] [studio]
- [`7832633`](https://github.com/synfig/synfig/commit/7832633f8fe3069e5d83be9bebe0e3258d2f1f93) Merge PR [#1810](https://github.com/synfig/synfig/issues/1810): Delete ColorAccumulator [core]
- [`677c1a7`](https://github.com/synfig/synfig/commit/677c1a78fc26933d1531daef105d9b92c7c3dd52) [Autotools] Verbose mode is disabled by default ([#1815](https://github.com/synfig/synfig/issues/1815)) [ETL] [core] [studio]
- [`2a5d837`](https://github.com/synfig/synfig/commit/2a5d8371ef5c95fb4a3fb7fbc2e96a01d5bb89a5) Migrate old containers from widget classes to new containers. Table->Grid ([#1816](https://github.com/synfig/synfig/issues/1816)) [studio]
- [`8e712de`](https://github.com/synfig/synfig/commit/8e712deee58f4750161088b5cfc90e1c3364a5ed) Don't hold layer selection for Draw Tool ([#1812](https://github.com/synfig/synfig/issues/1812)) [studio]
- [`dd2d919`](https://github.com/synfig/synfig/commit/dd2d919f617e01eef993b2551e38c4b948eb63b4) Added ability to stylize Synfig using a CSS file ([#1789](https://github.com/synfig/synfig/issues/1789)) [studio]
- [`1d1c166`](https://github.com/synfig/synfig/commit/1d1c1660a077d3e50ffd7671c27b8f7855d89f07) [Skeleton Tool] Fixed console warning when adding bone with a parent (PR [#1695](https://github.com/synfig/synfig/issues/1695)) [studio]
- [`def5ae0`](https://github.com/synfig/synfig/commit/def5ae02c649f0cd808ecbbf5d1b26069ac4cbf7) [MSYS/MLT] Disabled lumas module. Greatly reduces Windows installer size. ([#1801](https://github.com/synfig/synfig/issues/1801))
- [`31516f4`](https://github.com/synfig/synfig/commit/31516f4ec6788335749d80b1662b0664e41d69a7) [CMake] Added FontConfig support to Synfig Studio build ([#1799](https://github.com/synfig/synfig/issues/1799)) [studio]
- [`9664b8c`](https://github.com/synfig/synfig/commit/9664b8c8273d36335bb3ed2d7c6c01cc9d0a9a96) [Skeleton Tool] Second bone follows first bone (PR [#1698](https://github.com/synfig/synfig/issues/1698)) [studio]
- [`5a28c15`](https://github.com/synfig/synfig/commit/5a28c1593cb36bd94c76eea19a576db670c220a0) Merge PR [#1797](https://github.com/synfig/synfig/issues/1797): [MSVC] Added export variables [core] [studio]
- [`7449118`](https://github.com/synfig/synfig/commit/744911808afe2b0f86bf2a3a9f103d04a1553318) [MSYS/CMake] Fix hard-coded path (c:/msys64/usr/bin/perl) ([#1795](https://github.com/synfig/synfig/issues/1795))
- [`144524a`](https://github.com/synfig/synfig/commit/144524a50d25bfd1b4bfdd43824bf7e3d972367e) Merge PR [#1791](https://github.com/synfig/synfig/issues/1791): Remove some old CVS/SVN stuff [ETL] [core] [studio]
- [`4b50b78`](https://github.com/synfig/synfig/commit/4b50b782d1f063b41d0e3107fee5cac655757812) [#1722](https://github.com/synfig/synfig/issues/1722): Set modal property on AboutDialog ([#1788](https://github.com/synfig/synfig/issues/1788)) [studio]
- [`581535b`](https://github.com/synfig/synfig/commit/581535b971875e100bd715bf00b8725359e6bd46) Merge PR [#1783](https://github.com/synfig/synfig/issues/1783): MSVC build improvements [#2](https://github.com/synfig/synfig/issues/2) [core] [studio]
- [`b01d549`](https://github.com/synfig/synfig/commit/b01d549b87f4ae118a792cf1f40304e167696cff) Merge PR [#1781](https://github.com/synfig/synfig/issues/1781): MSVC build improvements [ETL] [core] [studio]
- [`139da75`](https://github.com/synfig/synfig/commit/139da756c6c39bda8a34a8d375fa11a49b87ac5a) Resolve misleading indentation warning ([#1780](https://github.com/synfig/synfig/issues/1780)) [studio]
- [`e51bebe`](https://github.com/synfig/synfig/commit/e51bebe7cff64ddef7c114cd749868eba0acf630) Merge PR [#1778](https://github.com/synfig/synfig/issues/1778): Performance improvements [core]
- [`6bd569f`](https://github.com/synfig/synfig/commit/6bd569fced23ddfa1157c307fe8005a813213a30) Add two scripts to aid in performance profiling
- [`0576fa8`](https://github.com/synfig/synfig/commit/0576fa82b92210aacdc9b8ed6d32a3dfbceea9b7) Fixing GCC Wreorder warnings ([#1750](https://github.com/synfig/synfig/issues/1750)) [studio]
- [`6cba5a6`](https://github.com/synfig/synfig/commit/6cba5a65be4a6dac6a8a87ba756f2ea196b06631) Merge PR [#1774](https://github.com/synfig/synfig/issues/1774): Replaced gtk::HBox and gtk::VBox with gtk::Grid in synfig-studio CanvasView [studio]
- [`8b31696`](https://github.com/synfig/synfig/commit/8b31696ad26fa9f1139506c36e424aeb354147c6) Fix whitespace indentation in duckmatic.cpp ([#1773](https://github.com/synfig/synfig/issues/1773)) [studio]
- [`044390e`](https://github.com/synfig/synfig/commit/044390e07476da87d0d957eb7b9770bc7d618f42) Merge PR [#1772](https://github.com/synfig/synfig/issues/1772): Various fixes for MSVC [core]
- [`37fe404`](https://github.com/synfig/synfig/commit/37fe4048f2b412865b1fe21e68b4e30143f8186a) [CMake] Fixed incomplete information in About dialog ([#1770](https://github.com/synfig/synfig/issues/1770)) [core] [studio]
- [`30f6878`](https://github.com/synfig/synfig/commit/30f687850e3766f9b4251e100ffbc604b3209657) Add braces to avoid ambiguous else on extractBorders. Fixes [-Wdangling-else] warning ([#1771](https://github.com/synfig/synfig/issues/1771)) [studio]
- [`5d0abc1`](https://github.com/synfig/synfig/commit/5d0abc1f718ad67469afb0252a9ce42a946cabf3) Fixed wrong documented comment (FrameDial=>JackDial) [studio]
- [`c48f248`](https://github.com/synfig/synfig/commit/c48f248795f091f2bc06405f3c87d00931dbe88e) Fix GCC multi-line comment warning (-wcomment) ([#1759](https://github.com/synfig/synfig/issues/1759)) [studio]
- [`dfcfdf9`](https://github.com/synfig/synfig/commit/dfcfdf9fc94953d10562d0fd01d2a83039538068) Don't search for linux paths on Windows for synfig_modules.cfg ([#1758](https://github.com/synfig/synfig/issues/1758)) [core]
- [`cde6d0a`](https://github.com/synfig/synfig/commit/cde6d0a960a6bee84473fddcaa425fe6c67c9d64) Removed warning message if config file (synfig_modules.cfg) is found ([#1751](https://github.com/synfig/synfig/issues/1751)) [core]
- [`edce8cc`](https://github.com/synfig/synfig/commit/edce8cc811ff8a58bc3a30cdd72aca846b814128) Adding QtCreator projects to .gitignore ([#1753](https://github.com/synfig/synfig/issues/1753))
- [`0450390`](https://github.com/synfig/synfig/commit/045039035ffc3c54c21f29d1c14957f4a47e1808) Merge PR [#1746](https://github.com/synfig/synfig/issues/1746): MSVC/vcpkg improving [ETL] [core]
- [`b377a11`](https://github.com/synfig/synfig/commit/b377a11865a0fc6a671e536e93e0f65efede8003) [Autotools] Make autotools use imagemagick++ cflags from pkg-config ([#1600](https://github.com/synfig/synfig/issues/1600)) [core]
- [`a59e482`](https://github.com/synfig/synfig/commit/a59e48275d631876243634e4879899e48b793e68) Merge PR [#1741](https://github.com/synfig/synfig/issues/1741): Fixed clang warnings [ETL] [core]
- [`65d47b3`](https://github.com/synfig/synfig/commit/65d47b33fc8672a638b42115e04a324a133d82de) Fixed GCC warnings (different signedness comparison) ([#1739](https://github.com/synfig/synfig/issues/1739)) [studio]
- [`60dc5b6`](https://github.com/synfig/synfig/commit/60dc5b6b29c215e73c38bd3da4d2884696faf49e) Remove unused headers (should reduce build time) ([#1740](https://github.com/synfig/synfig/issues/1740)) [core] [studio]
- [`08c13e7`](https://github.com/synfig/synfig/commit/08c13e738639ffd31988afef84cb56a213f0367f) Merge PR [#1737](https://github.com/synfig/synfig/issues/1737):  [Appveyor] Added artifacts build
- [`75f78f2`](https://github.com/synfig/synfig/commit/75f78f249e76c70453c992f5795908979f8dd40d) Removed unused headers ([#1729](https://github.com/synfig/synfig/issues/1729)) [ETL] [core] [studio]
- [`306f756`](https://github.com/synfig/synfig/commit/306f7562b2b5e29524647698c5a40918333bce2f) [CMake] Fixed MSYS2 installer (removed unnecessary folders, required folders added) ([#1728](https://github.com/synfig/synfig/issues/1728)) [studio]
- [`fa78a4d`](https://github.com/synfig/synfig/commit/fa78a4df4f991b039cfe67c6530c377a8713db6b) [Appveyor] Switched to Release build (increase link speed, decrease size) ([#1727](https://github.com/synfig/synfig/issues/1727))
- [`43019c6`](https://github.com/synfig/synfig/commit/43019c68d71882b643b0d22bde257f7a19b5aea1) Corrected keyframe tooltip position for Wayland ([#1725](https://github.com/synfig/synfig/issues/1725)) [studio]
- [`7268fc8`](https://github.com/synfig/synfig/commit/7268fc8009f10265fc4ebfcf856def876400246f) Corrected thumbnail position for Wayland ([#1726](https://github.com/synfig/synfig/issues/1726)) [studio]
- [`41fda6c`](https://github.com/synfig/synfig/commit/41fda6cf928e46e6ac3915d74ffdd599842afa6b) Merge PR [#1711](https://github.com/synfig/synfig/issues/1711): CMake improvements [studio]
- [`9d39d47`](https://github.com/synfig/synfig/commit/9d39d478857bc81ec1fafdc3cc04a234c4975b25) Merge PR [#1696](https://github.com/synfig/synfig/issues/1696): [Skeleton Tool] Fix crash when editing control point. Closes 1685. [studio]
- [`153579a`](https://github.com/synfig/synfig/commit/153579a76901ae9dc8995177716dd56a7db66505) [CMake] Improved intltool-merge search, fixed warning if not found ([#1709](https://github.com/synfig/synfig/issues/1709))
- [`adaac77`](https://github.com/synfig/synfig/commit/adaac77070225cea746626760ae8425c28899287) Don't hold layers selection when creating a new layer ([#1699](https://github.com/synfig/synfig/issues/1699)) [studio]
- [`f1d830a`](https://github.com/synfig/synfig/commit/f1d830afc790f775fc020a78383adaaa7ebfe8e6) Fixed: Order by Name has no effect in Parameters Panel ([#1703](https://github.com/synfig/synfig/issues/1703)) [studio]
- [`88e56d2`](https://github.com/synfig/synfig/commit/88e56d2379a70b5a4ffec8f4fa16a7becd3867c4) [Appveyor/MSYS2] Removed set_env.sh script. All variables replaced by native MSYS2 environment variables. ([#1693](https://github.com/synfig/synfig/issues/1693))
- [`e7441e4`](https://github.com/synfig/synfig/commit/e7441e4efba0c8f70fa63b67ad9771278a8356a3) [CMake] Fixed path for splash screen image and added Adwaita icons for MSYS2 builds. ([#1689](https://github.com/synfig/synfig/issues/1689)) [studio]
- [`9f1362c`](https://github.com/synfig/synfig/commit/9f1362c72392080df90a25231422054db2e9ee11) [Skeleton Tool] Fix for [#1680](https://github.com/synfig/synfig/issues/1680): Can't load saved file that has layers made with skeleton tool ([#1681](https://github.com/synfig/synfig/issues/1681)) [studio]
- [`2124e6a`](https://github.com/synfig/synfig/commit/2124e6aa8ca7ebf6371ed8a92a84cdcaa812ad70) [Skeleton Tool] Fixed crash when switching to Skeleton Tool ([#1684](https://github.com/synfig/synfig/issues/1684)) [studio]
- [`2b8ea4d`](https://github.com/synfig/synfig/commit/2b8ea4dff492cba62f5df026a8b04c19ba40da36) [Lottie Exporter] Export outlines without variable widths ([#1647](https://github.com/synfig/synfig/issues/1647)) (shipped in 1.4.2, but UI was not available) [studio]
- [`e6c62c2`](https://github.com/synfig/synfig/commit/e6c62c2e2c4871ee2c916388e6f70c2ae8173288) Add Visual Studio Code configuration for debugging on Linux ([#1682](https://github.com/synfig/synfig/issues/1682))
- [`4906e91`](https://github.com/synfig/synfig/commit/4906e9188f025ab31d17d46500f277080853f2f6) [Skeleton Tool] Synfig crashes when we try to edit any other duck other than a bone's ([#1679](https://github.com/synfig/synfig/issues/1679)) [studio]
- [`08893ed`](https://github.com/synfig/synfig/commit/08893ed697f5a79af90ee26f948affee3483b370) All enabled modules added as a dependency for synfig_bin. ([#1677](https://github.com/synfig/synfig/issues/1677)) [core]
- [`3d14739`](https://github.com/synfig/synfig/commit/3d147391b22e871f8e7f8b85d002ea5b52500dcd) [Skeleton Tool] Rename 'Make parent to active bone' ([#1676](https://github.com/synfig/synfig/issues/1676)). Closes [#1673](https://github.com/synfig/synfig/issues/1673). [studio]
- [`afb5d3c`](https://github.com/synfig/synfig/commit/afb5d3cfb0782ada635d61f36d245722e7a7d769) Added proper Clang info to About dialog ([#1675](https://github.com/synfig/synfig/issues/1675)) [studio]
- [`6385086`](https://github.com/synfig/synfig/commit/63850863f68f56e85bed296fbddc8a12a6e9e042) Fixed unused/redefined variables warnings ([#1672](https://github.com/synfig/synfig/issues/1672)) [core] [studio]
- [`d345097`](https://github.com/synfig/synfig/commit/d345097c64e0975132035b7aade09081bb7b53ee) [Skeleton Tool] Fixed 'Make parent to active bone' crash ([#1671](https://github.com/synfig/synfig/issues/1671)). Closes [#1670](https://github.com/synfig/synfig/issues/1670). [studio]
- [`8cd3084`](https://github.com/synfig/synfig/commit/8cd3084e7e4f1f6dfade4c8bf5ea307f63793f2e) [CMake] Added basic support for MSVS 2019 and vcpkg ([#1646](https://github.com/synfig/synfig/issues/1646)) [core] [studio]
- [`c7737d6`](https://github.com/synfig/synfig/commit/c7737d6dba84eafe6cf59a7c23615eb08c9337c7) [Skeleton Tool] Remove "Create Child Bone" action menu ([#1663](https://github.com/synfig/synfig/issues/1663)) [studio]
- [`bfe6612`](https://github.com/synfig/synfig/commit/bfe6612cb35a2264d225c543f56c6259bab88170) Fixed warnings 'format '%lx' expects argument of type...' ([#1668](https://github.com/synfig/synfig/issues/1668)) [core]
- [`61d81cb`](https://github.com/synfig/synfig/commit/61d81cb74db228c042e2c0e4114fddf7f585f3cf) [Skeleton Tool] Fixed active bone setting while pressed on Duck ([#1662](https://github.com/synfig/synfig/issues/1662)). Closes [#1656](https://github.com/synfig/synfig/issues/1656). [studio]
- [`7a9a116`](https://github.com/synfig/synfig/commit/7a9a116b90afe65751c64e0a38e26969ef867b9d) Speed up Layer_Freetype: don't load face file on every rendering ([#1655](https://github.com/synfig/synfig/issues/1655)) [core]
- [`bb1a80b`](https://github.com/synfig/synfig/commit/bb1a80b67738c0a581768219fb7ee7dfd4a4782a) Merge PR [#1653](https://github.com/synfig/synfig/issues/1653): Layer FreeType code cleanup [core]
- [`617fd4b`](https://github.com/synfig/synfig/commit/617fd4b7dbda9bdf0b7543eafcd9cba71a37505b) [CMake] Fixed FontConfig detection [core]
- [`51d7972`](https://github.com/synfig/synfig/commit/51d797231a04c06d781491ba2bffe5766f99a522) Fixed 'Error: Broken pipe' message, when installing brew packages on MacOS ([#1659](https://github.com/synfig/synfig/issues/1659))
- [`14ca537`](https://github.com/synfig/synfig/commit/14ca5370be1aba5887cbcce114009fb02c72ffc1) Fixed memory leak when destroying ThreadPool ([#1651](https://github.com/synfig/synfig/issues/1651)) [core]
- [`db77ed1`](https://github.com/synfig/synfig/commit/db77ed10b3c8a15aa07d69f1d31ea8fa6bc587c6) Fixed memory leak with Widget_Timetrack: row_info now stored by value instead of pointer ([#1652](https://github.com/synfig/synfig/issues/1652)) [studio]
- [`0b210b5`](https://github.com/synfig/synfig/commit/0b210b5862669115295580007ed2a428203df4be) Skeleton tool: Use single parameter to define bone width ([#1604](https://github.com/synfig/synfig/issues/1604)) [studio]
- [`a480643`](https://github.com/synfig/synfig/commit/a480643a5953fd193d4a82f9bec2b314348bd068) [Skeleton Tool] Do not switch to Arrow tool when user selects other layer ([#1618](https://github.com/synfig/synfig/issues/1618)). Closes [#1603](https://github.com/synfig/synfig/issues/1603). [studio]
- [`d8388ca`](https://github.com/synfig/synfig/commit/d8388cabf95fefa21d6d950798a58b841dc3b652) Make position of dialog buttons consistent ([#1638](https://github.com/synfig/synfig/issues/1638)) [studio]
- [`f604e21`](https://github.com/synfig/synfig/commit/f604e21423d517af9df49470c44bc321f0916108) Removed README-CMake.md and linked CMake documentation in README.md ([#1644](https://github.com/synfig/synfig/issues/1644))
- [`d58e958`](https://github.com/synfig/synfig/commit/d58e95803a06560fd5529211c3b7b1bbcba4fa91) Fix usage of locale_from_utf8() instead locale_to_utf8() ([#1642](https://github.com/synfig/synfig/issues/1642)) [studio]
- [`c3bd657`](https://github.com/synfig/synfig/commit/c3bd65788e3807a8ed3840666b909bf67a0f5fd0) Merge PR [#1507](https://github.com/synfig/synfig/issues/1507): Added "Scale to fit canvas" button to Import dialog [studio]
- [`2beffbe`](https://github.com/synfig/synfig/commit/2beffbeb8918309ded223e4be97bc56ce7c928bd) [Skeleton Tool] Fixed bone placement in Skeleton Deformation ([#1641](https://github.com/synfig/synfig/issues/1641)) [studio]
- [`9880e14`](https://github.com/synfig/synfig/commit/9880e148c54c6073368cc0a79c6338dd5f923c40) Update POTFILES.in ([#1640](https://github.com/synfig/synfig/issues/1640)) [studio]
- [`6a91825`](https://github.com/synfig/synfig/commit/6a91825bf8a817c8fd7c1ffcdd1c8836331ba288) Configuration for Visual Studio Code on Windows ([#1639](https://github.com/synfig/synfig/issues/1639))
- [`723e88d`](https://github.com/synfig/synfig/commit/723e88d40fc4d3cc3acf1053f8f2235bb6e64e3a) [Skeleton Tool] Conditional disable/enable of Deformation layer on tool switch ([#1635](https://github.com/synfig/synfig/issues/1635)) [studio]
- [`85aed48`](https://github.com/synfig/synfig/commit/85aed489ed967149c09dce14c7c76d9c0f01fd79) [Skeleton Tool] Creating new Skeleton layer without a bone ([#1620](https://github.com/synfig/synfig/issues/1620)) [studio]
- [`09d6069`](https://github.com/synfig/synfig/commit/09d60691618fbae84ad6384dab655ae95b63c004) Do not use Glib::locale_to_utf8() in synfig::get_binary_path() ([#1633](https://github.com/synfig/synfig/issues/1633)) [core]
- [`ef6be78`](https://github.com/synfig/synfig/commit/ef6be78878a288e4e2729695bb3f8cfb1a3312e2) Windows build: Enable avformat module in MLT
- [`e78053d`](https://github.com/synfig/synfig/commit/e78053d4c292c2d24b6f5d6773359fba8feac0b8) Avoid double "Loading modules" message ([#1631](https://github.com/synfig/synfig/issues/1631)) [core]
- [`4e0e245`](https://github.com/synfig/synfig/commit/4e0e245c51da09b634093f32d275d5b81e3e10cc) Skeleton Tool: Trigger visibility of Width Points depending on conditions ([#1616](https://github.com/synfig/synfig/issues/1616)) [studio]
- [`0485671`](https://github.com/synfig/synfig/commit/048567137d1235fd4f46754adb6f126d0c1a3eb4) CMake NSIS Installer ([#1582](https://github.com/synfig/synfig/issues/1582)) [studio]
- [`b92a370`](https://github.com/synfig/synfig/commit/b92a3708db735f18c45534066fe158c960978a35) Skeleton Tool: Fixed Skeleton Deformation layer Highlighting ([#1628](https://github.com/synfig/synfig/issues/1628)) [studio]
- [`8d27d97`](https://github.com/synfig/synfig/commit/8d27d97bfd709cecd5f52ca77b5693fac338df43) Added button to stop rendering process ([#1585](https://github.com/synfig/synfig/issues/1585)) [studio]
- [`f89c807`](https://github.com/synfig/synfig/commit/f89c8079d407f5863f4f3ddf76bff37f36b6fb72) Merge PR [#1622](https://github.com/synfig/synfig/issues/1622): Freetype: avoid unneeded font search [core]
- [`161fd5b`](https://github.com/synfig/synfig/commit/161fd5b5f2f3294a6537d1e287002cf60bc84384) Canvas end-time could be set by wrong reason ([#1614](https://github.com/synfig/synfig/issues/1614)) [core]
- [`8cece27`](https://github.com/synfig/synfig/commit/8cece276ec0891f3573a4975a1ab1d444e5b3985) Merge PR [#1617](https://github.com/synfig/synfig/issues/1617): Skeleton Tool - Skeleton Deformation Layer created as "disabled". Closes [#1615](https://github.com/synfig/synfig/issues/1615). [studio]
- [`e02a3a8`](https://github.com/synfig/synfig/commit/e02a3a8c944fbd3731c6486de9ecd2eea73f597d) Removed old (2005) simple hack for gcc < 4.1.2 bugged warning ([#1613](https://github.com/synfig/synfig/issues/1613)) [core]
- [`80d63a7`](https://github.com/synfig/synfig/commit/80d63a75ee19b63272b0b9f2e69cf850debd8eed) Merge PR [#1611](https://github.com/synfig/synfig/issues/1611): Skeleton Tool - Fixed Active Bone rendering. Closes [#1610](https://github.com/synfig/synfig/issues/1610). [studio]
- [`554eaea`](https://github.com/synfig/synfig/commit/554eaea80d10eee130468fa7eedd286a3a5d01fd) Proper MSYS detection, also fixes MacOS "uname -o" illegal option error. ([#1612](https://github.com/synfig/synfig/issues/1612))
- [`28422b8`](https://github.com/synfig/synfig/commit/28422b8505dfaf47487e1e9f7730163f20a58f05) Merge PR [#1605](https://github.com/synfig/synfig/issues/1605): Skeleton Tool - Use dashed outline to show parent-child relationships for bones [studio]
- [`0948ac4`](https://github.com/synfig/synfig/commit/0948ac4b5883d4d10563a98fd0b38459ff7b6a38) GSoC 2020: Skeleton tool - basic implementation ([#1485](https://github.com/synfig/synfig/issues/1485)) [studio]
- [`bcc84f1`](https://github.com/synfig/synfig/commit/bcc84f1c47090ff1dbb4eccc8e05231754195a57) [CMake] Icon and program info integrated into synfigstudio.exe Windows binary. ([#1581](https://github.com/synfig/synfig/issues/1581)) [studio]
- [`a27993c`](https://github.com/synfig/synfig/commit/a27993cb52075a433a175b59789dbd8e59ace20d) Disabled ImageMagick for OSX >= 10.13 (Fixes OSX High Sierra, Mojave and Catalina build) ([#1486](https://github.com/synfig/synfig/issues/1486))
- [`d23807e`](https://github.com/synfig/synfig/commit/d23807e2e2e8278f2434bc4c66dbe12d090a5299) Fixed libmng linking problem on 32-bit platform ([#1598](https://github.com/synfig/synfig/issues/1598)) [core]
- [`6d3f1cb`](https://github.com/synfig/synfig/commit/6d3f1cb89cce05cb95341b38284b537975935a50) Merge PR [#1596](https://github.com/synfig/synfig/issues/1596): Fixed warnings [ETL] [core] [studio]
- [`357dda4`](https://github.com/synfig/synfig/commit/357dda4d5988316a9dfbf12fbca158ba93764e85) Merge PR [#1595](https://github.com/synfig/synfig/issues/1595): Fixed Magick NoEncodeDelegateForThisImageFormat issues on appveyor build.
- [`5fe1258`](https://github.com/synfig/synfig/commit/5fe125846e4e5bdd8702eda3bbcb30089f0340ec) MergePR [#1491](https://github.com/synfig/synfig/issues/1491): Changes for Appveyor build using CMake and ninja. [core] [studio]
- [`7ebb19b`](https://github.com/synfig/synfig/commit/7ebb19b0b2cf693a756feeeb670943cc7dc7cc8f) don't crash debug version when rotating vertex order ([#1583](https://github.com/synfig/synfig/issues/1583)) [studio]
- [`8b93aa1`](https://github.com/synfig/synfig/commit/8b93aa1c2baf37ca687010c617db988632df79fb) Merge PR [#1432](https://github.com/synfig/synfig/issues/1432): Fixed text layer family search and allow user selection [core] [studio]
- [`bad6e68`](https://github.com/synfig/synfig/commit/bad6e688072b8d430792a5a8d4d66cf84a557c45) Improved documentation of exception_guard.h ([#1578](https://github.com/synfig/synfig/issues/1578)) [studio]
- [`7ece93c`](https://github.com/synfig/synfig/commit/7ece93c86ea09475ea123fda59a02e588f3c5997) Merge PR [#1571](https://github.com/synfig/synfig/issues/1571): fix uncaught exceptions in destructors [studio]
- [`2b0a887`](https://github.com/synfig/synfig/commit/2b0a8874afafb0881a466e595d99cad74d2fafdd) Merge PR [#1413](https://github.com/synfig/synfig/issues/1413): Added toggleable option for thumbnail preview [studio]
- [`6e9e095`](https://github.com/synfig/synfig/commit/6e9e095c5b4c3beb203b49c2bd0d416a6b9f6e59) Fixed crash when user deletes the sound layer displayed in Sound panel ([#1564](https://github.com/synfig/synfig/issues/1564)) [studio]
- [`dc3c31e`](https://github.com/synfig/synfig/commit/dc3c31e7f85f1b46dee27805ec6a01c8ac1680e2) Removed unused ETL spline header ([#1563](https://github.com/synfig/synfig/issues/1563)) [ETL] [core]
- [`a74530f`](https://github.com/synfig/synfig/commit/a74530f8ed068502a6940ade6efa6d57afe943fa) Remove ancient 3rd party sources (gtkmm-osx) ([#1554](https://github.com/synfig/synfig/issues/1554))
- [`acde8c3`](https://github.com/synfig/synfig/commit/acde8c3a7d81b52716598fa6eadc8ae6fb68b312) [CMake] CPack added ability to generate .deb package ([#1519](https://github.com/synfig/synfig/issues/1519)) [core] [studio]
- [`978905c`](https://github.com/synfig/synfig/commit/978905c8facd6d084baec50c545fad72372ca8e5) [CMake] Fixed MacOS build ([#1534](https://github.com/synfig/synfig/issues/1534)) [core] [studio]
- [`d82b5ae`](https://github.com/synfig/synfig/commit/d82b5aeab7df3fb5b183d442affa8ecf5f7ce3e5) [Vectorization] Bezier enhance ([#1240](https://github.com/synfig/synfig/issues/1240)) [studio]
- [`dec2884`](https://github.com/synfig/synfig/commit/dec28849cbb304ca58fe31efc764799b41460d85) Cleanup module.h ([#1530](https://github.com/synfig/synfig/issues/1530)) [core]
- [`99981e8`](https://github.com/synfig/synfig/commit/99981e8cfdf07c9f4485e8076d8d7323ccdd221e) don't re-add the first brush path to brush path list ! [studio]
- [`f538260`](https://github.com/synfig/synfig/commit/f538260216b4268cb61302f624e05d358e353f5d) Brush paths moved to ResourceHelpre ([#1528](https://github.com/synfig/synfig/issues/1528)) [studio]
- [`fb84c92`](https://github.com/synfig/synfig/commit/fb84c922518ecd6a0e5c49fb7a2657cb39b559a5) [CMake] Copy logo.sif to build-dir for building splash_screen ([#1525](https://github.com/synfig/synfig/issues/1525)) [studio]
- [`4aab731`](https://github.com/synfig/synfig/commit/4aab7317323adb9aeb7a7e78e1e30a9ca00991e2) Fixed Arch linux detection ([#1521](https://github.com/synfig/synfig/issues/1521))
- [`2af6b11`](https://github.com/synfig/synfig/commit/2af6b11f8e30efce45a7d67c3a470702305330c8) Cleanup general.h ([#1526](https://github.com/synfig/synfig/issues/1526)) [core] [studio]
- [`97940e9`](https://github.com/synfig/synfig/commit/97940e960d81b7fd02c070bfd1d1416e5ab96b39) Cleanup module.cpp a bit ([#1418](https://github.com/synfig/synfig/issues/1418)) [core]
- [`5862c76`](https://github.com/synfig/synfig/commit/5862c7611232cb180d8eb2934b17b2f306404f10) ThreadPool: prefer std::mutex and std::condition_variable ([#1036](https://github.com/synfig/synfig/issues/1036)) [core]
- [`2fb1e65`](https://github.com/synfig/synfig/commit/2fb1e659f70ede5ba97ff149efdb2b352680a5b1) Copy plugins, brushes and sounds to the appropriate place in CMake build. ([#1501](https://github.com/synfig/synfig/issues/1501)) [studio]
- [`15080f9`](https://github.com/synfig/synfig/commit/15080f98a5fb3490865d006c2c250f6e316c71a1) Different CMake builds based on CMAKE_BUILD_TYPE. ([#1500](https://github.com/synfig/synfig/issues/1500)) [core] [studio]
- [`0b965c0`](https://github.com/synfig/synfig/commit/0b965c0f2e5acf60ae7bf4e4e1426ae772295974) Avoid deadlock when converting vector to 'dynamic' ([#1073](https://github.com/synfig/synfig/issues/1073)) [studio] 
- [`7d16c26`](https://github.com/synfig/synfig/commit/7d16c263f412873329ef5a495e4a993dc1d57c8f) Edit tooltips for style consistency ([#1514](https://github.com/synfig/synfig/issues/1514)) [core]
- [`2e0b896`](https://github.com/synfig/synfig/commit/2e0b89692ba6a881b79f5bd71b15871bd6acd1a4) Updated CMake icons directory ([#1512](https://github.com/synfig/synfig/issues/1512)) [studio]
- [`13dab06`](https://github.com/synfig/synfig/commit/13dab0681156014e7c0c84db0e6750c284decfc8) Generate l10n files from .po files. ([#1462](https://github.com/synfig/synfig/issues/1462)) [core] [studio]
- [`2ce6c92`](https://github.com/synfig/synfig/commit/2ce6c92c88dbb039e3d4b2df6df6884f81c63aba) Not using modules/layer_std/import/ but synfig/layers/layer_bitmap for importing sequences [studio]
- [`67b1ab7`](https://github.com/synfig/synfig/commit/67b1ab7fc451c2d201da6bfc6b31083125481537) Make titles and spacings consistent across tool options ([#1369](https://github.com/synfig/synfig/issues/1369)) [studio]
- [`d72bbc9`](https://github.com/synfig/synfig/commit/d72bbc943d6b3205fb86b0e343b451fcfd49f2cc) VLA replaced by std::vector class (fixes MSVC compilation) ([#1474](https://github.com/synfig/synfig/issues/1474)) [core]
- [`5a3f423`](https://github.com/synfig/synfig/commit/5a3f4232224bbf9d3524158682bd7eb0ff7166c7) Use ScrolledWindow and label wrapping for message dialog ([#1496](https://github.com/synfig/synfig/issues/1496)) [core] [studio]
- [`8081eb8`](https://github.com/synfig/synfig/commit/8081eb89d66dfdefb20d3d88ac2fd2e928e882df) Check if target output has same name as existing files ([#1461](https://github.com/synfig/synfig/issues/1461)) [studio]
- [`48ac6ff`](https://github.com/synfig/synfig/commit/48ac6ffa41b74e649f6208b0004005a1e0987830) Resource path changes for CMake build. ([#1484](https://github.com/synfig/synfig/issues/1484)) [studio]
- [`b7884bb`](https://github.com/synfig/synfig/commit/b7884bb9287d546acd7dfdddaabeb91bbf1a54aa) Replace deprecated set_margin method ([#1482](https://github.com/synfig/synfig/issues/1482)) [studio]
- [`5d3056e`](https://github.com/synfig/synfig/commit/5d3056e28e19413136e321b320edfb30c0a56a3f) Merge PR[#1487](https://github.com/synfig/synfig/issues/1487): minor improvements in Info panel [studio]
- [`633d54d`](https://github.com/synfig/synfig/commit/633d54dc90d54f2e78b42160635a5c70f11d16e6) Merge PR [#1483](https://github.com/synfig/synfig/issues/1483): Change installation folder of synfig images and icons [studio]
- [`7ab41fa`](https://github.com/synfig/synfig/commit/7ab41fa0a9bfdcddaecb579e4cf84eafe9e3e803) fix build_images target's rebuilding behavior ([#1478](https://github.com/synfig/synfig/issues/1478)) [studio]
- [`35c3012`](https://github.com/synfig/synfig/commit/35c3012b8e1d57a493a109924f6c04942ad609a9) Merge PR [#1477](https://github.com/synfig/synfig/issues/1477): Simplify access to resource [studio]
- [`b6995dc`](https://github.com/synfig/synfig/commit/b6995dc5864f43239b4e5ac9b119222328af6af1) Add test file for conversion between homogeneous and standard width points ([#1471](https://github.com/synfig/synfig/issues/1471)) [core]
- [`18e6acb`](https://github.com/synfig/synfig/commit/18e6acbf8682e7b4b7f2b3c10fbf9f7e9e6a3324) Update lottie test script
- [`068c884`](https://github.com/synfig/synfig/commit/068c884e8a10638cd625fbd3b42bfc6605eb2f34) Merge PR [#1466](https://github.com/synfig/synfig/issues/1466): fix POTFILES.in [core] [studio]
- [`4c519a9`](https://github.com/synfig/synfig/commit/4c519a9539905788b66101b4b440880949733a6b) Merge PR [#1450](https://github.com/synfig/synfig/issues/1450): Improved warning dialog UI [studio]
- [`6d3f75f`](https://github.com/synfig/synfig/commit/6d3f75ffc8a3450587c8105a738e1b6db79f7956) quick workaround to fix crash in new timetrack ([#1439](https://github.com/synfig/synfig/issues/1439)) [studio]
- [`7684be8`](https://github.com/synfig/synfig/commit/7684be864f20b5cda39dd07833e74e78a874e6d3) Removing Duplicate frames while importing an image sequence [core] [studio]
- [`454ac39`](https://github.com/synfig/synfig/commit/454ac396850dd6ac58360f14039a7419460c4700) REVISION_ID with 7 characters instead of 6 [studio]
- [`e60a668`](https://github.com/synfig/synfig/commit/e60a668e53cd718e910ad4172774f2672e797172) Cleaned clock functions. Fixed compilation on MSVC. ([#1426](https://github.com/synfig/synfig/issues/1426)) [ETL] [core]
- [`f14a5bb`](https://github.com/synfig/synfig/commit/f14a5bbc64e147bd091a75c8572c6ae4b44ba742) Merge PR [#1400](https://github.com/synfig/synfig/issues/1400): Add support for building snap packages
- [`5d56cdc`](https://github.com/synfig/synfig/commit/5d56cdcc1ee24de17007f77bdac335e2c6da5005) Merge PR [#1435](https://github.com/synfig/synfig/issues/1435): Minor cleanup in skeleton files [core]
- [`34d75aa`](https://github.com/synfig/synfig/commit/34d75aaadf70b62e5afa78cdcb74d791d57324b2) Merge PR [#1427](https://github.com/synfig/synfig/issues/1427): [Timetrack] fix in rectangle-selection bottom-top [studio]
- [`b680ec9`](https://github.com/synfig/synfig/commit/b680ec970f1fc28b359816e0376218277b933827) Don't try to delete/move/copy zero waypoints ([#1424](https://github.com/synfig/synfig/issues/1424)) [studio]
- [`0e5aca0`](https://github.com/synfig/synfig/commit/0e5aca00d20380923e6f7ffb02888ca02235a9ca) Fixed smach (state machine) compilation on MSVC ([#1423](https://github.com/synfig/synfig/issues/1423)) [studio]
- [`6d32e5b`](https://github.com/synfig/synfig/commit/6d32e5b21f53cf86bef1a420cbd34debf4aa35e9) hide GUID int constructor ([#1404](https://github.com/synfig/synfig/issues/1404)) [core] [studio]
- [`30a059e`](https://github.com/synfig/synfig/commit/30a059e035768e99fd5eec7d812119f2188de2da) remove unneeded path var [core]
- [`b6efff5`](https://github.com/synfig/synfig/commit/b6efff5fb8e3f7ee91829b24520a4cc2d6b87f32) Merge PR [#1370](https://github.com/synfig/synfig/issues/1370): Soundwave dock now loads sound layers from canvas [studio]
- [`5d873a3`](https://github.com/synfig/synfig/commit/5d873a34c7b9295a059ebed1007af330014140fd) Merge PR [#1408](https://github.com/synfig/synfig/issues/1408): Fixed 'font not found' error in FreeType layers (Fix [#1407](https://github.com/synfig/synfig/issues/1407)) [core]
- [`b5b8239`](https://github.com/synfig/synfig/commit/b5b8239a7b7b1d896e125a2d7c4d7a70b98000e5) Minor cleanup on color dialog ([#1396](https://github.com/synfig/synfig/issues/1396)) [studio]
- [`2349d94`](https://github.com/synfig/synfig/commit/2349d947bbcceafe9dcdc782e2bb8fafb090f91f) PR [#1356](https://github.com/synfig/synfig/issues/1356): Add option to playback animation in realtime [studio]
- [`77164ff`](https://github.com/synfig/synfig/commit/77164ff0d3b2b05476306300fbd57360ce34b478) Some clean up on layer freetype ([#1403](https://github.com/synfig/synfig/issues/1403)) [core]
- [`d972346`](https://github.com/synfig/synfig/commit/d9723460cf84db0363f5afe7ba783f219ac710cf) studio: CMake: Add include & library dirs for each pkg_config module (PR [#1399](https://github.com/synfig/synfig/issues/1399)) [studio]
- [`e8589a5`](https://github.com/synfig/synfig/commit/e8589a5975fff82ed6a13953a4704b93a5e71318) core: CMake: Add include & library dirs for each pkg_config module (PR [#1399](https://github.com/synfig/synfig/issues/1399)) [core]
- [`15a4167`](https://github.com/synfig/synfig/commit/15a41673a92458a735c5945759cb51852b92b4e7) ETL: CMake: Do not install non-existing header (PR [#1399](https://github.com/synfig/synfig/issues/1399)) [ETL]
- [`8dc4c06`](https://github.com/synfig/synfig/commit/8dc4c0642176ec57679cb5b2ac7fdb5897efef23) Merge PR [#1354](https://github.com/synfig/synfig/issues/1354): Make first vertex selectable when creating spline. Fixes [#1281](https://github.com/synfig/synfig/issues/1281). [studio]
- [`251f37a`](https://github.com/synfig/synfig/commit/251f37a0c255ee89beb94b523adc2ec21474bf4b) Merge PR [#1222](https://github.com/synfig/synfig/issues/1222): Warp layer is now renamed to perspective layer [core]
- [`51ba106`](https://github.com/synfig/synfig/commit/51ba10644bd4aab01866bb5a2c8dad4805556e41) Merge PR [#1313](https://github.com/synfig/synfig/issues/1313): Rework the plugin system [studio]
- [`d234429`](https://github.com/synfig/synfig/commit/d23442958d9b5546f9ba1dea21b150e52c424cd3) Moved state machine (smach) from ETL to synfig-studio/src/gui [ETL] [studio]
- [`7480aeb`](https://github.com/synfig/synfig/commit/7480aebdb3a988e38da5c0e08e64c6f75e9df111) fix readable name of Alpha parameter of Radial Composite valuenode [core]
- [`1141307`](https://github.com/synfig/synfig/commit/114130756fc5b43c04b09c11252bfa600a7ada3d) Fix typo in source code [studio]
- [`52eb2c8`](https://github.com/synfig/synfig/commit/52eb2c84ab8c34ca5701648b89241276e6c3d014) Workarea: replace deprecated Gtk::Table ([#1357](https://github.com/synfig/synfig/issues/1357)) [studio]
- [`d2821dd`](https://github.com/synfig/synfig/commit/d2821ddcf1c09f453a0cfca2b7110e8399af6fac) Merge PR [#1373](https://github.com/synfig/synfig/issues/1373): don't let user delete waypoints while dragging them in Timetrack panel [studio]
- [`892c6e2`](https://github.com/synfig/synfig/commit/892c6e2338c1bf2c535180619d6c1099498150fa) Merge PR [#1372](https://github.com/synfig/synfig/issues/1372): don't let user delete waypoints while dragging them in Graph panel [studio]
- [`2ed703e`](https://github.com/synfig/synfig/commit/2ed703e6e6d43265e2b75ebd18156a248c5ed9d8) README: Move list of contrubutors to top, fix "contribute" link.
- [`f7d0565`](https://github.com/synfig/synfig/commit/f7d0565b829f225266487faca04e0c2e6520a748) Added financial contributors to the README
- [`7327b78`](https://github.com/synfig/synfig/commit/7327b78d4e27e0a743a43cccae012f1b1e46ae22) Add link to OpenCollective in FUNDING.yml
- [`788d72d`](https://github.com/synfig/synfig/commit/788d72dea3fb5769bdcf85583a15053ba2031c06) Merge PR [#1344](https://github.com/synfig/synfig/issues/1344): Different look for indirect waypoints [studio]
- [`ccf39ec`](https://github.com/synfig/synfig/commit/ccf39ec9900fbd6835e651630e986e9645c1bbd8) Minor code cleanup trgt_jpeg and mptr_jpeg ([#1343](https://github.com/synfig/synfig/issues/1343)) [core]
- [`b3ae782`](https://github.com/synfig/synfig/commit/b3ae782bc2c234f171c482009cff1d197d87d01e) Show workarea task messages as tooltip too ([#1338](https://github.com/synfig/synfig/issues/1338)) [studio]
- [`8abcd40`](https://github.com/synfig/synfig/commit/8abcd4001cca830379259a6e4b1719c6dc38d53c) Improved generation of recent files list. Fixed MAX_PATH on Windows. ([#1335](https://github.com/synfig/synfig/issues/1335)) [studio]
- [`70989c3`](https://github.com/synfig/synfig/commit/70989c3fda9bd031dbd74178019a3fbfecdc96cf) remove unused #include [core]
- [`d1459cf`](https://github.com/synfig/synfig/commit/d1459cfda8e12e8b01307fb5649aeeef5b87f990) Remove unused CairoImporter method ([#1331](https://github.com/synfig/synfig/issues/1331)) [core]
- [`02eaf8c`](https://github.com/synfig/synfig/commit/02eaf8c033b574c361a8c1b84976908cfe0d3f0f) avoid duplicated dynamic_cast (other cases) ([#1328](https://github.com/synfig/synfig/issues/1328)) [core]
- [`81dc3b6`](https://github.com/synfig/synfig/commit/81dc3b66b7c525aca19782e8b802eb0bb542ef36) Minor fixes for timeplotdata ([#1321](https://github.com/synfig/synfig/issues/1321)) [studio]
- [`da3922e`](https://github.com/synfig/synfig/commit/da3922e92b2356dcb050478341d13e1a440a3af4) Fix uninitialized variable in CairoColor ([#1322](https://github.com/synfig/synfig/issues/1322)) [core]
- [`5a6473b`](https://github.com/synfig/synfig/commit/5a6473b5629ff6a8423df2e687b16d08340bb2f3) Avoid duplicate dynamic cast calls ([#1323](https://github.com/synfig/synfig/issues/1323)) [core]
- [`c9b53c3`](https://github.com/synfig/synfig/commit/c9b53c3c142b2ed56e07246983bde26170492024) Fixed: [CMake Build] Import Image Layer has no icon. ([#1320](https://github.com/synfig/synfig/issues/1320)) [studio]
- [`f584626`](https://github.com/synfig/synfig/commit/f584626f07efbc655800eb5b4af2a81450015718) Fixed compiling with Cairomm 1.15 [studio]
- [`0b9ab1c`](https://github.com/synfig/synfig/commit/0b9ab1c1ce672f826fa1b9bb7d198b5f1b46ce81) prefer nullptr rather NULL or 0 [core]
- [`54c666f`](https://github.com/synfig/synfig/commit/54c666fc54803b3dfef976c5d9b072b82a5beaf2) remove useless Importer::get_frame overloaded method [core]
- [`c157348`](https://github.com/synfig/synfig/commit/c157348d9d0dca81b9b5ddbf2b416e90773b6360) Single Copy Layer visible for Bitmap layers only [studio]
- [`4817575`](https://github.com/synfig/synfig/commit/48175757bfea0999912c3d595c9c6eafa5410224) fix indentation [studio]
- [`fb59acf`](https://github.com/synfig/synfig/commit/fb59acf1638c0b4eb328bb0b8e285f9508493aad) added copyright to vectorizer [studio]
- [`8229068`](https://github.com/synfig/synfig/commit/8229068928bed8a234d41d9f42c75986fe39ec5a) Revert "OSX: brew's coreutils package required for "realpath" command. See https://github.com/whatwg/html-build/issues/90"
- [`91431ee`](https://github.com/synfig/synfig/commit/91431ee6741db839cf357f951e8eeb5bd1d43edf) Do not use "realpath" command in build process (Autotools) [studio]
- [`e32f5b5`](https://github.com/synfig/synfig/commit/e32f5b50b6aae90bf044531d2d954437a535111b) Updated po file [studio]
- [`6cd9585`](https://github.com/synfig/synfig/commit/6cd958553d6b7e2a16a6037aa0cdf8dcf1c1f360) Travis-CI job for translations validation ([#1283](https://github.com/synfig/synfig/issues/1283))
- [`48729c7`](https://github.com/synfig/synfig/commit/48729c71839993fd71c9ddeed1aad92dc9773f93) Merge PR [#1289](https://github.com/synfig/synfig/issues/1289): Export plugins. Closes [#1218](https://github.com/synfig/synfig/issues/1218). [studio]
- [`97acd21`](https://github.com/synfig/synfig/commit/97acd21167910c34c809a4363ea2e7a0746cf0ac) Code cleanup. Added MSVC compiler detection to About dialog. ([#1303](https://github.com/synfig/synfig/issues/1303)) [core] [studio]
- [`11340af`](https://github.com/synfig/synfig/commit/11340afee34da98673f5aa6cc5846f15a86ffda2) Added necessary headers for MSVC [ETL] [core]
- [`abb7beb`](https://github.com/synfig/synfig/commit/abb7beb4ec08f5052c8dcccd125c283d8b196034) Fixed uninitialized members and memory leak in vectorizer ([#1294](https://github.com/synfig/synfig/issues/1294)) [studio]
- [`102dace`](https://github.com/synfig/synfig/commit/102daceabb934a50f2a8d337c950fbba052047f9) Deleted GCC __attribute__ ((unused)) (fixes MSVC compilation) [ETL] [core] [studio]
- [`0acaf30`](https://github.com/synfig/synfig/commit/0acaf30b90b0730dc1f80be9ab47af8f6d8e8e26) Removed unnecessary headers and variables ([#1295](https://github.com/synfig/synfig/issues/1295)) [studio]
- [`faa52c9`](https://github.com/synfig/synfig/commit/faa52c974ba8211f29dde123afcae1f648354245) Merge PR [#1273](https://github.com/synfig/synfig/issues/1273): [MSYS2] Enable building of images (Autotools) [core] [studio]
- [`0739b18`](https://github.com/synfig/synfig/commit/0739b1853c2c4a38d359f2ccd9a45e416dc4a8e3) Update notes about canvas versions. [core]
- [`1db7f4d`](https://github.com/synfig/synfig/commit/1db7f4d4952355dd844a6e0fb4924ecda2f3df3c) add option Link Origins to Draw tool - fix [#344](https://github.com/synfig/synfig/issues/344) [studio]
- [`ae11655`](https://github.com/synfig/synfig/commit/ae11655a9bba068543be7a5df9090958579de78e) Fixed assertion 'GDK_IS_WINDOW (window)' failed ([#1257](https://github.com/synfig/synfig/issues/1257)) [studio]
- [`9be0c34`](https://github.com/synfig/synfig/commit/9be0c34235d4899e937b70ace413bd6c63904fa2) fix uninitialized geometry [studio]
- [`2503cc4`](https://github.com/synfig/synfig/commit/2503cc440f8377a29beaa80f11e9338a5d7f15cd) fix bad overrides reported by Coverity [studio]
- [`d20d830`](https://github.com/synfig/synfig/commit/d20d830c7483d8500f5f821e3eef1af9abb8f9ae) remove unneeded #include [studio]
- [`b57b280`](https://github.com/synfig/synfig/commit/b57b2809af3e52f16bc5d67b351e79fd04d9b222) "Lock Selection" parameter of Group Layer should be static by default ([#1259](https://github.com/synfig/synfig/issues/1259)) [studio]
- [`616ba52`](https://github.com/synfig/synfig/commit/616ba526c7111bdf98d13f97c666a80c34082c0c) 1-setup-linux-native.sh can now use /etc/os-release for better OS detection ([#1263](https://github.com/synfig/synfig/issues/1263))
- [`a12bbfb`](https://github.com/synfig/synfig/commit/a12bbfbee316953834e17d8a0acd134ad5979471) fix missing breaks in switch ([#1268](https://github.com/synfig/synfig/issues/1268)) [studio]
- [`75029fb`](https://github.com/synfig/synfig/commit/75029fb7b942c66eaefbbd5a0fdaa4cb8f4c8624) Merge PR [#1248](https://github.com/synfig/synfig/issues/1248): Restore defaults now reset all settings [studio]
- [`6591875`](https://github.com/synfig/synfig/commit/6591875e830e41352d753a0f9f1b47135fbd31b9) Add FUNDING.yml
- [`70c851e`](https://github.com/synfig/synfig/commit/70c851e9028527208109f7cb49a90576f068d616) Merge PR [#1135](https://github.com/synfig/synfig/issues/1135): New timetrack [studio]
- [`2dbc760`](https://github.com/synfig/synfig/commit/2dbc76041d379ea1232788dd5157a2eb2d5425a7) Merge PR [#1247](https://github.com/synfig/synfig/issues/1247): [CMake] build_images target now places images in the correct folder [studio]
- [`77164e8`](https://github.com/synfig/synfig/commit/77164e8371269afb0490287f200f6c35fe067e88) Fix issue [#1216](https://github.com/synfig/synfig/issues/1216) [studio]
- [`2b82874`](https://github.com/synfig/synfig/commit/2b82874cd336cd72c1b6d5dc2b1c12a5446dc042) Fix issue [#1231](https://github.com/synfig/synfig/issues/1231)
- [`5370add`](https://github.com/synfig/synfig/commit/5370add11d6a2aa6bcf56a64470e39c9041646fd) Merge PR [#1232](https://github.com/synfig/synfig/issues/1232): [CMake] Fixed images search logic in case SYNFIG_ROOT is undefined. [studio]
- [`15ad054`](https://github.com/synfig/synfig/commit/15ad054f18c37c0e36caca3c15b69d25ac51b04d) Fix typos and non translatable strings ([#1162](https://github.com/synfig/synfig/issues/1162)) [core] [studio]
- [`e222ce6`](https://github.com/synfig/synfig/commit/e222ce647dc94d4dc332ddd4f969b1844ee18c8c) Fixed travis-ci warnings
- [`1f08cfc`](https://github.com/synfig/synfig/commit/1f08cfca9c70ea940609324520ecab5559eea885) Remove references to missing translation files ([#1239](https://github.com/synfig/synfig/issues/1239)) [studio]
- [`eb99ee6`](https://github.com/synfig/synfig/commit/eb99ee6b4847b4b4c575ed576aa55fba5a149ba7) New job for running "autobuild/transifex-push-template.sh" ([#1234](https://github.com/synfig/synfig/issues/1234))
- [`b380d8a`](https://github.com/synfig/synfig/commit/b380d8a35d882f5d5d839b396a7d3912b8488c9f) keep undo history clean when deleting multiple curve waypoints ([#1134](https://github.com/synfig/synfig/issues/1134)) [studio]
- [`c3054c4`](https://github.com/synfig/synfig/commit/c3054c4d648783a1877e42801f97d435ba184303) Merge PR [#1228](https://github.com/synfig/synfig/issues/1228): [CMake] Update CMake script for /share and /etc. [studio]
- [`50bab45`](https://github.com/synfig/synfig/commit/50bab454ff238af0a286f7a5a81bb7ef45eca914) Merge PR [#1224](https://github.com/synfig/synfig/issues/1224): [CMake] Updated CMake script to change layout of build files. [core]
- [`9210f30`](https://github.com/synfig/synfig/commit/9210f307e3cf24be53070cc739f52fd8b5e6d48d) Fix typo [studio]
- [`691b81b`](https://github.com/synfig/synfig/commit/691b81b364b7bfc7abc518c2bbc07b8daf804f55) Merge PR [#1201](https://github.com/synfig/synfig/issues/1201): Rename "vizualization" test app to "synfigplayer" [studio]
- [`9e189c3`](https://github.com/synfig/synfig/commit/9e189c35d3167a71048f9b7fe4a16d86f58871b4) Merge PR [#1209](https://github.com/synfig/synfig/issues/1209): fix i18n for Set Keyframe Description dialog [studio]
- [`5390415`](https://github.com/synfig/synfig/commit/5390415e58a9c2229a19aa487b9a945945d83622) Merge PR [#1211](https://github.com/synfig/synfig/issues/1211): Fixed wrong filename in plugins dialog box [studio]
- [`8230752`](https://github.com/synfig/synfig/commit/8230752f2301d94410a36940807762d985549398) Automate Lottie exporter tests using Travis (PR [#1197](https://github.com/synfig/synfig/issues/1197))
- [`a983515`](https://github.com/synfig/synfig/commit/a98351568cfe8bd1403b4dfcf6d817f680b05ae9) Merge PR [#1202](https://github.com/synfig/synfig/issues/1202): allow glade UI files to be translated [studio]
- [`8f89ca2`](https://github.com/synfig/synfig/commit/8f89ca29ee724e59cce0271ef892272c9c68c7a0) Merge PR [#1192](https://github.com/synfig/synfig/issues/1192): upgrade minimum required version of libav/FFmpeg [core]
- [`6c234ce`](https://github.com/synfig/synfig/commit/6c234ce5d078f6cd44be71da6c68f0a5e7ffd5cd) minor fixes for test visualization [studio]
- [`c4ee388`](https://github.com/synfig/synfig/commit/c4ee388ab95f87c55d628399734b7957242f7cf8) time measure for test visualization [studio]
- [`9ea54ae`](https://github.com/synfig/synfig/commit/9ea54ae2ce09b5cd2ff00b559fb0f2bd77243650) simple visualization test [studio]
- [`6af075f`](https://github.com/synfig/synfig/commit/6af075f1fe0ef00a7dbfbbb77bf8c724b2702866) improve warl layer clipping [core]
- [`e2adcad`](https://github.com/synfig/synfig/commit/e2adcad8be02a3580c7af11247c01abbfc02d5e3) blend method Alpha [core]
- [`8af0f3d`](https://github.com/synfig/synfig/commit/8af0f3d41a7734c7a9428fac3dfd09eab3772cf3) draft: degrade underlayer for nonaffine transforms [core]
- [`7edc151`](https://github.com/synfig/synfig/commit/7edc151696dd73f15569b3df6ba4e8b64de20b68) cubic interpolation by default for Warp [core]
- [`9abc9ed`](https://github.com/synfig/synfig/commit/9abc9edef37b3ce4fea50b06609099e440d0f5b9) interpolation param for Warp [core]
- [`650b0cf`](https://github.com/synfig/synfig/commit/650b0cf6a8e15a45ade4014786ba91e19698d5cf) antialias param for CheckerBoard [core]
- [`57b243c`](https://github.com/synfig/synfig/commit/57b243cf78d0ed22957e2292ee4c63610064448a) remove some old rendering from modules [core]
- [`b8aa2b1`](https://github.com/synfig/synfig/commit/b8aa2b1e6d81296fe8a4a4e2cd644eb81bf5d062) remove old rendering from core layers [core]
- [`6b433d2`](https://github.com/synfig/synfig/commit/6b433d2503ed81bd6577c17748d2ae59ce0573c6) add noexcept to move constructor [core]
- [`fc7a046`](https://github.com/synfig/synfig/commit/fc7a046ad041978bf4071d1e15e6dc2e64176d4c) fix calculation of resolution [core]
- [`cf1df92`](https://github.com/synfig/synfig/commit/cf1df92b252699989e3c36ce4406259a1e40ddd3) refactoring of Warp Layer [core]
- [`61ff9b8`](https://github.com/synfig/synfig/commit/61ff9b8d620a045ad454fb55125dc69880c2b317) OptimizerTransformation: merge child into parent [core]
- [`3ae388d`](https://github.com/synfig/synfig/commit/3ae388d8789484ffdb0c14dd6785d4fbece682cf) remove extra const keyword [core]
- [`f44ff0a`](https://github.com/synfig/synfig/commit/f44ff0a64636419ff9d9e223ca355319fd0388e7) improve rendering::Transformation [core]
- [`34a6856`](https://github.com/synfig/synfig/commit/34a6856a6784c0f0959c64c173e0edf55fb15d7f) improve synfig::Matrix [core]
- [`7cea642`](https://github.com/synfig/synfig/commit/7cea64284d1326d05039b76648cf113040889b10) libmng made optional, fixed build using 2-build-cmake.sh [core] [studio]
- [`2cccbf4`](https://github.com/synfig/synfig/commit/2cccbf43557fd68b297a7b4b18b618ea4078581f) Merge PR [#1166](https://github.com/synfig/synfig/issues/1166): Do not require to explicitly call FileSystemTemporary::discard_changes() [core] [studio] 
- [`4df4085`](https://github.com/synfig/synfig/commit/4df4085e997213b6072364e9f36da6ab14746571) Update translations [core] [studio]
- [`09220ed`](https://github.com/synfig/synfig/commit/09220ed3bbae82a2a9f601b554d5b1aea3af3581) Added PACKAGE_NAME macro [studio]
- [`b4b6a75`](https://github.com/synfig/synfig/commit/b4b6a752214c5f56f51788b78f3b71fcfdec2492) Fix some typos and some non translatable strings (#1159) [core] [studio]
- [`30ce7c4`](https://github.com/synfig/synfig/commit/30ce7c4209a618643b26f40144ae9e0bd99c0830) minor fixes for some ValueBase method comments [core]
- [`302b06d`](https://github.com/synfig/synfig/commit/302b06dd4bf726e063f6acd02dff882b76f53751) fix relation operators for ValueBase [core]
- [`2608b0c`](https://github.com/synfig/synfig/commit/2608b0c6ee0533346fba58adac38bfbc3e5a3945) remove unused definitions of libpng versions [core]
- [`f05955a`](https://github.com/synfig/synfig/commit/f05955ae30217fdc3c8d75bb12d85bab454ac89f) add a comment [core]
- [`7b7b2dd`](https://github.com/synfig/synfig/commit/7b7b2dd14dcf8a6bd3e0522b3f90fd139594dd26) synfig::Mutex no longer exists [core]
- [`96306f6`](https://github.com/synfig/synfig/commit/96306f6fc31918377aaecc481f860cf8714f43f4) autotools: remove unused definition [core]
- [`8339ee0`](https://github.com/synfig/synfig/commit/8339ee07b9edc8bd7ad29cdb58fc9e86ba13aee7) Merge PR [#1096](https://github.com/synfig/synfig/issues/1096): remove strange #include in Dialog_Setup [studio]
- [`52d58fa`](https://github.com/synfig/synfig/commit/52d58faa57366f79d86c3d1b26590d9cd042baaf) Merge PR #1157: Fix some ui typos [studio]
- [`2d453f2`](https://github.com/synfig/synfig/commit/2d453f288a651a1142d46f2f45d13850db428e5e) Fix typo [studio]
- [`fe24023`](https://github.com/synfig/synfig/commit/fe240231c01c2bd3102ef901b2001a923cc86095) Fix previous commit [studio]
- [`7c08f5b`](https://github.com/synfig/synfig/commit/7c08f5b8717000a1662754b0ce7d4706873c292d) Fix typo [studio]
- [`d974ed5`](https://github.com/synfig/synfig/commit/d974ed5af43b762a1d9c4e44f4c57cfcd17e562b) Update translations (new pot) [core] [studio]
- [`86eaf56`](https://github.com/synfig/synfig/commit/86eaf560d1eb7f4f3a14391c75a6474997fd051b) Update translations [core] [studio]
- [`b218c01`](https://github.com/synfig/synfig/commit/b218c019070e39afab50f244039575d1f88fac98) Merge PR [#1076](https://github.com/synfig/synfig/issues/1076): define copy constructor if assignment operator is defined [core]
- [`6ebc9a8`](https://github.com/synfig/synfig/commit/6ebc9a8e7402bbdf834a4645837a2b7b27c85069) Merge PR [#1105](https://github.com/synfig/synfig/issues/1105): Fixed MLT build on MSYS via autobuild/build.sh script
- [`e8281c6`](https://github.com/synfig/synfig/commit/e8281c679184cf9e9e6a7554ccaac0a5bff761a2) Merge PR [#1034](https://github.com/synfig/synfig/issues/1034): there is no reason for using float instead of Real[core]
- [`00e3c96`](https://github.com/synfig/synfig/commit/00e3c96c42a756666610a12c853e3784792b7b9c) Temporarily disable distcheck (as it exceeds build time)
- [`58cf959`](https://github.com/synfig/synfig/commit/58cf959a34436bcf4b54acfd476f179c821f61f9) remove unused code : commented since 2005 [studio]
- [`859cc1a`](https://github.com/synfig/synfig/commit/859cc1a3a720dae09cd61e76cbe567a93e85ce3e) Merge PR [#1128](https://github.com/synfig/synfig/issues/1128): Travis: Add distcheck job [core] [studio]
- [`0da5999`](https://github.com/synfig/synfig/commit/0da59994cb17c895771e237a2c1f3897d1223ff2) remove test for (removed) etl::loose_smart_ptr [ETL]
- [`ee74a24`](https://github.com/synfig/synfig/commit/ee74a24c8ae4d8295d1e1c1ef5b9c5bf478271ce) Bump version to 1.5.0 [ETL] [core] [studio]
